/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import org.w3c.dom.Element;
import writer2latex.bibtex.BibTeXDocument;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXConfig;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.util.Context;
import writer2latex.office.BibMark;
import writer2latex.office.OfficeReader;
import writer2latex.util.Misc;

public class BibConverter
extends ConverterHelper {
    private BibTeXDocument bibDoc;

    public BibConverter(OfficeReader ofr, LaTeXConfig config, ConverterPalette palette) {
        super(ofr, config, palette);
    }

    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        if (this.config.useBibtex() && this.config.useNatbib()) {
            pack.append("\\usepackage");
            if (this.config.getNatbibOptions().length() > 0) {
                pack.append("[").append(this.config.getNatbibOptions()).append("]");
            }
            pack.append("{natbib}").nl();
        }
    }

    public void handleBibliography(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (this.config.noIndex()) {
            return;
        }
        if (this.config.useBibtex()) {
            ldp.append("\\bibliographystyle{").append(this.config.bibtexStyle()).append("}").nl();
            if (this.config.externalBibtexFiles().length() > 0) {
                ldp.append("\\bibliography{").append(this.config.externalBibtexFiles()).append("}").nl();
            } else {
                if (this.bibDoc == null) {
                    this.bibDoc = new BibTeXDocument(this.palette.getOutFileName(), false);
                }
                ldp.append("\\bibliography{").append(this.bibDoc.getName()).append("}").nl();
            }
        } else {
            Element body = Misc.getChildByTagName(node, "text:index-body");
            if (body != null) {
                Element title = Misc.getChildByTagName(body, "text:index-title");
                if (title != null) {
                    this.palette.getBlockCv().traverseBlockText(title, ldp, oc);
                }
                this.palette.getBlockCv().traverseBlockText(body, ldp, oc);
            }
        }
    }

    public void handleBibliographyMark(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (this.config.useBibtex()) {
            String sIdentifier = node.getAttribute("text:identifier");
            if (sIdentifier != null) {
                if (this.config.externalBibtexFiles().length() == 0) {
                    if (this.bibDoc == null) {
                        this.bibDoc = new BibTeXDocument(this.palette.getOutFileName(), false);
                    }
                    if (!this.bibDoc.containsKey(sIdentifier)) {
                        this.bibDoc.put(new BibMark(node));
                    }
                }
                ldp.append("\\cite{").append(this.config.externalBibtexFiles().length() == 0 ? this.bibDoc.getExportName(sIdentifier) : sIdentifier).append("}");
            }
        } else {
            this.palette.getInlineCv().traverseInlineText(node, ldp, oc);
        }
    }

    public BibTeXDocument getBibTeXDocument() {
        return this.bibDoc;
    }
}

