/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.util.Enumeration;
import java.util.Hashtable;
import writer2latex.office.OfficeReader;
import writer2latex.office.OfficeStyleFamily;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.CSVList;
import writer2latex.util.ExportNameCollection;
import writer2latex.xhtml.Converter;
import writer2latex.xhtml.FrameStyleConverter;
import writer2latex.xhtml.StyleInfo;
import writer2latex.xhtml.XhtmlConfig;
import writer2latex.xhtml.XhtmlStyleMap;

public class PresentationStyleConverter
extends FrameStyleConverter {
    String sCurrentOutlineStyle = null;
    Hashtable<String, String[]> outlineStyles = new Hashtable();
    ExportNameCollection outlineStyleNames = new ExportNameCollection(true);

    public PresentationStyleConverter(OfficeReader ofr, XhtmlConfig config, Converter converter, int nType) {
        super(ofr, config, converter, nType);
        this.styleMap = new XhtmlStyleMap();
    }

    public String getClassNamePrefix() {
        return "prsnt";
    }

    public OfficeStyleFamily getStyles() {
        return this.ofr.getPresentationStyles();
    }

    public String getDefaultTagName(StyleWithProperties style) {
        return "div";
    }

    public String getStyleDeclarations(String sIndent) {
        if (this.bConvertStyles) {
            StringBuffer buf = new StringBuffer();
            buf.append(super.getStyleDeclarations(sIndent));
            Enumeration<String> names = this.outlineStyleNames.keys();
            while (names.hasMoreElements()) {
                String sDisplayName = names.nextElement();
                StyleWithProperties style = (StyleWithProperties)this.getStyles().getStyleByDisplayName(sDisplayName);
                if (style.isAutomatic()) continue;
                CSVList props = new CSVList(";");
                this.getFrameSc().cssMargins(style, props, true);
                this.getParSc().cssPar(style, props, true);
                this.getTextSc().cssTextCommon(style, props, true);
                if (props.isEmpty()) continue;
                buf.append(sIndent).append("li.outline").append(this.styleNames.getExportName(sDisplayName)).append(" p {").append(props.toString()).append("}").append(this.config.prettyPrint() ? "\n" : " ");
            }
            return buf.toString();
        }
        return "";
    }

    public void enterOutline(String sStyleName) {
        this.sCurrentOutlineStyle = sStyleName;
        if (!this.outlineStyles.containsKey(this.sCurrentOutlineStyle)) {
            String[] sNames = new String[10];
            this.outlineStyles.put(this.sCurrentOutlineStyle, sNames);
            StyleWithProperties style1 = this.ofr.getPresentationStyle(this.sCurrentOutlineStyle);
            if (style1 != null) {
                String sName;
                StyleWithProperties style;
                String sCurrentOutlineStyle1 = this.sCurrentOutlineStyle;
                if (style1.isAutomatic()) {
                    sCurrentOutlineStyle1 = style1.getParentName();
                }
                sNames[1] = sCurrentOutlineStyle1;
                String sBaseName = sCurrentOutlineStyle1.substring(0, sCurrentOutlineStyle1.length() - 1);
                for (int i = 2; i < 10 && (style = this.ofr.getPresentationStyle(sName = sBaseName + Integer.toString(i))) != null && style.getParentName().equals(sNames[i - 1]); ++i) {
                    sNames[i] = sName;
                }
                sNames[1] = null;
            }
        }
    }

    public void exitOutline() {
        this.sCurrentOutlineStyle = null;
    }

    public void applyOutlineStyle(int nLevel, StyleInfo info) {
        if (2 <= nLevel && nLevel <= 9 && this.sCurrentOutlineStyle != null && this.outlineStyles.containsKey(this.sCurrentOutlineStyle)) {
            info.sClass = "outline" + this.outlineStyleNames.getExportName(this.outlineStyles.get(this.sCurrentOutlineStyle)[nLevel]);
        }
    }
}

