.\"
.\" Adapted from README.Playing -- how to operate the okbridge program
.\" Matthew Clegg.  September 1990.  Updated May 1991, May 1992.
.\"
.TH "OKSHUFFLE" 6 "4 Aug 1992"
.SH NAME
okshuffle \- create unplayed shuffled boards for okbridge
.br
oktally \- merge played boards for okbridge
.SH SYNPOSIS
.in +10n
.ti -10n
okshuffle
.I nboards
[\fB\-dimr\fP]
[\fB\-n\fP \fIname\fP]
.in -10n
.in +8n
.ti -8n
oktally
[\fB\-c\fP]
[\fB\-i\fP]
[\fB\-l\fP]
[\fB\-m\fP]
[\fB\-p\fP \fIplayername\fP]
[\fB\-sn\fP]
[\fB\-t[b]\fP]
[\fB\-z\fP] files
.in -8n
.SH DESCRIPTION
.I Okshuffle
creates a set of unplayed shuffled boards for use with
.IR okbridge (6).
The
.I nboards  
parameter is the number of boards to shuffle.  If this is omitted,
then 4 is assumed. Output is to stdout.
.PP
.I Oktally
merges a number of boards that have already been played.
It reads each of the given files; if one of the file names is
"-", then standard input is read instead.  It then merges the boards
from these files and totals the match points for each pair.  It writes
the merged set of boards to standard output.  By default, the output
format displays only the results of play for each board.
.SH "OKSHUFFLE OPTIONS"
.IP "\fB-dimr\fP"
Specifies a scoring mode respectively of duplicate, IMP, match point
or rubber scoring.
.IP "\fB-n\fP \fIname\fP"
Specifies a brief (10 character) name which will be used for identifying
the set of boards.
.SH "OKTALLY OPTIONS"
.IP "\fB-c\fP
If given, writes an encoded email duplicate file as output.
.IP "\fB-i\fP
Sorts the output play records by IMPs.  The default is to sort by match
points.
.IP "\fB-l\fP
Writes each board in a long format which is similar to that found in
bridge literature.
.IP "\fB-m\fP
Does a selective merge.  Boards appearing in the second and succeeding
files which do not appear in the first file are ignored.
.IP "\fB\-p\fP \fIplayername\fP"
Only considers boards which have been played by \fIplayername\fP.
.IP "\fB-s\fP\fIn\fP"
If given, then \fIn\fP is read as a positive integer which specifies
the number of boards to skip in the input files.
.IP "\fB\-t[b]\fP"
Output the total scores by player, sorted in decreasing order.
If the \fBb\fP option is given, then both match point and IMP scores
are printed.
.IP "\fB-z\fP"
Writes each board out in a compact format which was first introduced by
Shangyou Zhang.

.SH "SEE ALSO"
okbridge(6)
.SH AUTHOR
.PP
Matthew Clegg, mclegg@cs.ucsd.edu.
.PP
Man pages adapted by George Ferguson,
.br
ferguson@cs.rochester.edu.
