# Informix 4GL program to do mwc database work
# By Charles Fiterman of Mark Williams 5/17/90

DATABASE mwc

GLOBALS "globals0.4gl"

# open forms and call main menu

MAIN
	CALL get_usr() RETURNING user_id # Get user id
	IF user_id = "unknown" THEN
		DISPLAY ""
		DISPLAY "Cannot find real user name"
		DISPLAY ""
		EXIT PROGRAM
	END IF	 

	OPTIONS MESSAGE LINE 22,
		PROMPT LINE 21,
		DELETE KEY CONTROL-V,
		NEXT KEY CONTROL-N,
		PREVIOUS KEY CONTROL-P

	CALL show_menu()

	CLEAR SCREEN
END MAIN

# Select which database to play with.
# All informix programs are very large about 250K on disk
# It makes sense to put them together.

FUNCTION show_menu()
	MESSAGE "Type the first letter of the option you want to select."

	MENU "MAIN"
	COMMAND "Inv" "Invoice database"
		OPEN FORM big_form FROM "mainline"
		CALL invoice_menu()
		CLOSE FORM big_form
	COMMAND "Base" "Shippers, Terms, Products and mags"
		RUN "base.4ge"
	COMMAND "Date" "Ship date"
		OPEN FORM sdate FROM "shipdate"
		CALL mship_date()
		CLOSE FORM sdate
	COMMAND "Crdt" "Credit memos"
		RUN "credit.4ge credit"
	COMMAND "Wnd" "Wand data"
		OPEN FORM wand_form FROM "wand"
		CALL wand_data()
		CLOSE FORM wand_form
	COMMAND "Pay" "Payments"
		RUN "credit.4ge payment"
	COMMAND "Auth" "Return authorization"
		RUN "credit.4ge auth"
	COMMAND "Reg" "Enter registration cards"
		OPEN FORM reg_form FROM "regcard"
		OPEN FORM mail_form FROM "mailer"
		CALL reg_base()
		CLOSE FORM reg_form
		CLOSE FORM mail_form
	COMMAND "Nreg" "Enter new registration cards"
		OPEN FORM reg_form FROM "newreg"
		OPEN FORM mail_form FROM "mailer"
		CALL nreg_base()
		CLOSE FORM reg_form
		CLOSE FORM mail_form
	COMMAND "Mail" "Mailer database"
		OPEN FORM mail_form FROM "mailer"
		CALL mail_menu()
		CLOSE FORM mail_form
	COMMAND "UPS" "UPS tables"
		RUN "ups.4ge"
	COMMAND "Exit" "Leave the database menu"
		EXIT MENU
	END MENU
END FUNCTION
