#
# Produce selective mailers.
# Put count after file end marker
#
DATABASE mwc
#
# Produce mailing lists set up by mailcalc
#
GLOBALS
	DEFINE  a RECORD LIKE address.*
	DEFINE	c RECORD LIKE customer.*
	DEFINE  w RECORD LIKE workf.*
END GLOBALS

MAIN
	DECLARE curs CURSOR FOR
	 SELECT address.*, workf.*, customer.contact
	   FROM workf, address, customer
	  WHERE workf.tbl <> 11
	    AND address.cust_no = workf.cust_no
	    AND	address.add_type <> "s"
	    AND	customer.cust_no = address.cust_no

	START REPORT mail_list

	FOREACH curs INTO a.*, w.*, c.contact
		IF a.country IS NULL THEN	# prevent control breaks
			LET a.country = "-"
		END IF

		IF a.zipcode IS NULL THEN	# prevent control breaks
			LET a.zipcode = "-"
		END IF

	    	IF   a.country == "GERMANY"
	    	  OR a.country == "JAPAN"
	    	  OR a.country == "HOLLAND"
	    	  OR a.country == "ENGLAND"
		  OR a.country == "SCOTLAND"
		  OR a.country == "GREECE"
		  OR a.country == "NORWAY"
	    	  OR a.country == "SPAIN" 	THEN
#			CONTINUE FOREACH
		END IF

		OUTPUT TO REPORT mail_list(c.contact, a.*, w.*)
	END FOREACH

	FINISH REPORT mail_list

	CLOSE curs
END MAIN

REPORT mail_list(contact, a, w)
	DEFINE	contact CHAR(38)
	DEFINE  a RECORD LIKE address.*
	DEFINE  w RECORD LIKE workf.*
	DEFINE  s1 CHAR(100)

	OUTPUT
		REPORT TO "mail.cm"
		LEFT MARGIN 0
		TOP MARGIN 0
		BOTTOM MARGIN 0

	ORDER BY a.country, a.zipcode, a.cust_no

	FORMAT
	ON EVERY ROW
		IF a.country = "-" THEN
			LET a.country = NULL
		END IF

		IF a.zipcode = "-" THEN
			LET a.zipcode = NULL
		END IF

		CALL addline(a.*) RETURNING s1
		PRINT	w.cust_no USING "<<<<<<", ",", 
			w.last_date, ",", w.tbl using "<<<"
		PRINT	contact CLIPPED, ",",
			a.line1 CLIPPED, ",",
			a.line2 CLIPPED, ",",
			a.line3 CLIPPED, ",",
			s1 CLIPPED, ",",
			a.country CLIPPED
END REPORT

#
# Create city, state zip address line.
#
FUNCTION addline(a)
	DEFINE a RECORD LIKE address.*
	DEFINE w CHAR(80)

	IF a.zipcode IS NOT NULL THEN
		LET w = a.zipcode CLIPPED
	ELSE
		LET w = NULL
	END IF

	IF a.state IS NOT NULL THEN
		LET w = a.state CLIPPED, " ", w CLIPPED
	END IF

	IF a.city IS NOT NULL THEN
		LET w = a.city CLIPPED, " ", w CLIPPED
	END IF

	RETURN w
END FUNCTION
