#
# Count the number of customers who bought COHERENT but who do *not*
# have version 4.2
# 
# by fwb, 3/10/94
#
DATABASE mwc

MAIN
	DEFINE cust_number LIKE customer.cust_no
	DEFINE cust_total INTEGER
				# all customers who meet criteria
	DEFINE cust_no_42 INTEGER
	                        # total number of customer who have *not*
				# purchased a 4.2-related product
	DEFINE total_42_bought INTEGER
	                        # number of 4.2-related products
				# a given customer has purchased

# find every customer who's bought COHERENT before release 4.2
	DECLARE curs_customer CURSOR FOR
	SELECT	UNIQUE invoice.cust_no
	FROM	invoice, inv_line, customer, address
	WHERE	inv_line.prod_no IN (1, 2, 26, 27, 44, 45, 60, 61)
			AND
		inv_line.invoice_no = invoice.invoice_no
			AND
		invoice.cust_no = customer.cust_no
			AND
		(customer.all_nfo IS NULL
			OR
		(customer.all_nfo != "x"
			AND
		 customer.all_nfo != "X"))
 			AND
		(customer.cust_no = address.cust_no
			AND
		 address.country IS NULL)

	LET cust_no_42 = 0
	LET cust_total = 0

        FOREACH curs_customer INTO cust_number
            LET cust_total = cust_total + 1
            LET total_42_bought = 0

	    SELECT
                COUNT(*)
                INTO    total_42_bought
                FROM    invoice, inv_line
                WHERE   invoice.cust_no = cust_number
                            AND
                        invoice.invoice_no = inv_line.invoice_no
			    AND
                        inv_line.prod_no IN (94, 95, 98, 99, 113,
				114, 107, 108, 109, 110, 115, 116,
			        117, 118, 256, 257)

	    IF total_42_bought = 0 THEN
                LET cust_no_42 = cust_no_42 + 1
            END IF
        END FOREACH

        DISPLAY "Total number of customers of COHERENT, pre-4.2: ",
		cust_total 
        DISPLAY "Customers of COHERENT who do NOT have 4.2: ", cust_no_42
END MAIN
