/*
 * Format Informix output for printing of invoices.
 */
#include <stdio.h>
#include "printer.h"
/*
 * Data fields from input.
 */
static char contact[40];
static struct addr {
	char lines[5][52];
} s_addr, b_addr;
static char phone_no[40];
static char invoice_date[12];
static char invoice_no[12];
static char cust_no[12];
static char terms[8];
static char card_no[22];
static char exp_date[10];
static char ref_no[12];
static char tym_flag[2];
static char ship_name[16];
static char icomments[52];
static char subtotal[12];
static char taxes[12];
static char ship_amt[12];
static char cod_amt[12];
static char discount[12];
static char total[12];
static char user_id[12];

static char quantity[10][10];
static char prod_name[10][61];
static char price[10][12];
static char rtot[10][12];

static int i, fullsw, ups_sw;
static enum posw {
	no_comment, comment_not_po, comment_is_po, comment_plus_po
} posw;
static char po_no[52];
static char addpo_no[52];

static char barCode[]   = "\033(0Y\033(s0p4.6h16v0s0b0T";
/*
#ifdef LASERII
static char courier[] = "\033(8U\033(s0p16.6h9.5v0s3b6T";
static char lpi8[] = "\033&l8D\033&l0O";
#else
*/
static char courier[] = "\033(8U\033(s0p12h12v0s0b6T";
static char bold[]    = "\033(8U\033(s0p10h12v0s1b6T";
static char huge_font[]    = "\033&l0O\033(0U\033(s1p14.4v0s1b4T";
/*
#endif
*/
static char resetFont[] = "\033E";
/*
 * Get a line and exit at end of file.
 */
char *
mgets(s)
char *s;
{
	if(NULL == gets(s)) {
		printf(resetFont);
		exit(0);
	}
	return(s);
}

/*
 * print a diviiding line.
 */
printdiv()
{
	register int i;

	for (i = 0; i < 80; i++)
		putchar('_');
	putchar('\n');
	putchar('\n');
}

void
to40(line, next)
char *line, *next;
{
	register col;

	if(!*line && !*next)
		return;
	col = strlen(line);
	printf("%s", line);
	while(col < 40) {
		col |= 7;
		col++;
		putchar('\t');
	}
	puts(next);
}

void
printa()
{
	int longest_line, length, barcode_lines, i, j;

/* print the first part of the form:  the return address */
	mwlogo(0, 0, 150.0);
	mv2xy(0, 0);
	printf("\n\tFrom:\n");
	printf("\tMark Williams Company %s*%s*%s\n", barCode, cust_no, courier);
	printf("\t60 Revere Drive       %s*%s*%s\n", barCode, cust_no, courier);
	printf("\tNorthbrook, IL 60062  %s*%s*%s\n", barCode, cust_no, courier);

	if (!ups_sw)
		printf("\n\n\n\n\n");
	else {
		printf("\t**********************\n");
		printf("\t* UPS SHIPPER NUMBER *\n");
		printf("\t*     IL 612-750     *\n");
		printf("\t*   PKG ID # %6.6s  *\n", invoice_no);
		printf("\t**********************\n");
	}

	printdiv();

/* print the second part of the form:  the user's name and address */
/* print the customer's name */	
	if (comment_is_po == posw || comment_plus_po == posw)
		printf("%s  %s\n", po_no + 5, contact);
	else
		printf("To:     %s\n", contact);

/* find the longest line in the address */
	longest_line = 0;
	for (i = 0; i < 5; i++)
		if ((length = strlen(s_addr.lines[i])) > longest_line)
			longest_line = length;

/* the bar code must have at least three lines.  The address has an
 * indefinite number of lines, from one to five.  Hence the convolutions
 * seen below. */
	for (barcode_lines = 0, i = 0; i < 5; i++) {
		length = strlen(s_addr.lines[i]);
		if (length)
			printf("\t%s", s_addr.lines[i]);

		if (barcode_lines < 3) {
			if (!length)
				printf("\t");
			for (j = length; j < longest_line + 1; j++)
				printf(" ");
			printf("%s*%s*%s", barCode, invoice_no, courier);
			barcode_lines++;
		}
		printf("\n");
	}
}

/*
 * Extract PO# number from comments field and set posw.
 */
void
icom()
{
	char work[80], *p, *q, c;
	enum state { start, P, O, sp, no } state;

	addpo_no[0] = 0;
	for(state = start, p = icomments, q = work;;) {
		if(!(c = *p++))
			state = no;
		switch(state) {
		case start:
			if('P' != c)
				continue;
			state = P;
			break;
		case P:
			if('O' != c) {
				q = work;
				state = start;
				continue;
			}
			state = O;
			break;
		case O:
			if('#' != c) {
				q = work;
				state = start;
				continue;
			}
			state = sp;
			break;
		case sp:
			if(' ' == c)
				break;
			state = no;
			posw = comment_is_po;
			break;
		case no:
			if(c && ' ' != c)
				break;
			*q = '\0';
			if(!icomments[0])
				posw = no_comment;
			else if(comment_is_po != posw)
				posw = comment_not_po;
			else if(strcmp(work, icomments))
				posw = comment_plus_po;
			sprintf(po_no, "Ship To:  %s", work);
			sprintf(addpo_no, "%s", work);
			return;
		}
	*q++ = c;
	}
}
static void
showCard(obscureCard)
{
	if (!card_no[0])
		return;

	if (obscureCard)	/* mung the card number */
		printf("card no %.8sXXXXXXXX XXXX ref %s",
			card_no, ref_no);
	else		/* show the card number */
		printf("card no %s %s ref %s",
			card_no, exp_date, ref_no);
}

void
printb(name, obscureCard)
char *name;
{
	char cBuf[2][100];

	if(comment_is_po == posw || comment_plus_po == posw)
		to40("Bill To:", po_no);
	else
		to40("Bill To:", "Ship To:");

	to40(b_addr.lines[0], contact);
	to40(b_addr.lines[1], s_addr.lines[0]);
	to40(b_addr.lines[2], s_addr.lines[1]);
	to40(b_addr.lines[3], s_addr.lines[2]);
	to40(b_addr.lines[4], s_addr.lines[3]);
	to40("", s_addr.lines[4]);

	printf("\nDate: %s Terms: %s ", invoice_date, terms);
	if (tym_flag[0] > '0') {
		showCard(obscureCard);

		if ('3' != tym_flag[0]) {
			printf("\n%sTRANSACTION NOT APPROVED%s -- ",
				bold, courier);

			switch(tym_flag[0]) {
			case '1':
				printf("not sent yet");
				break;
			case '2':
				printf("awaiting reply");
				break;
			case '4':
				printf("disaproved");
				break;
			case '5':
				printf("new void");
				break;
			case '6':
				printf("voided");
				break;
			case '7':
				printf("dissaproved void");
				break;
			case '8':
				printf("void in transit");
				break;
			case '9':
				printf("on backorder");
				break;
			default:
				printf("unknown tym_flag '%c'", tym_flag[0]);
			}
		}
	}
	else if (card_no[0])
		printf("card no %s %s", card_no, exp_date);

	printf("\n%s By %s %sinvoice # %s%s customer # %s\n",
		phone_no, ship_name, bold, invoice_no, courier, cust_no);
	if(comment_plus_po == posw || comment_not_po == posw)
		printf("Comments: %s\n", icomments);
	printf("\nQuantity\tDescription\t\t\t\tUnit Price\tTotal\n");
	
	for(i = 0; i < 10; i++) {
		if(!quantity[i][0])
			break;
		printf("%s %-49.49s%s %s\n",
			quantity[i], prod_name[i], price[i], rtot[i]);
	}

	/*
	 * Either display 'name' at the bottom or
	 * the invoice_no in bar code.
	 */
	if (name[0]) {
		strcpy( cBuf[0],      "\t\t\t\t\t\t\t");
		sprintf(cBuf[1],   "%8.8s\t\t\t\t\t\t", name);
	}
	else {
		sprintf(cBuf[0], "%s*%s*%s\t\t\t\t\t", 
			barCode, invoice_no, courier);
		strcpy(cBuf[1], cBuf[0]);
	}

	printf(	       "\n%sSubtotal  %s\n", cBuf[0], subtotal);
	if(ship_amt[0])
		printf(  "%sShipping    %s\n", cBuf[0], ship_amt);
	if(cod_amt[0])
		printf(  "%sCod Charge    %s\n", cBuf[0], cod_amt);
	if(taxes[0])
		printf(  "%s   Taxes  %s\n", cBuf[0], taxes);
	if(discount[0])
		printf(  "%sDiscount  %s\n", cBuf[0], discount);
	printf("%s%sTotal  %s%s\n", cBuf[1], bold, total, courier);
}

findstr(s1, s2)
char *s1, *s2;
{
	register char *p, *q, c;

	for(; *s1; s1++) {
		for(q = s1, p = s2; c = *p; p++, q++)
			if(c != *q)
				break;
		if(!c)
			return(1);
	}
	return(0);
}

void
printc()
{
	register 	i;
	unsigned	uVert, uHor;
	unsigned	uDotsH = 2400, 	/* Dots per line */
			uCharLine = 80;	/* Characters per line */
	int		iTmp1, iTmp2, iTmp3;

	if(no_comment == posw ||
	   comment_not_po == posw ||
	   '9' == tym_flag[0])
		return;

	mwlogo(0, 0, 250.0);

	mv2xy(1900, 150);
	printf("%sINVOICE %s%s", huge_font, invoice_no, courier);
	PrintLine(1800, 40, 600, 180, 20);

	mv2xy(320, 50);
	printf("%sMark Williams Company%s", huge_font, courier);
	mv2xy(320, 100);
	printf("60 Revere Drive", "");
	mv2xy(320, 150);
	printf("Northbrook, IL 60062");
	mv2xy(320, 220);
	printf("Phone: (708) 291 - 6700");
	mv2xy(370, 270);
	printf("Fax: (708) 291 - 6750");
	PrintLine(0, 320, uDotsH, 10, 100);

	uHor = 1350;
	uVert = 450;

	mv2xy(0, uVert);
	printf("%sBill To:", bold);
	mv2xy(uHor, uVert);
	printf("Ship To:%s", courier);

	for (i = 0; i < 6; i++) {
		uVert += 50;
		if (i == 0) {
			mv2xy(0, uVert);
			printf("%s", b_addr.lines[i]);
			mv2xy(uHor, uVert);
			printf("%s", contact);
			continue;
		} 
		if (i == 5) {
			mv2xy(uHor, uVert);
			printf("%s", s_addr.lines[i -1]);
			break;
		} 			
		mv2xy(0, uVert);
		printf("%s", b_addr.lines[i]);
		mv2xy(uHor, uVert);
		printf("%s", s_addr.lines[i - 1]);
	}

	iTmp1 = strlen(invoice_date) + strlen(terms) + strlen(addpo_no) + 22;
	iTmp2 = (uDotsH - iTmp1 * uDotsH / uCharLine) / 2;

	uVert +=150;
	PrintLine(0, uVert, uDotsH, 15, 20);
	PrintLine(0, uVert, iTmp2, 150, 20);
	PrintLine(uDotsH - iTmp2, uVert, iTmp2, 150, 20);
	uVert += 100;
	iTmp2 += 3 * uDotsH / uCharLine;
	mv2xy(iTmp2, uVert);
	printf("Date: %s.   Terms: %s.   %s%s%s.", invoice_date, terms, bold,
					addpo_no, courier);
	uVert += 50;
	PrintLine(0, uVert, uDotsH, 15, 20);

	uVert +=200;
	if (card_no[0]) {
		mv2xy(0, uVert);
		printf(" Card no %s. Expiration date is %s", card_no, exp_date);
		uVert += 200;
	}
	
	if (comment_plus_po == posw || comment_not_po == posw) {
		mv2xy(0, uVert);
		printf("Comments: %s", icomments);
		uVert += 200;
	}
	mv2xy(0, uVert);

	printf("Quantity\tDescription\t\t\t\t\t\tUnit Price\tTotal");
	uVert += 140;
	
	for(i = 0; i < 10; i++) {
		mv2xy(0, uVert);
		if(!quantity[i][0])
			break;
		printf("%s\t\t%-53.53s%s  %s",
			quantity[i], prod_name[i], price[i], rtot[i]);
		uVert += 70;
	}
	
	uVert += 70;
	iTmp1 = 1810;
	mv2xy(iTmp1, uVert);
	printf("Subtotal  %s", subtotal);

	if(ship_amt[0]) {
		uVert += 70;
		mv2xy(0, uVert);
		printf("\t\t%s", ship_name);
		mv2xy(iTmp1, uVert);
		printf("Sh. & Hand. %s", ship_amt);
	}
	if(cod_amt[0]) {
		uVert += 70;
		mv2xy(iTmp1, uVert);
		printf("Cod Charge%s", cod_amt);
	}
	if(taxes[0]) {
		uVert += 70;
		mv2xy(iTmp1, uVert);
		printf("Taxes     %s", taxes);
	}
	if(discount[0]) {
		uVert += 70;
		mv2xy(iTmp1, uVert);
		printf("Discount  %s", discount);
	}
	uVert += 140;
	mv2xy(iTmp1, uVert);
	printf("%sTotal  %s%s", bold, total, courier);
	uVert += 150;
	PrintLine(0, uVert, uDotsH, 100, 20);
	uVert += 70;
	mv2xy(300, uVert);
	printf("%sFederal ID # 36-6074873%s", bold, courier);
	mwlogo(1500, uVert - 50, 60.0);
	mv2xy(1600, uVert);
	printf("Mark Williams Company");
	putchar(12);	/* form feed */
}

/*
 * Read in data and call print routines.
 */
main()
{
	int	j;

	printf(resetFont);
#ifdef LASERII
	printf(lpi8);
#endif
	printf(courier);

	for(;;) {
		if(!strcmp(mgets(contact), "***")) {
			printf(resetFont);
			exit(0);
		}
		for (i = 0; i < 5; i++) 
			*s_addr.lines[i] = *b_addr.lines[i] = 0;
		for (i = j = 0; i < 5; i++)
			if (*mgets(s_addr.lines[j]))
				j++;
		for (i = j = 0; i < 5; i++) {
			if (!strcmp(mgets(b_addr.lines[j]), "**-")) {
				*b_addr.lines[j] = 0;
				break;
			}
			if (*b_addr.lines[j])
				j++;
		}
		
		
		mgets(phone_no);
		mgets(invoice_date);
		mgets(invoice_no);
		mgets(cust_no);
		mgets(terms);
		mgets(card_no);
		mgets(exp_date);
		mgets(ref_no);
		mgets(tym_flag);
		mgets(ship_name);
		ups_sw = (('U' == ship_name[0]) &&
			  ('P' == ship_name[1]) &&
			  ('S' == ship_name[2]));
		mgets(icomments);
		icom();
		mgets(subtotal);
		mgets(taxes);
		mgets(ship_amt);
		mgets(cod_amt);
		mgets(discount);
		mgets(total);
		mgets(user_id);
		/* get item lines */
		for(fullsw = i = 0; i < 10; i++) {
			if(!strcmp(mgets(quantity[i]), "***")) {
				quantity[i][0] = 0;
				break;
			}
			fullsw |= findstr(mgets(prod_name[i]), "Coherent");
			mgets(price[i]);
			mgets(rtot[i]);
		}
/* A portion of the form - return address and user's name and address */
		printa();
		printdiv();
/* B portion of the form - the user's invoice */
		printb("INVOICE", 1);
/* draw a line */
/*
		printdiv();
*/
/* Gerson's invoice - soon to be dropped */
/*
		printb("", 0);
*/

/* output a new page */
		putchar(12);

/* C portion of the form - the file copy of the invoice */
		if (tym_flag[0] != '9') { /* not on backorder */
/*
			printb(user_id, 0);
			putchar(12);
			printc();
*/
		}
	}
}
