# For some reason unknown to me, the SCO build program, unloadmwc.4gl
# can not unload the cmemo, invoice and shipreg tables from the mwc
# database. This program will copy the data from these tables into new
# tables which hopefully, will be handled by unloadmwc.4gl.

DATABASE mwc

MAIN

	DEFINE	binv		RECORD LIKE invoice.*,
		bshipreg	RECORD LIKE shipreg.*,
		bcmemo		RECORD LIKE cmemo.*

	WHENEVER ERROR CONTINUE
		DROP TABLE Bcmemo
		DROP TABLE Bshipreg
		DROP TABLE Binvoice
	WHENEVER ERROR STOP

CREATE TABLE Bcmemo (
	memo_no		SERIAL(10000),	# credit memo number
	memo_date	DATE,		# credit memo date
	invoice_no	INTEGER,	# invoice number
	auth_no		INTEGER,	# return authorization no
	amount		MONEY(8, 2),	# credit amount
	com1		CHAR(50),	# comment
	com2		CHAR(50),
	batch_ix	SMALLINT,	# credit card entry
	ref_no		INTEGER,
	cap_no		INTEGER,
	tym_flag	SMALLINT
)

CREATE TABLE Binvoice (
	invoice_no	SERIAL(20000),	# invoice number
	cust_no		INTEGER,
	invoice_date	DATE,
	icomments	CHAR(50),
	inq_src		SMALLINT,	# magazine etc
	subtotal	MONEY(8, 2),	# total of invoice lines
	ship_no		SMALLINT,	# Shipper (UPS etc)
	card_no		CHAR(20),	# card no
	exp_date	CHAR(5),	# mm/yy
	ship_amt	MONEY(6, 2),	# Shipping charges
	discount	MONEY(8, 2),	# Customer discount
	taxes		MONEY(8, 2),	# Taxes
	itotal		MONEY(8, 2),	# Total
	ship_date	DATE,		# ship date
	term_no		SMALLINT,	# VISA MC COD etc
	user_id		CHAR(9),	# user who entered invoice
	bounce		CHAR(1),	# the check for this invoice bounced
	batch_ix	SMALLINT,	# credit card entry batch no
	ref_no		INTEGER,	# credit card entry reference no
	cap_no		INTEGER,	# credit card capture number
	tym_flag	SMALLINT,	# NULL not part of system
					# 1 new 2 sent 3 approved 4 diss
					# 5 new void 6 void 7 diss void
					# 8 void in transit
	back_flag	SMALLINT,
	frozen		CHAR(1)
)


CREATE TABLE Bshipreg (
     cust_no INTEGER,
     ser_no INTEGER,
     trace_no DECIMAL(11,0)
)

	DECLARE bcurs CURSOR FOR SELECT * FROM invoice
	FOREACH bcurs INTO binv.*
		DISPLAY "Invoice ",binv.invoice_no
		INSERT INTO Binvoice VALUES 
		(binv.invoice_no,
		binv.cust_no,
		binv.invoice_date,
		binv.icomments,
		binv.inq_src,
		binv.subtotal,
		binv.ship_no,
		binv.card_no,
		binv.exp_date,
		binv.ship_amt,
		binv.discount,
		binv.taxes,
		binv.itotal,
		binv.ship_date,
		binv.term_no,
		binv.user_id,
		binv.bounce,
		binv.batch_ix,
		binv.ref_no,
		binv.cap_no,
		binv.tym_flag,
		binv.back_flag,
		binv.frozen)

	END FOREACH

	DECLARE ccurs CURSOR FOR SELECT * FROM shipreg
	FOREACH ccurs INTO bshipreg.*
		INSERT INTO Binvoice VALUES
		(bshipreg.cust_no,
		bshipreg.ser_no,
		bshipreg.trace_no)
	END FOREACH

	DECLARE dcurs CURSOR FOR SELECT * FROM cmemo
	FOREACH dcurs INTO bcmemo.*
		INSERT INTO Binvoice VALUES 
			(bcmemo.memo_no,
			bcmemo.memo_date,
			bcmemo.invoice_no,
			bcmemo.auth_no,
			bcmemo.amount,
			bcmemo.com1,
			bcmemo.com2,
			bcmemo.batch_ix,
			bcmemo.ref_no,
			bcmemo.cap_no,
			bcmemo.tym_flag)

	END FOREACH


END MAIN

