# rebuild the index files after loading the data tables

DATABASE mwc

MAIN

DISPLAY "Dropping indices"

drop index p_invoice_no 
drop index i_auth 
drop index a_invoice_no
drop index i_line 
drop index ser_ship
drop index cust_ship
drop index weight_zone 
drop index c_address 
drop index i_ser_no 
drop index c_regcard 
drop index c_invoice_no 
drop index b_credit 
drop index d_invoice 
drop index i_invoice_no 
drop index c_invoice
drop index i_invoice_date 
drop index b_invoice 
drop index i_nser_no 
drop index c_newreg 
drop index c_customer 
drop index c_crunch 
drop index i_cprod 

DISPLAY "creating indices"
create index p_invoice_no on payment (invoice_no);
create unique index i_auth on auth (auth_no);
create index a_invoice_no on auth (invoice_no);
create index i_line on inv_line (invoice_no);
create unique index ser_ship on shipreg (ser_no);
create index cust_ship on shipreg (cust_no);
create unique index weight_zone on w_z_p (weight, zone, commer);
create index c_address on address (cust_no);
create unique index i_ser_no on regcard (ser_no);
create index c_regcard on regcard (cust_no);
create index c_invoice_no on cmemo (invoice_no);
create index b_credit on cmemo (batch_ix);
create index d_invoice on invoice (card_no);
create unique index i_invoice_no on invoice (invoice_no);
create index c_invoice on invoice (cust_no);
create index i_invoice_date on invoice (invoice_date);
create index b_invoice on invoice (batch_ix);
create unique index i_nser_no on newreg (ser_no);
create index c_newreg on newreg (cust_no);
create unique index c_customer on customer (cust_no);
create index c_crunch on customer (crunch);
create index i_cprod on cprodlst (cust_no);

END MAIN
