#
# Code the handle mag file
#
GLOBALS "globals0.4gl"

# inquiry source database
FUNCTION mag_menu()
	DISPLAY FORM mag_form

	LET chosen = FALSE

	MESSAGE "Type the first letter of the option ",
		"you want to select."

	MENU "MAGAZINE"
	COMMAND "Add" "Add a new magazine."
	        LET answer = "y"
	        WHILE answer = "y"
			CALL enter_mag()
       
			CALL yn("Do you want to enter another magazine <y/n>")
				RETURNING answer
		END WHILE
     
	COMMAND "Query" "Search for a magazine."
		CALL query_mag()

		IF chosen THEN
			NEXT OPTION "Modify"
		END IF
	
	COMMAND "Modify" "Modify a magazine."
		IF chosen THEN
			CALL change_mag()
		ELSE
			MESSAGE "No magazine has been chosen. ",
				"Use the Query option to select ",
				"a magazine."
			NEXT OPTION "Query"
      		END IF

	COMMAND "Delete" "Delete a magazine."
		IF chosen THEN
			CALL yn(
		  "Are you sure you want to delete this magazine (y/n)")
				RETURNING answer

			IF answer = "y" THEN
				CALL delete_mag()
				LET chosen = FALSE
			END IF
		ELSE
			MESSAGE "No magazine has been chosen. ",
				"Use the Query option to select ",
				"a magazine."
			NEXT OPTION "Query"
		END IF

	COMMAND "Exit" "Leave the Magazine menu."
		EXIT MENU
	END MENU

	CLEAR SCREEN
END FUNCTION

#
# magazines report
#
REPORT mag_list (r_mag)
	DEFINE r_mag RECORD LIKE magazines.*

	OUTPUT
		REPORT TO "mag.lst"
		LEFT MARGIN 0
		TOP MARGIN 0
		BOTTOM MARGIN 0
		PAGE LENGTH 80

	ORDER BY r_mag.mag_name

	FORMAT
	ON EVERY ROW
		PRINT	r_mag.inq_src USING "###", " ", r_mag.mag_name
END REPORT

FUNCTION enter_mag()
	MESSAGE ""
	CLEAR FORM

	INPUT BY NAME p_mag.mag_name, p_mag.cost, p_mag.cur_ad
	AFTER FIELD mag_name
		IF p_mag.mag_name IS NULL THEN
			NEXT FIELD mag_name
		END IF

	AFTER FIELD cost
		IF p_mag.cost IS NULL THEN
			NEXT FIELD cost
		END IF
	END INPUT

	LET p_mag.inq_src =  0

	INSERT INTO magazines VALUES (p_mag.*)

	LET p_mag.inq_src = SQLCA.SQLERRD[2]

	DISPLAY p_mag.inq_src TO inq_src

	MESSAGE "Row added."
END FUNCTION

FUNCTION query_mag()
	DEFINE	answer CHAR(1),
		exist SMALLINT

	MESSAGE ""
	CLEAR FORM

	CONSTRUCT BY NAME query1 ON magazines.*

	LET s1 = "SELECT * FROM magazines WHERE ", query1 CLIPPED

	PREPARE s_1 FROM s1

	DECLARE b_curs CURSOR FOR s_1

	LET exist = FALSE
	LET chosen = FALSE

	FOREACH b_curs INTO p_mag.*
		LET exist = TRUE

		DISPLAY BY NAME p_mag.* 

		CALL yn("Enter 'y' to select this magazine ")
			RETURNING answer

       	   	IF answer = "y" THEN
			LET chosen = TRUE
			EXIT FOREACH
		END IF
	END FOREACH

	CLOSE b_curs

	IF exist = FALSE THEN
		MESSAGE "No magazine rows found."
	ELSE
		IF chosen = FALSE THEN
			MESSAGE "There are no more magazine row."
		END IF
	END IF
END FUNCTION

FUNCTION change_mag()
	INPUT BY NAME p_mag.mag_name, p_mag.cost, p_mag.cur_ad
		WITHOUT DEFAULTS
	AFTER FIELD mag_name
		IF p_mag.mag_name IS NULL THEN
			NEXT FIELD mag_name
		END IF

	AFTER FIELD cost
		IF p_mag.cost IS NULL THEN
			NEXT FIELD cost
		END IF
	END INPUT

	UPDATE magazines 
		SET magazines.* = p_mag.*
		WHERE inq_src = p_mag.inq_src
END FUNCTION 

FUNCTION delete_mag()
	DELETE FROM magazines WHERE inq_src = 
		p_mag.inq_src
	CLEAR FORM
END FUNCTION 
