#
# invoice program.
# This would normally be several smaller programs but
# Informex executables run about 300K so it pays to
# put stuff together.
#
GLOBALS "globals0.4gl"

#
# invoice menu, asks add, find, delete, modify and report
#
FUNCTION invoice_menu()
	DISPLAY FORM big_form

	MESSAGE ""

	MENU "INVOICE"
	COMMAND "Add" "Add a new invoice"
		LET answer = "y"
		WHILE answer = "y"
			CALL enter_invoice()

			CALL yn("Enter another invoice <y/n>")
				RETURNING answer
		END WHILE

	COMMAND "Find" "Search for an invoice."
		CALL find_invoice(1)
		IF chosen = TRUE THEN
			CALL mod_invoice_menu()

			LET chosen = FALSE
		END IF

	COMMAND "Query" "Search for an invoice, show invoice once only."
		CALL find_invoice(0)
		IF chosen = TRUE THEN
			CALL mod_invoice_menu()

			LET chosen = FALSE
		END IF

	COMMAND	"Card" "Credit Card batch"
		CLEAR FORM
		CALL card_batch()

	COMMAND "Report" "Run a Report"
		RUN "reports.4ge"
 
	COMMAND "Xtra" "Still more reports"
		RUN "repx.4ge"

	COMMAND "Ytra" "Yet more reports"
		RUN "ccreps.4ge"

	COMMAND "Exit" "Leave the invoice program."
		MESSAGE ""
		EXIT MENU
	END MENU
END FUNCTION

#
# Menu for invoice mods.
#
FUNCTION mod_invoice_menu()
	MENU "Modify"
	COMMAND "Modify" "Modify an invoice"
		CALL modify_invoice()
		EXIT MENU

	COMMAND "Fix" "Enter a reference and batch number"
		IF user_id != "esther" AND
		   user_id != "madeline" THEN
			MESSAGE "No permission"
			EXIT MENU
		END IF

		INPUT BY NAME	p_invoice.batch_ix,
				p_invoice.ref_no,
				p_invoice.back_flag,
				p_invoice.tym_flag	WITHOUT DEFAULTS
		AFTER FIELD batch_ix
			IF p_invoice.batch_ix IS NOT NULL THEN
				SELECT *
				  INTO p_batch.*
				  FROM batch
				 WHERE batch_ix = p_invoice.batch_ix

				IF status = NOTFOUND THEN
					MESSAGE "Batch not found"
					NEXT FIELD batch_ix
				END IF
			END IF
		END INPUT

		UPDATE	invoice
		   SET	tym_flag = p_invoice.tym_flag,
			ref_no = p_invoice.ref_no,
			batch_ix = p_invoice.batch_ix,
			back_flag = p_invoice.back_flag
		 WHERE	invoice_no = p_invoice.invoice_no

		EXIT MENU

	COMMAND "Resend" "Try a failed transaction again"
		CALL is_tnet() RETURNING i_no
		IF i_no = TRUE THEN
			LET p_invoice.tym_flag = 1
		ELSE
			LET p_invoice.tym_flag = NULL
			MESSAGE "Wrong terms for timenet"
		END IF

		UPDATE invoice
		   SET tym_flag = p_invoice.tym_flag
		 WHERE invoice_no = p_invoice.invoice_no

		DISPLAY BY NAME p_invoice.tym_flag

		EXIT MENU

	COMMAND "Void" "Send a void message to tymnet"
		LET p_invoice.tym_flag = 5
		DISPLAY BY NAME p_invoice.tym_flag
		UPDATE invoice
		   SET tym_flag = p_invoice.tym_flag
		 WHERE invoice_no = p_invoice.invoice_no

#		CALL log_invoice("Invoice marked void")

	COMMAND "Delete" "Delete an invoice"
		IF user_id != "esther" AND
		   user_id != "madeline" THEN
			MESSAGE "No permission"
			EXIT MENU
		END IF

		CALL yn("are you sure you want to delete this <y/n>")
			RETURNING answer
		IF answer = "y" THEN
			CALL delete_invoice()
		END IF
		EXIT MENU

	COMMAND "Bounce" "Record a bounced check"
		UPDATE invoice SET bounce = "Y"
		 WHERE invoice_no = p_invoice.invoice_no
		EXIT MENU		

	COMMAND "Payment" "Register a payment"
		CALL register_pay()
		EXIT MENU

	COMMAND "Exit" "Don't modify invoice"
		EXIT MENU		
	END MENU
END FUNCTION

#
# Register a payment
#
FUNCTION register_pay()
	IF user_id != "chris"	AND
	   user_id != "esther"  AND
	   user_id != "cef"     THEN
		MESSAGE "You can't do that"

		RETURN
	END IF

	IF ptotal != 0 THEN
		CALL yn("Payments exist, continue <y/n> ") RETURNING answer

		LET p_invoice.itotal = p_invoice.itotal - ptotal
		IF answer != "y" THEN
			RETURN
		END IF
	END IF

	LET p_invoice.invoice_date = TODAY
	LET ptotal = p_invoice.itotal

	INPUT BY NAME	ptotal,
			p_invoice.invoice_date,
			p_invoice.icomments	WITHOUT DEFAULTS
	AFTER FIELD ptotal
		IF ptotal IS NULL THEN
			RETURN
		END IF

	AFTER FIELD invoice_date
		IF p_invoice.invoice_date IS NULL THEN
			NEXT FIELD invoice_date
		END IF
		MESSAGE ""

	AFTER FIELD icomments
		IF p_invoice.icomments IS NULL THEN
			NEXT FIELD icomments
		END IF
	END INPUT

	IF p_invoice.term_no = 13 THEN	# Hold for payment
		CALL yn("Take off hold <y/n> ") RETURNING answer
		IF answer != 'n' THEN
			CALL off_hold_for()
		END IF
	END IF
			
	INSERT INTO payment VALUES (
		0,	# for payment number
		p_invoice.invoice_date,
		p_invoice.invoice_no,
		ptotal,
		p_invoice.icomments
	)
	LET p_payment.pay_no = SQLCA.SQLERRD[2]

	UPDATE invoice SET icomments = p_invoice.icomments
	 WHERE invoice_no = p_invoice.invoice_no

	CALL memo_maybe()
	CALL pay_msg()
END FUNCTION

#
# Take off hold for payment
#
FUNCTION off_hold_for()
	DEFINE sw, is_card SMALLINT

	INPUT BY NAME	p_invoice.term_no,
			p_invoice.card_no,
			p_invoice.exp_date WITHOUT DEFAULTS
	AFTER FIELD term_no
		IF p_invoice.term_no == 13 THEN
			NEXT FIELD term_no
		END IF

		SELECT term_name INTO p_term.term_name FROM terms
		 WHERE terms.term_no = p_invoice.term_no

		IF status = NOTFOUND THEN
			NEXT FIELD term_no
		END IF

		DISPLAY BY NAME p_term.term_name

		CALL is_tnet() RETURNING is_card

		LET p_invoice.tym_flag = NULL
		IF is_card = TRUE THEN
			LET p_invoice.tym_flag = 1
		END IF
		DISPLAY BY NAME p_invoice.tym_flag

	AFTER FIELD exp_date
		IF is_card = TRUE AND
		   p_invoice.exp_date IS NULL THEN
			NEXT FIELD exp_date
		END IF

	BEFORE FIELD card_no
		IF is_card != TRUE THEN
			LET p_invoice.card_no = NULL
			LET p_invoice.exp_date = NULL
			DISPLAY BY NAME	p_invoice.card_no,
					p_invoice.exp_date
			EXIT INPUT
		END IF

	AFTER FIELD card_no
		LET cd_no = p_invoice.card_no
		LET i_no = length(cd_no)
		CASE
		WHEN p_invoice.term_no = 1
			IF cd_no[1,1] != "3" OR
			   i_no != 15 THEN
				MESSAGE
			 "AMEX cards are 15 digits starting with 3"
				NEXT FIELD term_no
			END IF
		WHEN p_invoice.term_no = 2
			IF cd_no[1,1] != "4" OR
			   (i_no != 13 AND i_no != 16) THEN
				MESSAGE
			 "VISA cards are 13 or 16 digits starting with 4"
				NEXT FIELD term_no
			END IF
		WHEN p_invoice.term_no = 3
			IF cd_no[1,1] != "5" OR
			   (i_no != 13 AND i_no != 16) THEN
				MESSAGE
			 "Master cards are 13 or 16 digits starting with 5"
				NEXT FIELD term_no
			END IF
		WHEN p_invoice.term_no = 4
			IF cd_no[1,1] != "6" OR i_no != 16 THEN
				MESSAGE
			 "Discover cards are 16 digits starting with 6"
				NEXT FIELD term_no
			END IF
		END CASE
	END INPUT

	LET p_invoice.back_flag = 2
	DISPLAY BY NAME p_invoice.back_flag

	UPDATE  invoice
	   SET  term_no	   = p_invoice.term_no,
		card_no    = p_invoice.card_no,
		exp_date   = p_invoice.exp_date,
		back_flag  = p_invoice.back_flag,
		tym_flag   = p_invoice.tym_flag
	 WHERE	invoice_no = p_invoice.invoice_no

END FUNCTION

#
# Credit card batch
#
FUNCTION card_batch()
	LET p_invoice.invoice_date = TODAY - 1
	LET p_invoice.cust_no = 0
	LET p_invoice.batch_ix = NULL

	WHILE 1=1
		INPUT BY NAME	p_invoice.batch_ix,
				p_invoice.cust_no,
				p_invoice.invoice_date WITHOUT DEFAULTS
		BEFORE FIELD batch_ix
			MESSAGE "Enter our batch number"
		BEFORE FIELD cust_no
			MESSAGE "Enter their batch number"
		BEFORE FIELD invoice_date
			MESSAGE "Enter batch date" 
		AFTER FIELD batch_ix
			IF p_invoice.batch_ix IS NOT NULL THEN
				SELECT *
				  INTO p_batch.*
				  FROM batch
				 WHERE batch_ix = p_invoice.batch_ix

				IF status = NOTFOUND THEN
					MESSAGE "Batch not found"
					NEXT FIELD batch_ix
				END IF
			 	LET p_invoice.cust_no = p_batch.batch_no
				LET p_invoice.invoice_date = p_batch.batch_date
				DISPLAY BY NAME	p_invoice.cust_no,
						p_invoice.invoice_date

				CALL yn("OK <y/n>") RETURNING answer
				IF answer = "y" THEN
					EXIT WHILE
				ELSE
					NEXT FIELD batch_ix
				END IF
			END IF

		AFTER FIELD cust_no
			MESSAGE "Enter external batch no"

			IF p_invoice.cust_no IS NULL OR
			   p_invoice.cust_no = 0 THEN
				NEXT FIELD cust_no
			END IF

			LET p_batch.batch_no = p_invoice.cust_no

		AFTER FIELD invoice_date
			IF p_invoice.invoice_date IS NULL THEN
				NEXT FIELD invoice_date
			END IF

			SELECT *
			  INTO p_batch.*
			  FROM batch
			 WHERE batch_date = p_invoice.invoice_date
			   AND batch_no = p_invoice.cust_no

			IF status = NOTFOUND THEN
				CALL yn("Start a new batch <y/n>")
					RETURNING answer
				IF answer = "n" THEN
					CONTINUE WHILE
				END IF

				INSERT INTO batch VALUES (
					0,
					p_invoice.cust_no,
					p_invoice.invoice_date
				)
				LET p_batch.batch_ix = SQLCA.SQLERRD[2]
			END IF
			LET p_invoice.batch_ix = p_batch.batch_ix
			DISPLAY BY NAME p_invoice.batch_ix
			EXIT WHILE
		END INPUT
	END WHILE

	WHILE  1 = 1
		MESSAGE "Enter invoice no 0 to exit"

		INPUT i_no FROM invoice.cust_no

		IF i_no = 0 THEN
			RETURN
		END IF

		SELECT * INTO p_invoice.* FROM invoice
		 WHERE invoice_no = i_no

		IF status = NOTFOUND THEN
			PROMPT i_no, " Not found " FOR answer
		ELSE
			DISPLAY BY NAME	p_invoice.card_no,
					p_invoice.exp_date,
					p_invoice.term_no,
					p_invoice.itotal

			UPDATE invoice
			   SET batch_ix = p_batch.batch_ix
			 WHERE invoice_no = i_no
		END IF
	END WHILE
END FUNCTION

#
# Get customer record
#
FUNCTION get_cust()
	DEFINE sw SMALLINT

	LET p_cust.cust_no = NULL

	LET p_cust.phone_no = NULL
	LET p_cust.contact = NULL	
	LET p_cust.inq_src = NULL

	INPUT BY NAME	p_cust.cust_no,
			p_cust.contact,
			p_cust.phone_no,
			p_cust.club WITHOUT DEFAULTS

	AFTER FIELD cust_no
		IF p_cust.cust_no IS NOT NULL THEN
			SELECT * INTO p_cust.* FROM customer
			 WHERE cust_no = p_cust.cust_no
			IF status = NOTFOUND THEN
				MESSAGE "customer number not found"
				NEXT FIELD cust_no
			END IF
			DISPLAY BY NAME	p_cust.contact,
					p_cust.phone_no,
					p_cust.inq_src,
					p_cust.club
			LET sw = 1
		ELSE
			LET sw = 0
		END IF

	AFTER FIELD contact
		IF p_cust.contact IS NULL THEN
			NEXT FIELD contact
		END IF

	BEFORE FIELD club
		MESSAGE "(1) New Member  (2) Already a club member. (Don't modify if '2'.)"

	AFTER FIELD club
		IF p_cust.club < 0 OR p_cust.club > 2 THEN
			MESSAGE "Improper Club code entered."
			NEXT FIELD club
		ELSE
			MESSAGE ""
		END IF

	END INPUT
	RETURN sw
END FUNCTION

#
# Put customer record or update it if it was there
#
FUNCTION put_cust(sw)
	DEFINE sw SMALLINT

	IF p_cust.inq_src IS NULL THEN
		LET p_cust.inq_src = p_invoice.inq_src
	END IF

	CALL cruncher(p_cust.contact) RETURNING p_cust.crunch
	IF sw THEN # customer was there
		UPDATE customer SET customer.* = p_cust.*
		 WHERE customer.cust_no = p_cust.cust_no
	ELSE
		INSERT INTO customer VALUES (
			0,
			p_cust.contact,
			p_cust.phone_no,
			NULL,
			user_id,
			TODAY,
			p_cust.crunch,
			p_cust.inq_src,
			p_cust.club
		)
		LET p_cust.cust_no = SQLCA.SQLERRD[2]

		DISPLAY BY NAME p_cust.cust_no
	END IF
END FUNCTION

#
# Show the business done for the new customer.
#
FUNCTION show_business()
	DEFINE i SMALLINT
	DEFINE p ARRAY[2000] OF SMALLINT

	FOR i = 1 to 2000
		LET p[i] = 0
	END FOR

	DECLARE y_curs CURSOR FOR
	 SELECT inv_line.* FROM invoice, inv_line
	  WHERE invoice.cust_no = p_cust.cust_no
	    AND inv_line.invoice_no = invoice.invoice_no

	FOREACH y_curs INTO p_line.*
		LET i = p_line.prod_no
		IF i > 2000 THEN
			MESSAGE "prod no > 2000"
			RETURN
		END IF
		LET p[i] = p[i] + p_line.quantity
	END FOREACH

	LET s1 = NULL
	FOR i = 1 to 2000
		IF p[i] != 0 THEN
			IF s1 IS NULL THEN
				LET s1 = p[i] USING "<<<",
					" of ", i USING "<<<"
			ELSE
				LET s1 = s1 CLIPPED, ", ", 
					p[i] USING "<<<",
					" of ", i USING "<<<"
			END IF
		END IF
	END FOR

	MESSAGE s1
END FUNCTION
		 
#
# Enter new invoices.
#
FUNCTION enter_invoice()
	DEFINE q_invoice RECORD LIKE invoice.*
	DEFINE q_line RECORD LIKE inv_line.*
	DEFINE q_product RECORD LIKE product.*

	DEFINE i, csw SMALLINT

	MESSAGE ""
	CLEAR FORM

	CALL get_cust() RETURNING csw

	CALL get_address(csw)

	IF csw == 1 THEN
		CALL show_business()
	ELSE
		MESSAGE ""
	END IF

	CALL inp_lump(0)

	LET answer = "y"
	CALL set_count(0)
	WHILE answer = "y"
		CALL inp_prod()
	END WHILE

	CALL inp_cost(0)

	CALL put_cust(csw)

	INSERT INTO invoice VALUES (
	 	0,			# invoice_no
		p_cust.cust_no,
		p_invoice.invoice_date,
		p_invoice.icomments,
		p_invoice.inq_src,
		p_invoice.subtotal,
		p_invoice.ship_no,
		p_invoice.card_no,
		p_invoice.exp_date,
		p_invoice.ship_amt,
		p_invoice.discount,
		p_invoice.taxes,
		p_invoice.itotal,
		p_invoice.ship_date,
		p_invoice.term_no,
		user_id,
		NULL,			# bounce
		p_invoice.batch_ix,
		NULL,			# ref_no
		NULL,			# cap_no
		p_invoice.tym_flag,
		p_invoice.back_flag,
		NULL			# frozen
	)

	LET p_invoice.invoice_no = SQLCA.SQLERRD[2]

	DISPLAY BY NAME	p_invoice.invoice_no

	CALL put_address(csw)

	CALL insert_lines()

	CALL log_invoice("New Invoice")

	MESSAGE "Invoice added"

# print a report of the newly transacted sale.  Added by fwb, 8/1/94
# report inv_report() derived the report of the same name that is in
# tnet.4gl, which is not part of mainline.4ge.

	DECLARE rep_curs CURSOR FOR
		SELECT *
		FROM invoice, inv_line, product
		WHERE	invoice.invoice_no = p_invoice.invoice_no
				AND
			invoice.invoice_no = inv_line.invoice_no
				AND
			inv_line.prod_no = product.prod_no

	START REPORT inv_report

# I use the local variables q_invoice et al. instead of the global variables
# because I have no idea what other functions expect those global variables
# to be initialized correctly.  People who write systems that depend upon
# global variables being initialized in a particular order are in the wrong
# business. fwb - 8/1/94
	FOREACH rep_curs INTO q_invoice.*, q_line.*, q_product.*
		OUTPUT TO REPORT inv_report(q_invoice.*, q_line.*, q_product.*)
	END FOREACH

	FINISH REPORT inv_report

	IF p_invoice.term_no != 5 THEN
		RETURN	# not prepaid
	END IF

	#
	# Set up payment record and maybe credit memo for overpayment.
	#
	LET ptotal = p_invoice.itotal

	INPUT BY NAME ptotal WITHOUT DEFAULTS
	MESSAGE ""

	IF ptotal IS NULL THEN
		RETURN
	END IF

	INSERT INTO payment VALUES (
		0,	# for payment number
		p_invoice.invoice_date,
		p_invoice.invoice_no,
		ptotal,
		p_invoice.icomments
	)
	LET p_payment.pay_no = SQLCA.SQLERRD[2]

	LET ctotal = 0	# There can be no previous credits
	CALL memo_maybe()

	CALL pay_msg()
END FUNCTION

#
# Process a record 
#
REPORT inv_report (i, l, p)
	DEFINE	i RECORD LIKE invoice.*,
		l RECORD LIKE inv_line.*,
		p RECORD LIKE product.*
	DEFINE 	pname CHAR(60)

	OUTPUT
		REPORT TO PIPE "lp -dsaleslog -s"
#		REPORT TO "mainline.out"
		TOP MARGIN 0
		BOTTOM MARGIN 0

	ORDER BY i.invoice_no, l.prod_no

	FORMAT
	BEFORE GROUP OF i.invoice_no
		SELECT *
		  INTO p_cust.*
		  FROM customer
		 WHERE cust_no = i.cust_no

		SELECT *
		  INTO s_address.*
		  FROM address
		 WHERE cust_no = i.cust_no
		   AND add_type <> "b"

		SELECT *
		  INTO p_ship.*
		  FROM shippers
		 WHERE ship_no = i.ship_no

		SELECT *
		  INTO p_term.*
		  FROM terms
		 WHERE terms.term_no = i.term_no

		PRINT	"INVOICE: ", i.invoice_no, " DATE: ", i.invoice_date
		PRINT	"CUSTOMER NUMBER: ", i.cust_no USING "<<<<<<<<<"
		PRINT	p_cust.contact CLIPPED
		PRINT	s_address.line1 CLIPPED
		IF s_address.line2 IS NOT NULL THEN
			PRINT	s_address.line2 CLIPPED
		END IF
		IF s_address.line3 IS NOT NULL THEN
			PRINT	s_address.line3 CLIPPED
		END IF

		CALL addline(s_address.*)
			RETURNING s1
		PRINT	s1 CLIPPED, " ", s_address.country CLIPPED

		PRINT	"PHONE NUMBER: ", p_cust.phone_no CLIPPED

		PRINT	"TERM: ", p_term.term_name CLIPPED;
		IF i.card_no IS NOT NULL THEN
			PRINT	"   CARD NO.: ", i.card_no
				USING "<<<<<<<<<<<<<<<<<",
				"  EXPIRATION DATE: ", i.exp_date CLIPPED,
				"  REFERENCE DATE: ", i.ref_no USING "<<<<<<<<<<<"
		END IF
		PRINT	"PRODUCTS:  Number, Quantity, Price"

	ON EVERY ROW
		PRINT	l.prod_no, " ",
			l.quantity USING "####", " ",
			p.price

	AFTER GROUP OF i.invoice_no
		PRINT	"SHIPPER: ", p_ship.ship_name CLIPPED

		IF i.icomments IS NOT NULL THEN
			PRINT	"COMMENTS: ", i.icomments CLIPPED
		END IF

		PRINT	"SUBTOTAL: ", i.subtotal

		IF i.taxes > 0 THEN
			PRINT	"TAXES: ", i.taxes
		END IF

		IF i.term_no = 11 AND
		   i.ship_amt > 10.00 THEN
			PRINT	"SHIPPING & HANDLING: ", i.ship_amt
		END IF

		IF i.discount != 0 THEN
			PRINT "DISCOUNT", i.discount
		END IF

		PRINT	"TOTAL ", i.itotal

		PRINT "======================================="
END REPORT

#
# Check if credit memo is required.
#
FUNCTION memo_maybe()
	LET p_memo.memo_no = 0
	LET p_memo.amount = ptotal - p_invoice.itotal

	IF p_memo.amount > 0.01 THEN
		LET s1 = "Issue credit for ", p_memo.amount, " <y/n> "
		CALL yn(s1 CLIPPED) RETURNING answer
		IF answer = "n" THEN
			RETURN
		END IF

		LET p_memo.memo_date = p_invoice.invoice_date
		LET p_memo.invoice_no = p_invoice.invoice_no
		LET p_memo.auth_no = NULL
		LET p_memo.com1 = "Refund of overpayment ",
				  p_payment.pay_no USING "######"
		LET p_memo.com2 = NULL

		INSERT INTO cmemo VALUES (p_memo.*)
		LET p_memo.memo_no = SQLCA.SQLERRD[2]

		LET ctotal = ctotal + p_memo.amount
		DISPLAY BY NAME ctotal
	END IF
END FUNCTION

#
# Put out messages about payment and credit memos
#
FUNCTION pay_msg()
	IF p_memo.memo_no != 0 THEN
		MESSAGE	"Payment ", p_payment.pay_no, " entered. ",
			"Credit Memo ", p_memo.memo_no, " issued."
	ELSE
		MESSAGE	"Payment ", p_payment.pay_no, " entered."
	END IF
END FUNCTION

#
# Enter terms card etc
#
FUNCTION inp_lump(sw)
	DEFINE sw, is_card SMALLINT
	DEFINE old_term SMALLINT

	IF sw = 0 THEN
		LET p_invoice.invoice_date = TODAY
		LET p_invoice.icomments = NULL
		LET p_invoice.inq_src = 1
		LET p_invoice.term_no = 1
		LET p_invoice.tym_flag = NULL
		LET p_invoice.card_no = NULL
		LET p_invoice.exp_date = NULL
		LET p_invoice.ship_date = NULL
		LET p_invoice.bounce = NULL
		LET p_invoice.batch_ix = NULL
		LET p_invoice.frozen = NULL
	END IF

	LET old_term = p_invoice.term_no

	INPUT BY NAME	p_invoice.term_no,
			p_invoice.card_no,
			p_invoice.exp_date,
			p_invoice.icomments,
			p_invoice.inq_src,
			p_invoice.bounce,
			p_invoice.batch_ix  WITHOUT DEFAULTS
	BEFORE FIELD bounce
		IF sw = 0 THEN
			EXIT INPUT
		END IF

	AFTER FIELD bounce
		IF p_invoice.bounce IS NOT NULL AND
		   p_invoice.bounce <> "Y" THEN
			NEXT FIELD bounce
		END IF

	BEFORE FIELD term_no
		IF p_invoice.frozen IS NOT NULL THEN
			MESSAGE "invoice frozen"
			IF user_id != "chris" AND
			   user_id != "owen" THEN
				NEXT FIELD icomments
			END IF
		END IF

	AFTER FIELD term_no
		SELECT term_name INTO p_term.term_name FROM terms
		 WHERE terms.term_no = p_invoice.term_no

		IF status = NOTFOUND THEN
			NEXT FIELD term_no
		END IF

		DISPLAY BY NAME p_term.term_name

		CALL is_tnet() RETURNING is_card
		IF p_invoice.term_no <> old_term AND
		   sw == 1 AND
		   is_card == TRUE THEN
			CALL yn(
		"Transaction already sent to tymnet. change anyway <y/n> ")
				RETURNING answer
			IF answer = "n" THEN				
				LET p_invoice.term_no = old_term
				NEXT FIELD term_no
			END IF
		END IF

		IF is_card != TRUE THEN
			LET p_invoice.tym_flag = NULL
		ELSE IF	sw = 0 THEN
			LET p_invoice.tym_flag = 1
		END IF
		END IF
		DISPLAY BY NAME p_invoice.tym_flag

	AFTER FIELD exp_date
		IF is_card = TRUE AND
		   p_invoice.exp_date IS NULL THEN
			NEXT FIELD exp_date
		END IF

	BEFORE FIELD card_no
		IF is_card != TRUE THEN
			LET p_invoice.card_no = NULL
			LET p_invoice.exp_date = NULL
			DISPLAY BY NAME	p_invoice.card_no,
					p_invoice.exp_date
			NEXT FIELD icomments
		END IF

	AFTER FIELD card_no
		LET cd_no = p_invoice.card_no
		LET i_no = length(cd_no)
		CASE
		WHEN p_invoice.term_no = 1
			IF cd_no[1,1] != "3" OR
			   i_no != 15 THEN
				MESSAGE
			 "AMEX cards are 15 digits starting with 3"
				NEXT FIELD term_no
			END IF
		WHEN p_invoice.term_no = 2
			IF cd_no[1,1] != "4" OR
			   (i_no != 13 AND i_no != 16) THEN
				MESSAGE
			 "VISA cards are 13 or 16 digits starting with 4"
				NEXT FIELD term_no
			END IF
		WHEN p_invoice.term_no = 3
			IF cd_no[1,1] != "5" OR
			   (i_no != 13 AND i_no != 16) THEN
				MESSAGE
			 "Master cards are 13 or 16 digits starting with 5"
				NEXT FIELD term_no
			END IF
		WHEN p_invoice.term_no = 4
			IF cd_no[1,1] != "6" OR i_no != 16 THEN
				MESSAGE
			 "Discover cards are 16 digits starting with 6"
				NEXT FIELD term_no
			END IF
		END CASE

	AFTER FIELD inq_src
		SELECT mag_name INTO p_mag.mag_name FROM magazines
		 WHERE magazines.inq_src = p_invoice.inq_src 

		IF status = NOTFOUND THEN
			NEXT FIELD  inq_src
		END IF

		DISPLAY BY NAME p_mag.mag_name

	AFTER INPUT
		IF p_invoice.frozen IS NULL THEN
			CALL is_tnet() RETURNING is_card
			IF is_card = TRUE THEN
				IF p_invoice.card_no IS NULL THEN
					NEXT FIELD card_no
				END IF

				IF p_invoice.exp_date IS NULL THEN
					NEXT FIELD exp_date
				END IF
			ELSE
				LET p_invoice.tym_flag = NULL
			END IF
		END IF
	END INPUT
END FUNCTION

#
# Enter terms card etc
#
FUNCTION inp_cost(sw)
	DEFINE sw SMALLINT
	DEFINE i  SMALLINT
	DEFINE maxd LIKE invoice.discount
#	DEFINE club_discount MONEY(8,2)

	IF sw = 0 THEN
		LET p_invoice.discount = 0
		IF p_invoice.term_no = 6 THEN
			LET p_invoice.discount = p_invoice.subtotal
		END IF
		LET p_invoice.ship_amt = 0
		LET p_invoice.taxes = 0
		LET p_invoice.ship_no = 1
	END IF

	IF p_invoice.term_no = 13 THEN	# Hold for payment
		LET p_invoice.back_flag = 1
		DISPLAY BY NAME p_invoice.back_flag
	END IF

	INPUT BY NAME	p_invoice.ship_no,
			p_invoice.ship_amt,
			p_invoice.discount  WITHOUT DEFAULTS

	AFTER FIELD ship_amt
		IF p_invoice.ship_amt IS NULL THEN
			NEXT FIELD ship_amt
		END IF

# Handle our 5% discount for Coherent club members. Calculate the 5%
# amount and display this amount on the message line. Check to be
# sure that at least this amount was entered in the discount field
# before continuing.

#		IF p_cust.club > 1 THEN
#			LET club_discount = p_invoice.subtotal * .05
#			LET p_invoice.discount = club_discount
#			MESSAGE "Club Discount applied in discount field."
#		END IF

	AFTER FIELD discount
#		IF p_invoice.discount IS NULL THEN
#			LET p_invoice.discount = club_discount
#		END IF
		LET maxd = p_invoice.subtotal + p_invoice.ship_amt

# Now check to see that the minimun 5% discount was entered. Go no further
# until it is.

#		IF (p_cust.club > 1) AND (p_invoice.discount < club_discount) THEN
#			MESSAGE "Discount entered is below the Coherent Club 5%. Try again."
#			NEXT FIELD discount
#		ELSE
#			MESSAGE ""
#		END IF

		IF p_invoice.discount > maxd THEN
			LET p_invoice.discount = maxd
			MESSAGE "Maximum discount exceeded"
			NEXT FIELD discount
		END IF

	AFTER FIELD ship_no
		LET i = p_invoice.ship_no
 
		SELECT ship_name, cust_cost
		  INTO p_ship.ship_name, p_ship.cust_cost
		  FROM shippers
		 WHERE ship_no = i

		IF status = NOTFOUND THEN
			NEXT FIELD ship_no
		END IF

		IF sw = 0 THEN
			IF mwc_freight[i] IS NULL THEN
				LET p_invoice.ship_amt = p_ship.cust_cost
			ELSE
				LET p_invoice.ship_amt = mwc_freight[i]
			END IF

			IF p_invoice.term_no = 11 THEN # cod
				LET p_invoice.ship_amt =
				    p_invoice.ship_amt + 10.00

				MESSAGE "$10.00 COD charge added."
			END IF
		END IF

		DISPLAY BY NAME p_ship.ship_name, p_invoice.ship_amt
	END INPUT

	LET p_invoice.itotal = p_invoice.subtotal - p_invoice.discount
	LET taxpct = 0.0

	IF s_address.add_type = "s" THEN
		IF s_address.state = "IL" THEN
			LET taxpct = 7.75
		END IF
	ELSE
		IF b_address.state = "IL" THEN
			LET taxpct = 7.75
		END IF
	END IF

	IF p_invoice.itotal > 0 AND taxpct > 0 THEN
		LET p_invoice.taxes  = p_invoice.itotal * taxpct
		LET p_invoice.taxes  = p_invoice.taxes / 100.0

		DISPLAY BY NAME p_invoice.itotal, p_invoice.taxes

		INPUT BY NAME	taxpct WITHOUT DEFAULTS
		AFTER FIELD taxpct
			IF taxpct IS NULL THEN
				NEXT FIELD taxpct
			END IF
		END INPUT

		LET p_invoice.taxes  = p_invoice.itotal * taxpct
		LET p_invoice.taxes  = p_invoice.taxes / 100.0
		LET p_invoice.itotal = p_invoice.itotal + p_invoice.taxes
	END IF 

	LET p_invoice.itotal = p_invoice.itotal + p_invoice.ship_amt

	DISPLAY BY NAME	p_invoice.itotal, p_invoice.taxes
END FUNCTION

#
# get product information
#
FUNCTION inp_prod()
	DEFINE sc_curr, pa_curr, i, j SMALLINT
	DEFINE sh_cv, sh_ct ARRAY[30] OF SMALLINT
	DEFINE sh_con, sh_i ARRAY[30] OF MONEY(6,2)
	DEFINE sh_wgt ARRAY[30] OF DECIMAL(6, 2)
	DEFINE wgt ARRAY[10] OF DECIMAL(6,2)
	DEFINE wx DECIMAL(6,0)

	INPUT ARRAY p_items WITHOUT DEFAULTS FROM s_items.*
	AFTER FIELD prod_no
		LET pa_curr = arr_curr()
		LET sc_curr = scr_line()

# Tell the user which invoice line he/she is on. Limit of 10 lines per invoice.
		MESSAGE "Invoice line #",pa_curr," of 10."

		IF p_items[pa_curr].prod_no  IS NULL THEN
			NEXT FIELD prod_no
		END IF

		SELECT *
		  INTO p_product.*
		  FROM product
		 WHERE product.prod_no = p_items[pa_curr].prod_no

		IF status = NOTFOUND THEN
			NEXT FIELD prod_no
		END IF

		LET p_items[pa_curr].price = p_product.price
		LET p_items[pa_curr].prod_name = p_product.prod_name
		LET p_items[pa_curr].comment1 = p_product.comment1
		LET p_items[pa_curr].b_flag = p_product.b_flag
		LET wgt[pa_curr] = p_product.weight

		DISPLAY p_items[pa_curr].price,
			p_items[pa_curr].prod_name,
			p_items[pa_curr].comment1,
		        p_items[pa_curr].b_flag
		     TO s_items[sc_curr].price,
			s_items[sc_curr].prod_name,
			s_items[sc_curr].comment1,
			s_items[sc_curr].b_flag

		IF p_items[pa_curr].quantity IS NOT NULL THEN
		   	CALL extend_line()
		END IF

	AFTER FIELD quantity
		LET pa_curr = arr_curr()

		IF p_items[pa_curr].quantity  IS NULL THEN
			NEXT FIELD quantity
		END IF

		IF p_items[pa_curr].prod_no  IS NOT NULL THEN
		   	CALL extend_line()
		END IF
	END INPUT

	IF arr_count() = 0 THEN
		MESSAGE "There must be some line items"
		RETURN
	END IF

	MESSAGE ""
	LET answer = "n"
	
	LET p_invoice.subtotal = 0
	LET p_invoice.back_flag = NULL
	LET s1 = NULL
	FOR i = 1 TO 30		# 30 is > than MAX(ship_no)
		LET sh_ct[i] = 0
		LET sh_con[i] = -1000.00
		LET sh_i[i] = 0
		LET sh_wgt[i] = 0.0
		LET mwc_freight[i] = NULL
	END FOR

	# Get state record
	IF b_address.add_type = "x" THEN
		CALL find_state(b_address.state, b_address.country)
	ELSE
		CALL find_state(s_address.state, s_address.country)
	END IF
	
	FOR i = 1 to arr_count()
		IF p_items[i].b_flag = 1 THEN
			LET p_invoice.back_flag = 1
		END IF
		LET p_invoice.subtotal = p_invoice.subtotal +
					 p_items[i].extension

		DECLARE f_curs CURSOR FOR
		 SELECT *
		   FROM freight
		  WHERE prod_no = p_items[i].prod_no
		    AND dest_no = p_states.dest_no

		FOREACH f_curs INTO p_freight.*
			LET j = p_freight.ship_no
			LET sh_ct[j] = sh_ct[j] + 1	# All must be there
			IF p_freight.lb_cost != 0.0 THEN
				LET sh_wgt[j] = sh_wgt[j] +
					(wgt[i] * p_items[i].quantity)
			END IF
			IF sh_con[j] < p_freight.const_cost THEN
				LET sh_con[j] = p_freight.const_cost
				LET sh_i[j] = p_freight.lb_cost
				LET sh_cv[j] = i
			END IF
		END FOREACH
		
		CLOSE f_curs
	END FOR

	DISPLAY BY NAME p_invoice.subtotal

	FOR i = 1 TO 30
		IF sh_ct[i] = arr_count() THEN
			LET j = sh_cv[i]
			LET wx = sh_wgt[i] - wgt[j]
			IF wx < 0.0 THEN
				LET wx = 0
			END IF

			LET mwc_freight[i] = sh_con[i] + (wx  * sh_i[i])

			IF s1 IS NULL THEN
				LET s1 = i USING "<<", " ", 
					 mwc_freight[i] USING "<<<<#.##"
			ELSE
				LET s1 = s1 CLIPPED, ", ",
					 i USING "<<", " ", 
					 mwc_freight[i] USING "<<<<#.##"
			END IF
		END IF
	END FOR
	
	MESSAGE s1 CLIPPED
END FUNCTION

#
# Modify a found invoice.
#
FUNCTION modify_invoice()
	DEFINE	i, xsw SMALLINT

	MESSAGE ""

	INPUT BY NAME	p_invoice.invoice_date,
			p_invoice.ship_date,
			p_cust.contact,
			p_cust.phone_no,
			p_cust.club WITHOUT DEFAULTS

	CALL get_address(1)
	MESSAGE ""

	CALL inp_lump(1)

	LET xsw = FALSE
	IF p_invoice.frozen IS NULL OR
	   user_id == "chris" OR
	   user_id == "owen"  OR
	   user_id == "esther" THEN
		CALL yn("Do you want to change any items <y/n> ")
		 RETURNING answer

		IF answer == "y" THEN
			LET xsw = TRUE
			CALL load_items()
		END IF


		WHILE answer == "y"
			CALL inp_prod()
		END WHILE

		CALL inp_cost(1)
	ELSE
		MESSAGE "Invoice frozen"
	END IF

	CALL put_cust(1)

	UPDATE invoice SET invoice.* = p_invoice.*
		WHERE invoice.invoice_no = p_invoice.invoice_no

	CALL put_address(1)

	IF xsw = TRUE THEN
		DELETE FROM inv_line WHERE invoice_no = p_invoice.invoice_no

		CALL insert_lines()
	END IF

	MESSAGE "invoice modified"

#	CALL log_invoice("Modified invoice")
END FUNCTION

#
# Insert inv_lines for an invoice.
#
FUNCTION insert_lines()
	FOR counter = 1 to arr_count()
		INSERT INTO inv_line VALUES (
			p_invoice.invoice_no,
			p_items[counter].prod_no,
			p_items[counter].quantity,
			0
		)
	END FOR
END FUNCTION

FUNCTION load_items()
	DEFINE i SMALLINT

	LET i = 1

	DECLARE li_curs CURSOR FOR
	 SELECT prod_no, quantity FROM inv_line
	 WHERE inv_line.invoice_no = p_invoice.invoice_no

	FOREACH li_curs INTO p_items[i].prod_no, p_items[i].quantity
		SELECT price, prod_name, comment1, b_flag
		  INTO p_items[i].price,
		       p_items[i].prod_name,
		       p_items[i].comment1,
		       p_items[i].b_flag
		  FROM product
		 WHERE product.prod_no = p_items[i].prod_no
		LET p_items[i].extension = p_items[i].quantity *
					   p_items[i].price
		LET i = i + 1
	END FOREACH
	
	CLOSE li_curs

	CALL set_count(i - 1)
END FUNCTION

#
# Extend an inv_line.
#
FUNCTION extend_line()
	DEFINE pa_curr, sc_curr SMALLINT

	LET pa_curr = arr_curr()
	LET sc_curr = scr_line()

	LET p_items[pa_curr].extension =
	    p_items[pa_curr].price * p_items[pa_curr].quantity

	DISPLAY p_items[pa_curr].extension TO s_items[sc_curr].extension
END FUNCTION

#
# find invoice
#
FUNCTION find_invoice(sw)
	DEFINE	sw    SMALLINT
	DEFINE  exist SMALLINT
	DEFINE	answer CHAR(1)
	DEFINE  oldinv INTEGER

	CLEAR FORM
	MESSAGE ""

	IF sw = 1 THEN
		INPUT BY NAME p_shipreg.ser_no
	ELSE
		LET p_shipreg.ser_no = NULL
	END IF

	IF p_shipreg.ser_no IS NOT NULL THEN
		LET s1 = "SELECT * FROM customer, invoice, address, shipreg ",
			 "WHERE shipreg.ser_no=\"",
			 p_shipreg.ser_no USING "<<<<<<<<<<<",
			 "\" AND customer.cust_no = shipreg.cust_no",
			 " AND invoice.cust_no = shipreg.cust_no",
			 " AND address.cust_no = shipreg.cust_no"
	ELSE
		CONSTRUCT BY NAME query1 ON
			invoice.invoice_no, contact, invoice.cust_no,
			phone_no, icomments, zipcode,
			line1, line2, line3, city, state, country,
			invoice.card_no, exp_date, ref_no, tym_flag,
			invoice_date, ship_date, invoice.back_flag,
			itotal, invoice.inq_src, term_no, ship_no, discount, 
			bounce, batch_ix

		CALL crunchcon(query1) RETURNING query1

		LET s1 = "SELECT * FROM customer, invoice, address,",
			 " OUTER shipreg",
			 " WHERE invoice.cust_no = address.cust_no",
			 "   AND customer.cust_no = invoice.cust_no",
			 "   AND shipreg.cust_no = customer.cust_no",
			 "   AND ", query1 CLIPPED
	END IF

	PREPARE s_1 FROM s1


	DECLARE r_curs CURSOR FOR s_1 

	LET exist  = FALSE
	LET chosen = FALSE
	LET oldinv = 0

	FOREACH r_curs INTO p_cust.*, p_invoice.*, s_address.*, p_shipreg.*
		LET exist = TRUE

		IF sw = 0 AND oldinv = p_invoice.invoice_no THEN
			CONTINUE FOREACH
		END IF
		LET oldinv = p_invoice.invoice_no

		SELECT * INTO p_ship.* FROM shippers
		 WHERE	ship_no = p_invoice.ship_no

		SELECT * INTO p_term.* FROM terms
		 WHERE terms.term_no = p_invoice.term_no

		SELECT * INTO p_mag.* FROM magazines
		 WHERE magazines.inq_src = p_invoice.inq_src

		SELECT SUM(amount) INTO ctotal FROM cmemo
		 WHERE cmemo.invoice_no = p_invoice.invoice_no
		IF ctotal IS NULL THEN
			LET ctotal = 0
		END IF

		SELECT SUM(amount) INTO ptotal FROM payment
		 WHERE payment.invoice_no = p_invoice.invoice_no
		IF ptotal IS NULL THEN
			LET ptotal = 0
		END IF

		DISPLAY BY NAME p_invoice.invoice_no,
				p_cust.cust_no,
				p_cust.contact,
				p_cust.phone_no,
				p_cust.club,
				p_invoice.invoice_date,
				p_invoice.ship_date,
				p_invoice.icomments,
				p_invoice.inq_src,
				p_invoice.subtotal,
				p_invoice.term_no,
				p_invoice.discount,
				p_invoice.ship_amt,
				p_invoice.taxes,
				p_invoice.itotal,
				p_invoice.ship_no,
				p_invoice.card_no,
				p_invoice.exp_date,
				p_invoice.ref_no,
				p_invoice.tym_flag,
				p_invoice.user_id,
				p_invoice.bounce,
				p_invoice.batch_ix,
				p_invoice.back_flag,
				ctotal,
				ptotal,
				p_ship.ship_name,
				p_term.term_name,
				p_mag.mag_name,
				s_address.add_type,
				s_address.line1,
				s_address.line2,
				s_address.line3,
				s_address.city,
				s_address.state,
				s_address.country,
				s_address.zipcode,
				p_shipreg.ser_no,
				p_shipreg.trace_no

		DISPLAY	p_cust.inq_src TO customer.inq_src

		DECLARE z_curs CURSOR FOR
		 SELECT * FROM inv_line
		  WHERE invoice_no = p_invoice.invoice_no

		LET s1 = NULL
		FOREACH z_curs INTO p_line.*
			IF s1 IS NULL THEN
				LET s1 = p_line.quantity USING "<<<",
					 " of ",
					 p_line.prod_no USING "<<<"
			ELSE
				LET s1 = s1 CLIPPED, ", ", 
					 p_line.quantity USING "<<<",
					 " of ",
					 p_line.prod_no USING "<<<"
			END IF
		END FOREACH

		MESSAGE s1

		CLOSE z_curs

		CALL yn("Enter 'y' to select this invoice")
			RETURNING answer

		IF answer = "y" THEN
			LET chosen = TRUE
			EXIT FOREACH
		END IF
	END FOREACH

	CLOSE r_curs

	CASE
	WHEN exist = FALSE
		MESSAGE "No invoice found"
	WHEN chosen = FALSE
		MESSAGE "No more invoices."
	END CASE
END FUNCTION

#
# delete an invoice
#
FUNCTION delete_invoice()
	DEFINE ct SMALLINT

#	CALL log_invoice("Delete invoice")

	DELETE FROM invoice  WHERE invoice_no = p_invoice.invoice_no
	DELETE FROM inv_line WHERE invoice_no = p_invoice.invoice_no

	SELECT COUNT(*) INTO ct FROM invoice
	 WHERE cust_no = p_invoice.cust_no
	IF ct > 0 THEN
		RETURN
	END IF

	CALL yn("Delete customer record <y/n>") RETURNING answer
	IF answer = "y" THEN
		DELETE FROM address  WHERE cust_no = p_invoice.cust_no
		DELETE FROM customer WHERE cust_no = p_invoice.cust_no
	END IF

	MESSAGE "Invoice deleted"
END FUNCTION

FUNCTION log_invoice(mess)
	DEFINE mess CHAR(20)

	RETURN
	LET s1 = mess
	START REPORT log_inv

	DECLARE lo_curs CURSOR FOR
	 SELECT *
	   FROM inv_line
	  WHERE invoice_no = p_invoice.invoice_no

	FOREACH lo_curs INTO p_line.*
		OUTPUT TO REPORT log_inv(p_line.*)
	END FOREACH

	CLOSE lo_curs

	FINISH REPORT log_inv
END FUNCTION

REPORT log_inv(l)
	DEFINE l RECORD LIKE inv_line.*

	OUTPUT
		REPORT TO PIPE "tranlog"
		LEFT MARGIN 0
		TOP MARGIN 0
		BOTTOM MARGIN 0

	ORDER BY l.invoice_no

	FORMAT
	BEFORE GROUP OF l.invoice_no
		PRINT	s1 CLIPPED, " ", TODAY, " ", TIME,
			"  ", user_id, 10 SPACES,
			p_invoice.invoice_no USING "######", " ",
			p_invoice.invoice_date

		PRINT	p_cust.contact CLIPPED, " ",
			p_cust.cust_no USING "######"
			
		IF p_cust.phone_no IS NOT NULL THEN
			PRINT	"phone ", p_cust.phone_no
		END IF

		SKIP 1 LINE
		PRINT	b_address.add_type, " ",
			b_address.line1

		IF b_address.line2 IS NOT NULL THEN
			PRINT	"  ", b_address.line2
		END IF

		IF b_address.line3 IS NOT NULL THEN
			PRINT	"  ", b_address.line3
		END IF

		CALL addline(b_address.*) RETURNING s1
		PRINT s1 CLIPPED

		IF b_address.country IS NOT NULL THEN
			PRINT  "  ", b_address.country
		END IF

		IF b_address.add_type <> "x" THEN
			SKIP 1 LINE
			PRINT	s_address.add_type, " ",
				s_address.	line1

			IF s_address.line2 IS NOT NULL THEN
				PRINT	"  ", s_address.line2
			END IF

			IF s_address.line3 IS NOT NULL THEN
				PRINT	"  ", s_address.line3
			END IF

			CALL addline(s_address.*) RETURNING s1
			PRINT s1 CLIPPED

			IF s_address.country IS NOT NULL THEN
				PRINT  "  ", s_address.country
			END IF
		END IF

		SKIP 1 LINE
		IF p_invoice.card_no IS NULL THEN
			PRINT	"terms ", p_invoice.term_no USING "<<",
				" inq src ", p_invoice.inq_src USING "<<",
				" ", p_invoice.icomments	
		ELSE
			PRINT	"terms ", p_invoice.term_no USING "<<",
				" ", p_invoice.card_no,
				" ", p_invoice.exp_date,
				p_invoice.tym_flag USING "&"

			PRINT	"inq src ", p_invoice.inq_src USING "<<",
				" ", p_invoice.icomments	
		END IF

		PRINT	"shipper ", p_invoice.ship_no,
			p_invoice.ship_amt

		PRINT	" subtotal", p_invoice.subtotal,
			" discount", p_invoice.discount,
			" taxes",    p_invoice.taxes,
			" total",    p_invoice.itotal

		SKIP 1 LINE
	ON EVERY ROW
		PRINT	"product ",  l.prod_no USING "<<<",
			" quantity ", l.quantity USING "<<<<"

END REPORT	
