#
# Code for payments
#
GLOBALS "globals0.4gl"

FUNCTION pay_menu()
	OPEN FORM pay_form FROM "pay"
	DISPLAY FORM pay_form

	LET chosen = FALSE

	MENU "Payment"
	COMMAND "Add" "Enter a payment."
	        LET answer = "y"
	        WHILE answer = "y"
			CALL enter_payment()
       
			CALL yn("Enter another payment <y/n> ?  ")
				RETURNING answer
		END WHILE
     
	COMMAND "Query" "Search for a payment."
		CALL query_payment()

		IF chosen THEN
			NEXT OPTION "Modify"
		END IF
	
	COMMAND "Modify" "Modify a payment."
		IF chosen THEN
			CALL change_payment()
		ELSE
			MESSAGE "No has been chosen. ",
				"Use the Query option to select ",
				"a payment."
			NEXT OPTION "Query"
      		END IF

	COMMAND "Delete" "Delete a payment."
		IF chosen THEN
			CALL yn(
			"Are you sure you want to delete this payment (y/n)")
				RETURNING answer

			IF answer = "y" THEN
				CALL delete_payment()
				LET chosen = FALSE
			END IF
		ELSE
			MESSAGE "No payment has been chosen. ",
				"Use the Query option to select one "
			NEXT OPTION "Query"
		END IF

	COMMAND "Report" "Report on all payments"
		CALL payment_report()
	COMMAND "Exit" "Leave the payment menu."
		EXIT MENU
	END MENU

	CLOSE FORM pay_form
	CLEAR SCREEN
END FUNCTION

FUNCTION payment_report()
	CLEAR FORM

	CONSTRUCT query1 ON
		payment.pay_no, pay_date, invoice_no,
		com1
	FROM
		payment.pay_no, pay_date, invoice_no,
		com1

	LET s1 = "SELECT * FROM payment WHERE ", query1 CLIPPED 

	PREPARE s_4 FROM s1

	DECLARE rp_curs CURSOR FOR s_4

	MESSAGE ""

	LET finTot[1] = 0
	LET qtot[1] = 0

	START REPORT payment_list

	FOREACH rp_curs INTO p_payment.*
		OUTPUT TO REPORT payment_list (p_payment.*)
	END FOREACH

	FINISH REPORT payment_list

	CLOSE rp_curs
END FUNCTION

#
# Payment report
#
REPORT payment_list (p_payment)
	DEFINE  p_payment RECORD LIKE payment.*

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80
		RIGHT MARGIN 70

	ORDER BY p_payment.invoice_no

	FORMAT
	PAGE HEADER
		PRINT	PAGENO USING "page <<<<", 16 SPACES,
			"PAYMENT REPORT"
		PRINT	query1 CLIPPED
		PRINT	"payment  date    invoice   amount   check no"
		SKIP 2 LINES

	ON EVERY ROW
		CALL check_no(p_payment.com1)
			RETURNING p_payment.com1

		PRINT	p_payment.pay_no USING "#####", " ",
			p_payment.pay_date, " ",
			p_payment.invoice_no USING "#####",
			p_payment.amount, "   ",
			p_payment.com1 CLIPPED

		LET finTot[1] = finTot[1] + p_payment.amount
		LET qtot[1] = qtot[1] + 1

	ON LAST ROW
		SKIP 1 LINE
		PRINT	qtot[1] USING "#####",
			15 SPACES, finTot[1]
END REPORT

FUNCTION p_tell_em()
	MESSAGE ctotal, " Payments already on this invoice."
	CALL yn("continue <y/n>") RETURNING answer
	MESSAGE ""
END FUNCTION

	
FUNCTION enter_payment()
	MESSAGE ""
	CLEAR FORM

	LET p_payment.pay_date = TODAY
	LET p_payment.invoice_no = NULL
	LET p_payment.amount = 0
	LET p_payment.com1 = NULL
	INPUT BY NAME p_payment.pay_date THRU p_payment.com1
	 WITHOUT DEFAULTS
	AFTER FIELD com1
		IF p_payment.com1 IS NULL THEN
			NEXT FIELD com1
		END IF

	AFTER FIELD invoice_no
		CALL get_invoice(p_payment.invoice_no)
		IF p_invoice.cust_no IS NULL THEN
			NEXT FIELD invoice_no
		END IF
		DISPLAY BY NAME p_cust.phone_no

		SELECT SUM(amount) INTO ctotal FROM payment
		 WHERE payment.invoice_no = p_payment.invoice_no
		IF ctotal IS NULL THEN
			LET ctotal = 0
		END IF
		IF ctotal <> 0.0 THEN
			CALL p_tell_em()
			IF answer <> "y" THEN
				RETURN
			END IF
		END IF
		LET p_payment.amount = p_invoice.itotal - ctotal
		DISPLAY BY NAME p_payment.amount
	END INPUT

	LET p_payment.pay_no =  0

	INSERT INTO payment VALUES (p_payment.*)

	LET p_payment.pay_no = SQLCA.SQLERRD[2]

	DISPLAY BY NAME p_payment.pay_no

	MESSAGE "Row added."
END FUNCTION

FUNCTION query_payment()
	DEFINE  exist SMALLINT

	CLEAR FORM

	CONSTRUCT query1 ON
		payment.pay_no, pay_date, payment.invoice_no, amount,
		com1, customer.contact
	FROM
		payment.pay_no, pay_date, payment.invoice_no, amount,
		com1, customer.contact

	LET s1 = "SELECT * FROM payment, invoice, customer ",
		 "WHERE invoice.invoice_no = payment.invoice_no AND ",
		 "customer.cust_no = invoice.cust_no AND ",
		 query1 CLIPPED

	PREPARE s_5 FROM s1

	DECLARE qm_curs CURSOR FOR s_5

	LET exist  = FALSE
	LET chosen = FALSE
	
	FOREACH qm_curs INTO p_payment.*, p_invoice.*, p_cust.*
		LET exist = TRUE

		DISPLAY BY NAME p_payment.pay_no,
				p_payment.pay_date,
				p_payment.invoice_no,
				p_payment.amount,
				p_payment.com1,
				p_cust.contact,
				p_cust.phone_no
	
		CALL yn("Enter 'y' to select this payment")
			RETURNING answer

		IF answer = "y" THEN
			LET chosen = TRUE
			EXIT FOREACH
		END IF
	END FOREACH

	CLOSE qm_curs

	IF exist = FALSE THEN
		MESSAGE "No payment found"
	ELSE
		IF chosen = FALSE THEN
			MESSAGE "No more payment."
		END IF
	END IF
END FUNCTION

FUNCTION change_payment()
	MESSAGE ""
	INPUT BY NAME p_payment.pay_date THRU p_payment.com1
		WITHOUT DEFAULTS
	AFTER FIELD com1
		IF p_payment.com1 IS NULL THEN
			NEXT FIELD com1
		END IF

	AFTER FIELD invoice_no
		CALL get_invoice(p_payment.invoice_no)
		IF p_invoice.cust_no IS NULL THEN
			NEXT FIELD invoice_no
		END IF
		DISPLAY BY NAME p_cust.phone_no
	END INPUT

	UPDATE payment SET payment.* = p_payment.*
	 WHERE payment.pay_no = p_payment.pay_no

	DISPLAY BY NAME p_payment.pay_no

	MESSAGE "Row changed."
END FUNCTION 

FUNCTION delete_payment()
	DELETE FROM payment WHERE payment.pay_no = p_payment.pay_no
	CLEAR FORM
END FUNCTION 
