GLOBALS "globals0.4gl"
MAIN
	DECLARE x_curs CURSOR FOR

	SELECT * FROM invoice, inv_line, product, customer
	 WHERE invoice.back_flag = 1
	   AND inv_line.invoice_no = invoice.invoice_no
	   AND inv_line.prod_no = product.prod_no
	   AND product.b_flag IS NULL
	   AND customer.cust_no = invoice.cust_no

	CALL clear_totals()

	START REPORT d_report
		
	FOREACH x_curs
	   INTO p_invoice.*, p_line.*, p_product.*, p_cust.*
	   	LET p_invoice.subtotal = p_product.price * p_line.quantity

		OUTPUT TO REPORT d_report(p_cust.*, p_invoice.*)
	END FOREACH

	FINISH REPORT d_report
END MAIN

FUNCTION clear_totals()
	LET i_no = 0

	FOR counter = 1 TO 3 # clear totals
		LET qtot[counter] = 0
		LET dTot[counter] = 0
		LET subTot[counter] = 0
		LET taxTot[counter] = 0
		LET finTot[counter] = 0
		LET shipTot[counter] = 0
	END FOR
END FUNCTION

#
# DETAIL REPORT
#
REPORT d_report(p_cust, p_invoice)
	DEFINE	p_cust RECORD LIKE customer.*
	DEFINE	p_invoice RECORD LIKE invoice.*
	
	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	ORDER BY p_invoice.invoice_no
	FORMAT
	PAGE HEADER
		PRINT	PAGENO USING "page <<<<", 31 SPACES, 
			"PARTIAL BACKORDER REPORT",
			31 SPACES, TODAY
		PRINT	query1 CLIPPED
		PRINT	"Invoice   Ref No   Invoice date   NotBack     ",
			"Taxes  Shipping   Discount     Total TYM"
		SKIP 2 LINES

	ON EVERY ROW
		LET subTot[1] = subTot[1] + p_invoice.subtotal

	AFTER GROUP OF p_invoice.invoice_no
		LET subTot[2] = subTot[2] + subTot[1]
		LET taxTot[1] = taxTot[1] + p_invoice.taxes
		LET shipTot[1] = shipTot[1] + p_invoice.ship_amt
		LET dTot[1] = dTot[1] + p_invoice.discount
		LET finTot[1]  = finTot[1] + p_invoice.itotal
		PRINT	p_invoice.invoice_no USING "######",
			p_invoice.ref_no USING "##########", 4 SPACES,
			p_invoice.invoice_date,
			subTot[1],
			p_invoice.taxes,
			p_invoice.ship_amt,
			p_invoice.discount,
			p_invoice.itotal
		LET subTot[1] = 0

	ON LAST ROW
		SKIP 1 LINE
		PRINT	subTot[2],
			taxTot[1],
			shipTot[1],
			dTot[1],
			finTot[1]
END REPORT
