#
# Code to handle shippers database
#
GLOBALS "globals0.4gl"

# shippers database
FUNCTION ship_menu()
	DISPLAY FORM ship_form

	LET chosen = FALSE

	MESSAGE "Type the first letter of the option ",
		"you want to select."

	MENU "SHIPPER"
	COMMAND "Add" "Add a new shipper."
	        LET answer = "y"
	        WHILE answer = "y"
			CALL enter_ship()
       
			CALL yn("Enter another shipper <y/n>")
				RETURNING answer
		END WHILE
     
	COMMAND "Query" "Search for a shippers."
		CALL query_ship()

		IF chosen THEN
			NEXT OPTION "Modify"
		END IF
	
	COMMAND "Modify" "Modify a shipper."
		IF chosen THEN
			CALL change_ship()
		ELSE
			MESSAGE "No shipper has been chosen. ",
				"Use the Query option to select ",
				"a shipper."
			NEXT OPTION "Query"
      		END IF

	COMMAND "Delete" "Delete a shipper."
		IF chosen THEN
			CALL yn(
			"Are you sure you want to delete this shipper <y/n>")
				RETURNING answer

			IF answer = "y" THEN
				CALL delete_ship()
				LET chosen = FALSE
			END IF
		ELSE
			MESSAGE "No shipper has been chosen. ",
				"Use the Query option to select ",
				"a shipper."
			NEXT OPTION "Query"
		END IF

	COMMAND "Exit" "Leave the SHIPPER menu."
		EXIT MENU
	END MENU

	CLEAR SCREEN
END FUNCTION

# shippers report
REPORT ship_list (r_ship)
	DEFINE r_ship RECORD LIKE shippers.*

	OUTPUT
		REPORT TO "shipper.lst"
		LEFT MARGIN 0
		TOP MARGIN 0
		BOTTOM MARGIN 0
		PAGE LENGTH 80

	FORMAT
	ON EVERY ROW
		PRINT	r_ship.ship_no USING "###", " ",
			r_ship.ship_name,
			r_ship.cust_cost
END REPORT
		
FUNCTION enter_ship()
	MESSAGE ""
	CLEAR FORM
	INPUT BY NAME p_ship.ship_name, p_ship.cust_cost
	AFTER FIELD ship_name
		IF p_ship.ship_name IS NULL THEN
			NEXT FIELD ship_name
		END IF
	AFTER FIELD cust_cost
		IF p_ship.cust_cost IS NULL THEN
			NEXT FIELD cust_cost
		END IF
	END INPUT

	LET p_ship.ship_no =  0

	INSERT INTO shippers VALUES (p_ship.*)

	LET p_ship.ship_no = SQLCA.SQLERRD[2]

	DISPLAY p_ship.ship_no TO ship_no

	MESSAGE "Row added."
END FUNCTION

FUNCTION query_ship()
	DEFINE  p_name CHAR(30),
		answer CHAR(1),
		exist SMALLINT

	MESSAGE ""
	CLEAR FORM

	CONSTRUCT query1 ON shippers.* FROM shippers.*

	LET s1 = "SELECT * FROM shippers WHERE ", query1 CLIPPED

	PREPARE s_1 FROM s1

	DECLARE a_curs CURSOR FOR s_1

	LET exist = FALSE
	LET chosen = FALSE

	FOREACH a_curs INTO p_ship.*
		LET exist = TRUE

		DISPLAY BY NAME p_ship.*

		CALL yn("Enter 'y' to select this shipper")
			RETURNING answer

       	   	IF answer = "y" THEN
			LET chosen = TRUE
			EXIT FOREACH
		END IF
	END FOREACH

	CLOSE a_curs

	IF exist = FALSE THEN
		MESSAGE "No shippers rows found."
	ELSE
		IF chosen = FALSE THEN
			MESSAGE "There are no more shippers rows."
		END IF
	END IF
END FUNCTION

FUNCTION change_ship()
	INPUT BY NAME p_ship.*
		WITHOUT DEFAULTS
	UPDATE shippers 
		SET shippers.* = p_ship.*
		WHERE ship_no = p_ship.ship_no
END FUNCTION 

FUNCTION delete_ship()
	DELETE FROM shippers WHERE ship_no = 
		p_ship.ship_no
	CLEAR FORM
END FUNCTION 
