# 
# 4GL program to insert data into UPS zone - weight - charge (w_z_p) table.
# By Vladimir Smelyansky at Mark Williams Co. 10-10-90
#
DATABASE mwc

GLOBALS "globals0.4gl"

#
# Working with UPS weight zone price table
#
FUNCTION ups_charge()

	OPEN FORM current_form FROM "w_z_p"
	DISPLAY FORM current_form

	MENU ""
	COMMAND "Add" "Add new row into the table"
		INPUT BY NAME p_wzp.*
		INSERT INTO w_z_p VALUES (p_wzp.*)

	COMMAND "Find" "Find data in the table" 
		CALL find_row()
		IF chosen THEN
			NEXT OPTION "Modify"
		END IF

	COMMAND "Modify" "Modify entry in the table"
		IF chosen THEN
			CALL modify_row()
		ELSE
			CALL msgs("No row has been chosen")
			NEXT OPTION "Find"
		END IF

	COMMAND "Delete" "Delete current row"
		CALL msgs("")
		IF chosen THEN
			CALL yn("Are you shure <y/n> ?") RETURNING answer
			IF answer = "y" THEN
				DELETE FROM w_z_p
					WHERE weight = p_wzp.weight AND 
					      zone = p_wzp.zone
				LET chosen = FALSE
			END IF
		ELSE
			CALL msgs("No enrty has been chosen. ")
		END IF
		NEXT OPTION "Find"

	COMMAND "Report" "Selection the report for print"
		CALL select_rep()
		NEXT OPTION "Exit"

	COMMAND "Exit" "Exit from program"
		EXIT MENU
	END MENU

	CLOSE FORM current_form
	CLEAR SCREEN
END FUNCTION

# Find entry in the w_z_p table
FUNCTION find_row()
	DEFINE  exist 	SMALLINT,
		answer	CHAR(1)

	CLEAR FORM

	CONSTRUCT query1 ON w_z_p.* FROM w_z_p.*

	LET s1 = "SELECT * FROM w_z_p WHERE ", query1 CLIPPED

	PREPARE s_w FROM s1

	DECLARE qw_curs CURSOR FOR s_w

	LET exist = FALSE
	LET chosen = FALSE

	FOREACH qw_curs INTO p_wzp.*
		LET exist = TRUE

		DISPLAY BY NAME p_wzp.*

		CALL yn("Select this row <y/n> ?") RETURNING answer
		IF answer = "y" THEN
			LET chosen = TRUE
			EXIT FOREACH
		END IF
	END FOREACH

	CLOSE qw_curs

	IF exist = FALSE THEN
		CALL msgs("No entry found")
	ELSE
		IF chosen = FALSE THEN
			CALL msgs("No more entries")
		END IF
	END IF
END FUNCTION	

#
# Modify row in weight zone price(w_z_p) table
#
FUNCTION modify_row()
	INPUT BY NAME p_wzp.*
		WITHOUT DEFAULTS

	UPDATE w_z_p
		SET w_z_p.* = p_wzp.*
		WHERE weight = p_wzp.weight AND commer = p_wzp.commer 
		      AND zone = p_wzp.zone
END FUNCTION

#
# UPS has six different groups for charges. We have to select which
# we want to print.
#
FUNCTION select_rep()

	MENU ""
	COMMAND "Ground" "Print UPS ground shipping charges"
		CALL charge_rep("ground")
		NEXT OPTION "Exit"

	COMMAND "Red" "Print UPS red shipping charges"
		CALL charge_rep("red")
		NEXT OPTION "Exit"

	COMMAND	"Blue" "Print UPS blue shipping charges"
		CALL charge_rep("blue")
		NEXT OPTION "Exit"

	COMMAND	"Canada ground" "Print UPS Canada ground shipping charges"
		CALL charge_rep("c_ground")
		NEXT OPTION "Exit"

	COMMAND	"Air Canada" "Print UPS Canada air shipping charges"
		CALL charge_rep("c_air")
		NEXT OPTION "Exit"

	COMMAND	"Inetrnational" "Print UPS international shipping charges"
		CALL charge_rep("international")
		NEXT OPTION "Exit"

	COMMAND "Exit" "Exit from menu"
			EXIT MENU
	END MENU
END FUNCTION 

#
# Print UPS shipping charges
#
FUNCTION charge_rep(kind)
	DEFINE	price ARRAY[71, 100, 2] OF 	MONEY(8, 2),
		tmp_zn, tmp_wt, cmmr, cmr	SMALLINT,
		kind, tmp_cmr			CHAR(15)
		
	DECLARE gr_curs CURSOR FOR SELECT * FROM w_z_p

	# Retrieve data from w_z_p table and fill array price
	FOREACH gr_curs INTO p_wzp.*
		LET tmp_zn = p_wzp.zone
		LET cmmr = p_wzp.commer
		LET tmp_wt = p_wzp.weight
		IF tmp_wt < 71 AND tmp_wt > -1 AND tmp_zn < 100 AND tmp_zn > 1
					AND cmmr < 2 AND cmmr > -1 THEN
			LET price[tmp_wt, tmp_zn, cmmr] = p_wzp.price
		ELSE 
			DISPLAY "Bad data ", tmp_wt, tmp_zn, cmmr
		END IF
	END FOREACH

	CLOSE gr_curs	

	# UPS has the magic numbers of zones for different kind of 
	# shipping. So we have to use these numbers.
	CASE
	WHEN  kind = "ground"
		LET tmp_cmr = "Residential"
		FOR cmr = 0 TO 1		
			IF cmr =  1 THEN
				LET tmp_cmr = "Comercial"
			END IF
	
			START REPORT gr_charge

			FOR tmp_wt = 1 TO 70
				OUTPUT TO REPORT gr_charge(
				  price[tmp_wt, 2, cmr], 
				  price[tmp_wt, 3, cmr], price[tmp_wt, 4, cmr], 
				  price[tmp_wt, 5, cmr], price[tmp_wt, 6, cmr], 
				  price[tmp_wt, 7, cmr], price[tmp_wt, 8, cmr],
				  tmp_wt, tmp_cmr)
				CALL msgs("Reporting... ")
			END FOR
			FINISH REPORT gr_charge
		END FOR
		CALL msgs("Done")

	WHEN kind = "red"
		START REPORT red_charge

		FOR tmp_wt = 0 TO 70
			OUTPUT TO REPORT red_charge(price[tmp_wt, 22, 1], 
				price[tmp_wt, 24, 1], 
				price[tmp_wt, 25, 1],
				price[tmp_wt, 26, 1],
				tmp_wt)
			CALL msgs("Reporting... ")
		END FOR

		FINISH REPORT red_charge

		CALL msgs("Done")

	WHEN kind = "blue"
		START REPORT bl_charge

		FOR tmp_wt = 0 TO 70
			OUTPUT TO REPORT bl_charge(price[tmp_wt, 12, 1], 
				price[tmp_wt, 14, 1], price[tmp_wt, 15, 1],
				price[tmp_wt, 16, 1], tmp_wt)
			CALL msgs("Reporting... ")
		END FOR

		FINISH REPORT bl_charge

		CALL msgs("Done")

	WHEN kind = "c_ground"
		START REPORT c_ground

		FOR tmp_wt = 1 TO 70
			OUTPUT TO REPORT c_ground(price[tmp_wt, 51, 1], 
				price[tmp_wt, 52, 1], price[tmp_wt, 53, 1],
				tmp_wt)
			CALL msgs("Reporting... ")
		END FOR

		FINISH REPORT c_ground

		CALL msgs("Done")

	WHEN kind = "c_air"
		START REPORT c_air

		FOR tmp_wt = 1 TO 70
			OUTPUT TO REPORT c_air(price[tmp_wt, 87, 1], 
				price[tmp_wt, 88, 1],
				price[tmp_wt, 89, 1], tmp_wt)
			CALL msgs("Reporting... ")
		END FOR

		FINISH REPORT c_air

		CALL msgs("Done")

	WHEN kind = "international"
		START REPORT int_charge

		FOR tmp_wt = 1 TO 70
			OUTPUT TO REPORT int_charge(
				price[tmp_wt, 92, 1], price[tmp_wt, 93, 1], 
				price[tmp_wt, 94, 1], price[tmp_wt, 95, 1],
				price[tmp_wt, 96, 1], price[tmp_wt, 97, 1],
				price[tmp_wt, 98, 1], price[tmp_wt, 99, 1],
				tmp_wt)
			CALL msgs("Reporting... ")
		END FOR

		FINISH REPORT int_charge

		CALL msgs("Done")
	END CASE
END FUNCTION

#
#  REPORT for UPS ground charegs
#
REPORT gr_charge(pr1, pr2, pr3, pr4, pr5, pr6, pr7, tmp, tp)
	DEFINE 	tmp 	SMALLINT,
		tp	CHAR(15),
		pr1, pr2, pr3, 
		pr4, pr5, pr6, 
		pr7		MONEY(8, 2)

	OUTPUT
		TOP MARGIN 0
		BOTTOM MARGIN 0
		LEFT MARGIN 20
		PAGE LENGTH 80
		REPORT TO PIPE "c10 | lp"

	ORDER BY tmp

	FORMAT

	PAGE HEADER 
		PRINT "UPS Shipping Charges & Zone Chart"
		PRINT COLUMN 10, "Mark Williams Co",
			COLUMN 40, "UPS shipper number: IL 612-750"
		PRINT "Ground Service  ", tp
		SKIP 3 LINES
		PRINT 	"WT", COLUMN 12, "2", COLUMN 22, "3",
			COLUMN 32, "4", COLUMN 42, "5",
			COLUMN 52, "6", COLUMN 62, "7", 
			COLUMN 72, "8"
		PRINT

	ON EVERY ROW
		PRINT 	COLUMN 0, tmp USING "##",
			COLUMN 7, pr1 USING "$#&.##", 
			COLUMN 17, pr2 USING "$#&.##", 
			COLUMN 27, pr3 USING "$#&.##", 
			COLUMN 37, pr4 USING "$#&.##", 
			COLUMN 47, pr5 USING "$#&.##", 
			COLUMN 57, pr6 USING "$#&.##",  
			COLUMN 67, pr7 USING "$#&.##"
END REPORT

#
# Blue charges report
#
REPORT bl_charge(pr1, pr2, pr3, pr4, tmp)
	DEFINE 	tmp 		SMALLINT,
		pr1, pr2, 
		pr3, pr4	MONEY(8, 2)

	OUTPUT
		TOP MARGIN 0
		BOTTOM MARGIN 0
		LEFT MARGIN 20
		PAGE LENGTH 80
		REPORT TO PIPE "c10 | lp"

	ORDER BY tmp

	FORMAT

	PAGE HEADER 
		PRINT "UPS Shipping Charges & Zone Chart"
		PRINT COLUMN 10, "Mark Williams Co",
			COLUMN 40, "UPS shipper number: IL 612-750"
		PRINT "2nd day air"
		SKIP 3 LINES
		PRINT 	"WT", COLUMN 11, "12", COLUMN 21, "14",
			COLUMN 31, "15", COLUMN 41, "16"
		PRINT

	ON EVERY ROW
		PRINT 	COLUMN 0, tmp USING "#&",
			COLUMN 7, pr1 USING "$#&.##", 
			COLUMN 17, pr2 USING "$#&.##", 
			COLUMN 27, pr3 USING "$#&.##", 
			COLUMN 37, pr4 USING "$#&.##"
END REPORT

#
# Red charges report
#
REPORT red_charge(pr1, pr2, pr3, pr4, tmp)
	DEFINE 	tmp 	SMALLINT,
		pr1, pr2, pr3, pr4	MONEY(8, 2)

	OUTPUT
		TOP MARGIN 0
		BOTTOM MARGIN 0
		LEFT MARGIN 20
		PAGE LENGTH 80
		REPORT TO PIPE "c10 | lp"

	ORDER BY tmp

	FORMAT

	PAGE HEADER 
		PRINT "UPS Shipping Charges & Zone Chart"
		PRINT COLUMN 10, "Mark Williams Co",
			COLUMN 40, "UPS shipper number: IL 612-750"
		PRINT "Next Day Air"
		SKIP 3 LINES
		PRINT 	"WT", COLUMN 11, "22", COLUMN 22, "24",
			COLUMN 33, "25", COLUMN 44, "26"
		PRINT

	ON EVERY ROW
		PRINT 	COLUMN 0, tmp USING "#&",
			COLUMN 7, pr1 USING "$#&.##", 
			COLUMN 17, pr2 USING "$##&.##", 
			COLUMN 28, pr3 USING "$##&.##",
			COLUMN 39, pr4 USING "$##&.##"
END REPORT

#
# Canada ground charges report
#
REPORT c_ground(pr1, pr2, pr3, tmp)
	DEFINE 	tmp 	SMALLINT,
		pr1, pr2, pr3	MONEY(8, 2)

	OUTPUT
		TOP MARGIN 0
		BOTTOM MARGIN 0
		LEFT MARGIN 20
		PAGE LENGTH 80
		REPORT TO PIPE "c10 | lp"

	ORDER BY tmp

	FORMAT

	PAGE HEADER 
		PRINT "UPS Shipping Charges & Zone Chart"
		PRINT COLUMN 10, "Mark Williams Co",
			COLUMN 40, "UPS shipper number: IL 612-750"
		PRINT "Canada ground"
		SKIP 3 LINES
		PRINT 	"WT", COLUMN 11, "51", COLUMN 21, "52",
			COLUMN 31, "53"
		PRINT

	ON EVERY ROW
		PRINT 	COLUMN 0, tmp USING "##",
			COLUMN 7, pr1 USING "$#&.##", 
			COLUMN 17, pr2 USING "$#&.##", 
			COLUMN 27, pr3 USING "$#&.##"
END REPORT

#
# Canada air charges report
#
REPORT c_air(pr1, pr2, pr3, tmp)
	DEFINE 	tmp 	SMALLINT,
		pr1, pr2, pr3	MONEY(8, 2)

	OUTPUT
		TOP MARGIN 0
		BOTTOM MARGIN 0
		LEFT MARGIN 20
		PAGE LENGTH 80
		REPORT TO PIPE "c10 | lp"

	ORDER BY tmp

	FORMAT

	PAGE HEADER 
		PRINT "UPS Shipping Charges & Zone Chart"
		PRINT COLUMN 10, "Mark Williams Co",
			COLUMN 40, "UPS shipper number: IL 612-750"
		PRINT "Canada Air"
		SKIP 3 LINES
		PRINT 	"WT", COLUMN 11, "87", COLUMN 21, "88", COLUMN 31, "89"
		PRINT

	ON EVERY ROW
		PRINT 	COLUMN 0, tmp USING "##",
			COLUMN 7, pr1 USING "$##&.##", 
			COLUMN 17, pr2 USING "$##&.##",
			COLUMN 27, pr3 USING "$##&.##"
END REPORT

#
# UPS International charges
#
REPORT int_charge(pr1, pr2, pr3, pr4, pr5, pr6, pr7, pr8, tmp)
	DEFINE 	tmp 		SMALLINT,
		pr1, pr2, pr3, 
		pr4, pr5, pr6, 
		pr7, pr8	MONEY(8, 2)

	OUTPUT
		TOP MARGIN 0
		BOTTOM MARGIN 0
		LEFT MARGIN 20
		PAGE LENGTH 80
		REPORT TO PIPE "c10 | lp"

	ORDER BY tmp

	FORMAT

	PAGE HEADER 
		PRINT "UPS Shipping Charges & Zone Chart"
		PRINT COLUMN 10, "Mark Williams Co",
			COLUMN 40, "UPS shipper number: IL 612-750"
		PRINT "International"
		SKIP 3 LINES
		PRINT 	"WT", COLUMN 7, "92", COLUMN 16, "93",
			COLUMN 25, "94", COLUMN 34, "95",
			COLUMN 43, "96", COLUMN 52, "97", 
			COLUMN 61, "98", COLUMN 70, "99"
		PRINT

	ON EVERY ROW
		PRINT 	COLUMN 0, tmp USING "##",
			COLUMN 6, pr1 USING "$##&.##", 
			COLUMN 15, pr2 USING "$##&.##", 
			COLUMN 24, pr3 USING "$##&.##", 
			COLUMN 33, pr4 USING "$##&.##", 
			COLUMN 42, pr5 USING "$##&.##", 
			COLUMN 51, pr6 USING "$##&.##",
			COLUMN 60, pr7 USING "$##&.##",
			COLUMN 69, pr8 USING "$##&.##"
END REPORT
