#
# Informix 4GL program to make UPS reports.
# By Vladimir Smelyansky of Mark Williams 10/19/90
#
DATABASE mwc

GLOBALS	 "globals0.4gl"

FUNCTION ups_main()

	OPTIONS MESSAGE LINE 22,
		PROMPT LINE 21,
		DELETE KEY CONTROL-K,
		NEXT KEY CONTROL-N,
		PREVIOUS KEY CONTROL-P

	CLEAR SCREEN

	WHILE 1 = 1
		PROMPT "Enter ship location. mwc is 0 " FOR shiploc
		IF shiploc = 0 OR shiploc = 1 THEN
			EXIT WHILE
		END IF
	END WHILE

	MENU ""
	COMMAND "UPS Report" "Add new entry, correct, print, & close reports"
		CALL ups_central()
		NEXT OPTION "Exit"
	
	COMMAND "Tag" "UPS call tag database"
		CALL ups_tag()
		NEXT OPTION "Exit"

	COMMAND "Price" "UPS weight - zone - price database"
		CALL ups_charge()
		NEXT OPTION "Exit"

	COMMAND "Ground" "UPS zipcode - zone number table"
		CALL ups_grzone()
		NEXT OPTION "Exit"

	COMMAND "Record #" "UPS record number"
		CALL ups_record()
		NEXT OPTION "Exit"

	COMMAND "Exit" "Exit from UPS program"
		EXIT MENU
	END MENU
END FUNCTION

#
# This is central UPS function
#
FUNCTION ups_central()

	OPEN FORM ups_form FROM "PickLine"
	DISPLAY FORM ups_form

	MENU ""
	COMMAND "Add" "Enter next invoice number for UPS report"
		CALL ups_add()

	COMMAND "Today" "Look throught and correct current UPS report"
		CALL ups_correct()

	COMMAND "Report UPS" "Print current report. "
		LET tbl = "o"
		CALL ups_report()

	COMMAND "Last" "Print precedes UPS report"
		LET tbl = "x"
		CALL ups_report()

	COMMAND "Close" "Close UPS report."
		CALL ups_close()
		NEXT OPTION "Exit"

	COMMAND "Exit" "Leave UPS report database"
		CLOSE FORM ups_form
		CLEAR SCREEN
	  	EXIT MENU
	END MENU

END FUNCTION

#
# Display a message
#
FUNCTION msgs(msg)
	DEFINE msg CHAR(50)

	MESSAGE ""
	MESSAGE msg
END FUNCTION	

#
# Get UPS record number.
# Update data in the RecordNumber table.
#
FUNCTION ups_record()

	SELECT MAX(rec_number) INTO recnumber FROM RecNumber

	CALL msgs("")
	PROMPT "Old number ", recnumber CLIPPED, ".", " New value ? " 
			FOR recnumber

	IF recnumber is NULL THEN
		CALL msgs("Bad value. Record number would not be changed.")
		GOTO goaway
	END IF
	DELETE FROM RecNumber

	INSERT INTO RecNumber(rec_number)
		VALUES (recnumber)
	

	LABEL goaway:

END FUNCTION
