#
# Informix 4GL program that creates data-tables for 
# UPS Computer Manifest System.
# By Vladimir Smelyansky of Mark Williams Co. 10-04-90
#
MAIN

DATABASE mwc

#
# This table contents rows weight, zone, price
#
	CREATE TABLE w_z_p(
		weight		SMALLINT,
		zone		SMALLINT,
		price	        MONEY(5,2),
		commer		SMALLINT
	)
	CREATE UNIQUE INDEX weight_zone ON w_z_p (weight, zone)

# If country is Canada UPS got too sophisticated rules for
# finding zone number. Zone number will be input by hands 
# for first release.
#
# International mail will not be sent by UPS (in general)
# We can print zone numbers  by hands for all two of customers.
#

# 
# This table needs for UPS reports
#
		CREATE TABLE pickup_line (
			invoice_no	INTEGER,
			contact		CHAR(14),
			address		CHAR(18),
			city		CHAR(8),
			state		CHAR(3),
			country		CHAR(4),
			zipcode		CHAR(7),
			commer		SMALLINT,
			weight		SMALLINT,
			zone		SMALLINT,
			charge		MONEY(8, 2),
			dec_value	MONEY(8, 2),
			cod_amt		MONEY(8, 2),
			cod_chrg	MONEY(8, 2),
			aod		CHAR(1),
			cll		CHAR(1),
			pack_no		SMALLINT,
			closed		CHAR(1),
			cl_date		DATE,
			ship_loc	SMALLINT
		)


#
# This table is for the USA ground service.
# All zipcodes between two numbers zip1 and zip2 * 100
# have the same zone number - zone. If zip code is not between
# these numbers it means that UPS doesn't have ground service
# (Alaska Rural for example).
#
	CREATE TABLE ground(
		from_zip	SMALLINT,
		to_zip		SMALLINT,
		zone		SMALLINT
	)

	WHEN tbl_name = "RecNumber"
		CREATE TABLE RecNumber (
			rec_number	INTEGER,
			pick_date	DATE
		)

END MAIN		
