.NH "Changes From Release 4.2.05"
.PP
The following describes how \*(CO release 4.2.10 differs from
\*(CO release 4.2.05, which was the last release of \*(CO shipped to users.
.SH "Changes to the Kernel"
.PP
The following changes have been made to the \*(CO kernel and drivers:
.IP \(bu 0.3i
Some kernel bugs have been corrected that caused panics under
special conditions.
In particular, the bug that causes the ``Ring 1 Panic' has been traced
to the AT driver, and changes made to correct it.
.IP \(bu
Under \*(CO 4.2.05, the driver
.B asy
attempted to test for the presence of a UART.
However, the test did not always work correctly
because some newer 16550's no longer follow specification of IIR = xx00 xxxx.
The test has been rewritten to take this into account.
.IP \(bu
The driver
.B vtnkb
now supports Greek keyboards.
.IP \(bu
The driver
.B hai
has been changed to make its resetting more robust.
It now supports 255-head hard disks correctly.
Its default timeout has also been increased, to eliminate bogus
timeout messages when running slow drives.
.IP \(bu
The driver
.B at
has been modified to address a bug that caused panics and timeouts.
.IP \(bu
The kernel now clears the U area upon startup.
This problem had caused \*(CO installation to fail on a few systems.
.IP \(bu
Under certain circumstances, the kernel would crash if given a bad
physical address; it now complains and keeps running.
.IP \(bu
The kernel now recognizes Cyrix parts.
You can optionally enable the internal cache on the
SRx, SRx2, DRx, and DRx2 upgrade parts.
.IP \(bu
The file system has been changed to be more robust.
.IP \(bu
Global variable
.B RLOCKS
is now tunable.
.IP \(bu
In some instances, kernel error messages would print a bogus
number for a system call.
This has been fixed.
.IP \(bu
In some circumstances, the kernel used
.B rep
I/O instructions instead of explicit loops.
On some motherboards, this can cause the CPU to outrun the I/O bus.
The kernel has now removed all
.B rep
instructions and uses loops instead.
.IP \(bu
Variables
.B MSGQID_SPEC
and
.B MSGQSZ_SPEC
have been added to file
.BR /conf/install_conf/src/mtune .
.IP \(bu
Routines that report CPU idle times have been upgraded.
.IP \(bu
Under certain circumstances,
signalling did not work correctly.
This has been fixed.
.IP \(bu
Under \*(CO 4.2.05,
some screen contents would be lost
when the user switched sessions on a system with two video adapters.
This has been repaired.
.IP \(bu
Routines
.BR __kdenabio() ,
.BR __kddisabio() ,
.BR __kdaddio() ,
and
.B __kddelio()
have been added to the \*(CO device-driver kit.
.IP \(bu
Invoking
.B brk()
twice consecutively with the same arguments would cause a
.B PTOV
fault.
This has been fixed.
.IP \(bu
Changes to the kernel now permit
.B reboot
to reboot the system, rather than just bring it down and wait for the user
to press the reset the button.
.IP \(bu
The instruction
.DM
	while (sbrk(4096))
.DE
.IP
would crash the system under some circumstances.
This has been fixed.
.IP \(bu
The memory manager erroneously rounded down
byte lengths not a multiple of a page size,
which under some circumstances created problems.
This has been corrected.
.IP \(bu
The memory manager returned filler below the alignment address.
This has been corrected.
.SH "Changes to Commands and Scripts"
.PP
The following changes have been made to \*(CO commands and scripts:
.IP \fB/bin/cc\fR
This version (4.5.1) fixes a bug in sign extension, which affected
the compilation of some X applications.
It also fixes option \fB\-g\fR, which generates debugging information.
Under previous releases, this option would break the COFF output.
Other changes correct inappropriate extension of arguments from
.B short
to
.BR int .
.IP \fB/bin/df\fR
This command now uses
.B fstat
and
.B fstatfs
instead of opening raw device.
Environmental variables
.BR DF_OLD ,
.BR OLDSTYLE,
etc., now no longer affect its behavior.
.IP \fB/bin/fwtable\fR
This version (1.6) fixes a bug that caused it to generate bogus tables under
certain conditions.
.IP \fB/bin/ld\fR
This version (4.2.3) fixes some minor bugs.
.IP \fB/bin/login\fR
This has been recompiled to use the latest version of
.BR ctime() .
.IP \fB/bin/make\fR
This command now correctly handles
.BR Makefile s
generated by
.BR imake .
.IP \fB/bin/man\fR
The version of this command shipped with \*(CO 4.2.05 could run out
of memory if it attempted to read too many index files.
This has been fixed:
now it can read an indefinite number of index files.
.IP \fB/bin/newgrp\fR
The version of this program under 4.2.05 incorrectly set no password in a
newly created group, thus creating a security hole.
This has been fixed.
Its default permissions have also been set to \fBr-s-x-x root bin\fR.
.IP \fB/bin/ps\fR
This now returns the proper exit status.
.IP \fB/bin/qfind\fR
This command would page fault under certain circumstances.
It has been repaired.
.IP \fB/bin/sed\fR
This command
features improved error reporting.
.IP \fB/bin/sh\fR
.B exec
has been repaired.
.IP \fB/bin/test\fR
This command now correctly handles empty arguments, and reacts correctly
when handed no arguments.
.IP \fB/bin/troff\fR
This command's suite of font-width tables have been rebuilt using new
.B .tfm
tables supplied by Hewlett-Packard.
These tables are stored in directory
.BR /usr/lib/roff/troff_pcl/fwt .
.IP \fB/bin/wc\fR
This now returns the proper exit status.
.IP \fB/etc/build\fR
This script now allow lets you skip running
.B badscan
on AT drives.
It also allows you to
.B badscan
SCSI drives; this is now allowed because of problems with bad blocks
reported by users who have removable SCSI media.
.IP \fB/etc/build.u\fR
Corrected the word ``Owervite'' to ``Overwrite'' in an error message.
.IP \fB/etc/fsck\fR
This command would page fault if accidentally run on a
.B cpio
backup disk.
This has been fixed.
.IP
The ``memory allocation failed'' error message has been expanded.
.IP \fB/etc/install\fR
This command now correctly handles partial installations.
If it finds a tag file in the root directory, it asks you whether to
continue, rather than simply aborting installation.
.IP \fB/etc/mklost+found\fR
This script is a new command that lets you build a larger
.B lost+found
directory than \*(CO utilities build by default.
.IP \fB/etc/newusr\fR
This script had a problem whereby it mistakenly used the identifier
.BR add_user .
This has been repaired.
.IP
Because
.B vsh
is not a login shell, this has been removed from the list of login shells
presented to the user.
.IP \fB/etc/profile\fR
This file now uses
.B cat
to display the file
.B /etc/motd
by default.
This is not done if
.B $HOME
is
.BR /etc .
.IP
Instruction
.DM
	[ -f /etc/motd ...
.DE
.IP
has been changed to:
.DM
	[ -s /etc/motd ...
.DE
.IP \fB/etc/reboot\fR
Changes to the kernel now permit
.B reboot
to reboot the system, rather than just bring it down and wait for the user
to press the reset the button.
Note that it still prompts you to press the reset button, but if you wait
a few moments it will (in all probability) reboot your system automatically.
.IP \fB/etc/wall\fR
This command has been changed so that it no longer hangs when
it encounters a bogus entry in
.BR /etc/utmp .
This corrects the problem that caused the script
.B /etc/shutdown
to hang after a user had run X.
.IP \fB/etc/conf/aha/mkdev\fR
This script has been added.
It walks you through the process of describing your SCSI devices to the driver
.B aha
(the alternate driver for Adaptec SCSI disks).
.IP \fB/etc/conf/asy/mkdev\fR
This scipt now walks you through the process of configuring a modem, as well
as describing a serial port.
Its prompts have been reworded to make them clearer.
.IP \fB/etc/conf/at/mkdev\fR
This script has been added.
It walks you through the process of describing your AT disks to the driver
.BR at .
.IP \fB/etc/conf/bin/devadm\fR
Identifier
.B STARTUP
has been corrected to
.BR START .
.IP \fB/etc/conf/cohmain/mkdev\fR
This script now asks you whether you wish to enable the Cyrix upgrade cache,
should your system have a Cyrix part.
A new global variable identifies CPU type.
.IP \fB/etc/conf/hai/mkdev\fR
The initial version of this script confused variables
.B ID
and
.BR i ,
which created problems under certain circumstances.
This has been repaired.
.IP
This script has also been modified to permit you to install a tape driver
even if you do not have a SCSI hard disk.
.IP
Its prompts have been reworded to make them clearer.
.IP \fB/etc/conf/install_conf/sdevice\fR
Defaults for drivers
.BR echo ,
.BR loop ,
and
.B dump
were incorrectly set to `Y'; now correctly set to `N'.
.IP \fB/etc/conf/lp/mkdev\fR
This script's prompts have been reworded to make them clearer.
.IP \fB/etc/conf/pty/mkdev\fR
This script has been added to the release.
It walks you through the task of configuring the driver
.BR pty ,
which handles pseudo-TTYs.
.IP \fB/etc/conf/ss/mkdev\fR
This script has been added.
It walks you through the configuring of the driver
.B ss
(the alternate driver for Seagate SCSI disks).
.IP \fB/etc/conf/bin/idbld\fR
This new script walks you through the process of building an entirely
new kernel.
It invokes each
.B mkdev
script in turn, then invokes
.BR /etc/conf/bin/idmkcoh
to build the newly reconfigured kernel.
.\".IP \fB/etc/install\fR
.\"This command now supports pre-files.
.\"That is, it executes file \fB/conf/\fItag\fB.pre\fR
.\"before
.IP \fB/usr/bin/cancel\fR
This now correctly cancels a job for the MLP spooler.
.IP \fB/usr/bin/elvis\fR
This has been updated to release 1.8.
.IP
The command
.B cc
in this editor did not work properly.
This has been repaired.
.IP
.B elvis
now invokes
.B elvprsv
from
.BR /etc/rc .
.B elvprsv
and
.B elvrec
have permissions \fB4755 root root\fR, and
.B /usr/preserve
now has permissions \fB755 root root\fR.
.IP \fB/usr/bin/gzip\fR
This has been updated to use the latest GNU sources.
.IP \fB/usr/bin/ksh\fR
The previous release of this shell dropped argument 1; this has
been fixed.
Its handling of
.B SIGINT
and
.B SIGQUIT
have also been fixed.
.IP \fB/usr/bin/lp\fR
.IS \fB/usr/bin/lpsched\fR
Several bugs have been fixed in the MLP spooler and daemon.
In particular, the option \fB\-m\fR now works.
.SH "Changes to Library Routines and Macros"
.PP
The following library routines and macros have been changed or repaired.
.IP \fBftime()\fR
This has been restored as a COFF system call.
.IP \fBlibcurses\fR
This library has been updated to fix bugs and incorporated some previously
unsupported routines.
.IP \fBva_start()\fR
This routine, in header file
.BR <stdarg.h> ,
has been rewritten so that it can be used with the GNU C++ compiler
.BR g++ .
.IP \fBdiv()\fR
In-lining of this routine, which lives in header file
.BR <stdlib.h> ,
has been conditionalized.
This is done because
.B gcc
correctly handles such in-lined routines, but
.B g++
does not.
.IP \fBldiv()\fR
In-lining of this routine, which lives in header file
.BR <stdlib.h> ,
has been conditionalized.
This is done because
.B gcc
correctly handles such in-lined routines, but
.B g++
does not.
.IP \fBprintf()\fR
This has been updated to correct some minor errors.
.IP \fB/lib/ndp/libm.a\fR
This library lacked some floating-point op-codes for hardware floating-point
arithmetic.
This has been corrected.
.SH "Changes to Header Files"
.PP
.IP \fB/usr/include/float.h\fR
The values for
.B DBL_MAX
and
.B DBL_MIN
have been corrected.
.IP \fB/usr/include/limits.h\fR
.B __SCHAR_MIN
was misspelled.
This has been corrected.
.IP \fB/usr/include/math.h\fR
This file now contains the following corrected prototypes for
.B frexp
and
.BR ldexp :
.DM
	double	frexp	__PROTO ((double _x, int * _iptr));
	double	ldexp	__PROTO ((double _x, int _i));
.DE
.IP \fB/usr/include/stdlib.h\fR
This header file has had the line
.DM
	#include <common/xdebug.h>
.DE
.IP
removed.
.IP \fB/usr/include/common/__stat.h\fR
The R4
.B stat
structure in this header file has been suppressed, so that it
works with the latest release of GNU C.
.IP \fB/usr/include/coh/proc.h\fR
.IS \fB/usr/include/coh/timeout.h\fR
These header files have been added to make the kernel more compatible with GCC.
.IP \fB/usr/include/sys/confinfo.h\fR
Added
.B EXTERN_CLOSE
declaration to
.BR DECLARE_OPEN_CLOSE .
.IP \fB/usr/include/sys/cyrix.h\fR
This header file has been added to help support the Cyrix part.
.IP \fB/usr/include/sys/mmu.h\fR
Symbols
.B SEG_PWT
and
.B SEG_PCD
have been added to this header file.
.IP \fB/usr/include/sys/stat.h\fR
The R4
.B stat
structure in this header file has been suppressed, so that it
works with the latest release of GNU C.
.IP \fB/usr/include/sys/msg.h\fR
.IS \fB/usr/include/sys/sem.h\fR
.IS \fB/usr/include/sys/shm.h\fR
BCS-compatible pid length has been restored.
.IP \fB/usr/include/sys/types.h\fR
Type
.B u_long
et al. have been added.
.SH "Miscellaneous Changes"
.PP
The following miscellaneous changes have been made:
.IP  "Floppy-Disk Device Nodes\fR"
A number of changes have been made to floppy-disk device nodes.
The following nodes have been deleted:
.DM
	/dev/f9d0
	/dev/f9d1
	/dev/rf9d0
	/dev/rf9d1
.DE
.IP
The following nodes have been deleted and remade:
.DM
.ta 0.5i 2.0i
	/dev/dsk/f03d	/dev/rdsk/f03d
	/dev/dsk/f13h	/dev/rdsk/f13h
	/dev/dsk/f03d	/dev/rdsk/f03d
	/dev/dsk/f13h	/dev/rdsk/f13h
.DE
.IP "\fBSCSI Disk Device Nodes\fR"
Permissions on devices \fB/dev/{r}sd[a-d]\fR have been changed
\fB600 sys sys\fR.
Permissions on devices \fB/dev/{r}sdx\fR have been changed to
\fB600 root root\fR.
This matches the permissions for the \fBat\fR devices.
The
.B mkdev
scripts for these devices have also been updated to enforce these changes.
.IP \fB/lib/libc.a\fR
.IS \fB/lib/ndp/libc.a\fR
This version (4.2.3) fixes some bugs in some library routines, and include
a few routines that had been left out.
.IP \fB/lib/yyparse.c\fR
This has been updated to correct some minor bugs.
.IP "\fBManual Pages\fR"
These have been updated to include the latest changes and updates to the
software.
.IP \fB/usr/lib/makeactions\fR
.IS \fB/usr/lib/makemacros\fR
These have been updated to conform more closely to published standards.
.IP \fB/usr/lib/shell_lib.sh\fR
The routine
.B split_path
has had a minor bug corrected.
.IP \fB/usr/lib/uucp/sys\fR
The default version of this file
now includes the instructions
.DM
	remote-send
	remote-receive
	local-send
	local-receive
.DE
.IP
for the entry for site
.BR mwcbbs .
.IP \fB/usr/lib/libcurses.a\fR
.IS \fB/usr/lib/ndp/libcurses.a\fR
These incorporate fixes to minor bugs in the
.B curses
routines.
.IP \fBterminfo\fR
.IS \fBtermcap\fR
Some terminal descriptions have been repaired, in particular, the
.B xterm
entry in
.BR termcap .
.IP
Regional scrolling has been fixed in the
.B termcap
description for the console;
.B Blast
and GNU Emacs now scroll correctly.
