.ds TL "Additional Software"
.ds TI "RELEASE NOTES"
.NH "Additional Software for COHERENT"
.PP
Numerous software products are available for \*(CO.
These include industry-standard products, such as Lotus 1-2-3, WordPerfect,
Basmark QuickBASIC, the MBP Visual Cobol compiler, and many others.
.PP
You can order some of these packages through Mark Williams Company
by calling Mark Williams sales department at 1-800-636-6700 or 1-708-291-6700.
.PP
The \*(CO command
.B phone
comes with a ``phonebook'' that gives the names, telephone numbers, and
a brief description for many software vendors who sell software for \*(CO.
If you are looking for a particular item, check there first.
For example, if you are looking for implementations of the BASIC language
under \*(CO, type the command:
.DM
	phone BASIC
.DE
This prints on your screen the name and telephone number of each third-party
vendor who has published a version of BASIC \(em at least, that we knew about
when you purchased \*(CO.
.PP
Mark Williams Company also publishes products for \*(CO.
These include X Windows for \*(CO;
the five volumes of COHware, which give some the best of the
public-domain software for \*(CO;
the \*(CO Device-Driver Kit;
the \*(CO GNU Development Kit;
GNU Tools, a collection of GNU tools and utilities ported to \*(CO;
source code for GNU C and the GNU tools;
and GNU Emacs, a full implementation of the famous Emacs editor.
.PP
An order form is available at the back of these notes
for ordering the products produced by, or available through,
Mark Williams.
Or you can order by calling 1-800-636-6700, or 1-708-291-6700.
.PP
The following sections introduce the products available from Mark Williams
Company, and some of the third-party suppliers of software.
.SH "The COHERENT Club"
.PP
The \*(CO Club offers great savings on third-party software.
For a one-time payment of $49.95,
you can get significant discounts from Mark Williams Company
on such third-party software products as WordPerfect,
other \*(CO products sold by Mark Williams, and discounts on future
enhancements and updates to \*(CO.
The order form at the back of this booklet shows some of the discounts
you can receive.
.PP
To join, fill out the form at the end of these notes, or call Mark Williams
Company at 1-800-636-6700 or 1-708-291-6700.
.SH "X Windows for COHERENT"
.PP
Beginning with release 4.2, \*(CO supports the X Window System,
the industry-standard computer windowing system.
X Windows for \*(CO is Mark Williams port of X Windows.
With X Windows for \*(CO, you can open multiple windows on your screen,
and use icons, pop-up menus, graphics on your \*(CO system.
.PP
X Windows for \*(CO includes a generous selection of X utilities,
clients, and games.
It also includes libraries, header files, fonts, and bit-mapped images, so
you can begin to import the wealth of X applications that are now available
in the public domain.
.PP
X Windows for \*(CO, like all Mark Williams products, is reasonably priced,
and comes with full technical support.
Also included is a 200-page manual that introduces X Windows and documents
every utility, client, and game included in the package.
.PP
Note that X Windows for \*(CO requires eight megabytes of RAM,
a serial mouse, and a VGA video card and monitor.
.PP
To order X Windows for \*(CO, call 1-800-636-6700 or 1-708-291-6700,
or use the order form at the end of these notes.
.SH XWare
.PP
The X Window System has a wealth of software available for it.
To help make this software available to you under \*(CO,
Mark Williams Company offers
.BR Xware !
.PP
Each Xware package is a collection of carefully selected X programs.
Almost every program comes with both an executable binary and source
code, plus rewritten and formatted manual pages that you can read with
the \*(CO
.B man
command.
.PP
Six Xware packages are available to you:
.IP "\fBXware 1\fR: Window Managers"
This package offers the window managers \*(OL, from Sun Microsystems; and
.BR fvwm ,
a small, efficient window manager that looks like Motif.
Also included are several hundred fonts, to further improve the appearance
of your X environment.
.IP "\fBXware 2\fR: Games\fR"
This package is just for fun.
Battle deadly tanks, struggle with your computer for control of the world,
play Mah-Jongg and solitaire \(em all in the X Windows graphical environment.
.IP "\fBXware 3\fR: Graphics\fR"
This package offers a wealth of graphics programs for X.
View GIF files, display animations, model and display the evolution of
an imaginary planet, plug entertaining screen-savers into your system \(em
and much more.
Also included are a generous selection of GIF images from Project Apollo
and from the newly repaired Hubble Space Telescope.
.IP "\fBXware 4\fR: Tools and Utilities\fR"
This package assembles a number of helpful utilities.
Included are a powerful spreadsheet, including matrix algebra functions
and graphing; an interactive file manager;
utilities for attaching notes to your screen; tools for displaying system
load, and for viewing manual pages interactively; and more.
.IP "\fBXware 5\fR: Development Tools\fR"
This package offers Tcl, the hot new development language; and Tk,
a large collection of widgets and function that you can use interactively.
Also included are
.BR wish ,
the interactive shell built from Tcl and Tk; and
.BR xf ,
an interactive tool with which you can easily build X front ends for your
programs.
You can also use Tcl with your non-X programs.
.IP "\fBXware 6\fR: Ghostscript\fR"
With this package, you can display your PostScript files and clip art
directly within an X window, without having to print them.
Also included are drivers for a variety of output devices, including
a number of printers.
.PP
To order an Xware package, use the order form at the back of this booklet,
or call Mark Williams Company.
.SH "Introducing COHware"
.PP
The amount of contributed software appearing on our Bulletin Board System
is already much, much more than we ever imagined
it would be \(em and it keeps on growing.
You could go through the inconvenience and expense
of downloading the packages one by one via modem;
but we have come up with a better answer:
COHware!
.PP
Now the best of the contributed software from our BBS is available on
floppy disk.
Almost every program comes both compiled, and with its full source code.
You can use the programs as is, or you can modify them for your own
applications.
Don't waste your time on a problem that has already been solved
within one of these programs, and don't tie up your modem for hours on end.
COHware opens up the world of C programming under \*(UN \(em
take a look at how a sophisticated shell is built from the inside out \(em
find out how a text editor is written \(em all this and much
more can be found within COHware.
.PP
Volumes I and II of COHware were designed for \*(CO 286, with its
limited address space.
However, COHware volumes III, IV, and V are
filled with software that has been ported
to, or rewritten for, the \*(CO-386 32-bit addressing space.
It also holds many of the favorite programs that appeared in the first
two volumes.
.PP
.\"COHware volume III contains the following:
.\".so /v/fwb/coherent/rel.notes/coherent/coh4.2.10/contents.CW3.r
.\".PP
.\"COHware volume IV contains the following:
.\".so /v/fwb/coherent/rel.notes/coherent/coh4.2.10/contents.CW4.r
.\".PP
.\"COHware volume V contains the following:
.\".so /v/fwb/coherent/rel.notes/coherent/coh4.2.10/contents.CW5.r
.\".PP
You can order volume III of COHware for only $40;
and you can order volumes IV and V for only $49.
Use the order form in the catalogue, or call 1-800-636-6700 for
fast service.
Remember, if you are a member of the \*(CO Club, you will receive
a discount on these packages.
.SH "The COHERENT Device Driver Kit"
.PP
The
.B "COHERENT Device Driver Kit"
contains everything that an
experienced programmer needs to write a device driver for \*(CO,
including source code for almost every driver included with \*(CO.
The Kit brings a new level of support
for writing drivers and has greater detail than \*(UX versions.
.PP
Release 4.2.14 of the Kit documents the \*(CO implementation of
\*(ST, which now makes it easier than ever to write a device driver
for \*(CO, \*(UN, and any other operating system that supports \*(ST.
.PP
The Kit also includes full source code for
almost all device drivers shipped with the \*(CO system
(excluding only a few that use proprietary information from third-party
suppliers), including the following:
.nf
.sp \n(pDu
	Console driver
	Virtual consoles driver
	Keyboard drivers, both non-loadable and loadable
	Serial-port driver, including non-intelligent multi-port cards
	Parallel-port driver
	AT hard-disk driver
	Host-adapter-independent SCSI driver
	Floppy-disk driver
	Memory driver
.fi
.PP
Just reading the source code can be very helpful in learning how to cope
with real-world problems in writing device drivers for
multi-tasking environments like \*(CO and \*(UN.
These are supplemented in the manual by tutorials and a detailed example.
.PP
The price is right, too.
Like all Mark Williams software, our Device Driver Kit is very affordable.
Use the form at the end of this manual to order the
best value in driver kits.
.SH "GNU Tools"
.PP
Mark Williams Company has ported to \*(CO many of the GNU software tools,
from the Free Software Foundation.
.Sh "GNU Development System"
.PP
The GNU Development System packages a fine selection of GNU
software development tools:
.IP \(bu 0.3i
Release 2.5.6 of the GNU C compiler.
GNU C offers full support for the ANSI C standard,
plus numerous extensions and features not found in most C compilers.
.\" Including ours.
.IP \(bu
GNU implementation of the C++ and Objective C languages.
With these, you can explore the world of object-oriented programming.
.IP \(bu
GNU linker and assembler.
.IP \(bu
.BR gdb ,
the GNU source-level debugger.
With
.BR gdb ,
you can debug your C programs using your C code \(em you don't have to
resort to assembly language.
.B gdb
also works with the standard \*(CO C compiler.
.IP \(bu
.BR info ,
the advanced information command.
.B info
offers tutorials and thorough help information for all GNU tools.
.PP
With
.BR "GNU C" ,
you can begin to work with the wealth of source code available
through Free Software Foundation.
.Sh "GNU Tools"
.PP
Mark Williams offers
.BR "GNU Tools" ,
a set of tools from the Free Software Foundation.
These include the GNU versions of many \*(UN or \*(CO tools.
.Sh "GNU Sources"
.PP
Mark Williams also offers the
.BR "GNU Source Kit" .
This gives you full source code for the GNU C compiler and the GNU tools
in a ready-to-compile form.
With it, you can rebuild the GNU packages on your system
and study the design of this major piece of software.
NB, this kit requires that you have GNU C.
.Sh "GNU Emacs"
Finally, Mark Williams offers GNU Emacs, the full implementation of
the famous Emacs editor.
Users who have used \*(CO's version of the \*(ME editor have had a taste
of the power of this tool.
However, GNU Emacs is truly a programming environment, not just an editor.
It offers many features not available in \*(ME, including
the ability to write editor extensions in LISP.
.Sh "Ordering Information"
.PP
To order, use the form at the end of this pamphlet; or you can order by
calling 1-800-636-6700 or 1-708-291-6700.
.PP
We know how you value Mark Williams Company's commitment to user support.
However, because of the nature of these products, we cannot offer
technical support on the Device Driver Kit, COHware, GNU Tools, or GNU C.
.SH "Third-Party Software Packages for COHERENT 4.2"
.PP
What follows is a list of companies that have ported their
software to \*(CO, or whose software runs under \*(CO unchanged from
other \*(UN implementations.
Also listed are the names and a brief description of each product.
Please note that this list is growing all the time.
For the latest information on third-party products that run under \*(CO,
dial into the \*(CO bulletin board, or telephone Mark Williams Company.
.IP "\fBACC Corporation\fR"
.nf
SWiM 1.2.3, a port of OSF Motif to \*(CO
(203) 454-3242 (voice)
info@acc-corp.com
.fi
.IP "\fBAcucobol Inc.\fR"
.nf
Acucobol (COBOL compiler)
1-619-689-7220 (voice)
1-800-262-6585 (voice)
1-619-566-3071 (FAX)
.fi
.IP "\fBAppgen Business Software\fR"
.nf
Appgen (Accounting 4GL and RDBMS)
1-516-471-3200 (voice)
1-516-471-3291 (FAX)
.fi
.IP "\fBArosoft\fR"
.nf
ADFprofi (Office Automation and RDBMS, in German)
49-30-525-2150 (voice)
49-30-525-3461 (FAX)
.fi
.IP "\fB/ARX Cleanware\fR"
.nf
MacroCALC (Spreadsheet)
WindowSHell (User Interface)
Voice: ++49-9287/87446
FAX: ++49-9287/87232
.fi
.IP "\fBBasis International\fR"
.nf
BBxPROGRESSION/4 (BASIC compiler)
1-505-345-5232 (voice)
1-505-345-5082 (FAX)
.fi
.IP "\fBBasmark Corp.\fR"
.nf
QuickBASIC Compiler  (BASIC compiler, compatible with Microsoft BASIC)
1-216-621-7650 (voice)
1-216-621-7652 (FAX)
.fi
.IP "\fBBerkeley Decision/Systems\fR"
.nf
Shellware GLS (Accounting and bookkeeping)
1-408-458-9708 (voice)
1-408-458-2721 (FAX)
.fi
.IP "\fBBorland International\fR"
.nf
dBASE IV
408-438-8400 (voice)
.fi
.IP "\fBCamber Roth Caucus\fR"
.nf
Caucus Link (Groupware computer conferencing)
1-518-273-0983 (voice)
1-518-276-6380 (FAX)
.fi
.IP "\fBCentury Software\fR"
.nf
TERM (Communications and terminal-emulation package)
1-801-268-3088 (voice)
1-801-268-2772 (FAX)
.fi
.IP "\fBCET Software\fR"
.nf
CET BASIC (BASIC compiler)
1-206-883-8142 (voice)
1-206-885-5717 (FAX)
.fi
.IP "\fBCoconut Computing, Inc.\fR"
.nf
COCONET Server v4.0 (Conferencing and bulletin board package)
Cocotalk\(rg API C Library v2.0
CocoMedia\(tm v1.0 multimedia enhancements
1-619-456-2002 (voice)
1-619-456-1905 (FAX)
.fi
.IP "\fBComeau Computing\fR"
.nf
Comeau C++ 3.0 with Templates (C++ compiler)
1-718-945-0009 (voice)
1-718-441-2310 (FAX)
.fi
.IP "\fBCreative Programming\fR"
.nf
Vitamin C (User-interface builder)
1-214-245-9139 (voice)
1-214-245-9717 (FAX)
.fi
.IP "\fBCyberstore Online Information Systems, Inc.\fR"
.nf
Cyberstore (BBS package)
1-604-526-3373 (voice)
1-604-526-3373 (FAX)
.fi
.IP "\fBData Access\fR"
.nf
Dataflex (relational DBMS)
305-238-0012 (voice)
800-451-3539 (voice)
305-238-0017 (FAX)
.fi
.IP "\fBELMAS GmbH I. G.\fR"
.nf
LanguagePak 1 (Selected languages)
LanguagePak 2 (More language)
DeskPak (Edit and text formatting plus office automation)
OfficePak (Office automation)
TextPak (Editing and text formatting)
UtilityPak (\*(UN utilities)
CommPak (Communications utilities)
XPak (X utilities)
XtraPak (Additional X utilities)
FunPak (Games)
SourcePak (Source code)
49-303-936-784 (voice)
49-303-922-355 (FAX)
.fi
.IP "\fBFaircom Corporation\fR"
.nf
r-tree (RDBMS package)
c-tree (C interface to the r-tree DBMS)
1-314-445-6833 (voice)
1-314-445-9698 (FAX)
39-357-730-23 (European support)
.fi
.IP "\fBGimpel Software\fR"
.nf
FlexeLint 4.0 (Debugger and programming tool)
1-215-584-4261 (voice)
1-215-584-4261 (FAX)
.fi
.IP "\fBInformation Ink, Ltd.\fR"
.nf
Adaptive Software for the Disabled
1-718-278-8181 (voice)
1-718-278-8268 (FAX, Monday-Thursday, 10 PM-6 AM)
.fi
.IP "\fBInfoflex, Inc.\fR"
.nf
Infoflex and Accountflex (4GL and DBMS)
1-415-340-0220 (voice)
1-415-697-7696 (FAX)
.fi
.IP "\fBIntegration Technologies, Inc.\fR"
.nf
INTEK C++ (C/C++ compiler and programming package)
1-206-455-9935 (voice)
1-206-455-9935 (FAX)
.fi
.IP "\fBJust Logic Technologies\fR"
.nf
Just Logic/SQL (SQL DBMS)
1-514-642-6480 (voice)
1-514-642-6480 (FAX)
.fi
.IP "\fBLasermoon Ltd.\fR"
.nf
SWiM 1.2.3, a port of OSF Motif to \*(CO
(+44) 329 826444 (voice)
info@lasermoon.co.uk
.fi
.\".IP "\fBLiant Software\fR"
.\".nf
.\"RM/COBOL-85 RM/CO* RM/PANELS RM Companion (COBOL compiler)
.\"1-800-762-6265 (voice)
.\"1-512-343-1010 (voice)
.\"1-512-343-9487 (FAX)
.\".fi
.IP "\fBLotus Development Corporation\fR""
Lotus 1-2-3 for UNIX (Spreadsheet)
.fi
.IP "\fBmbp Software, Inc.\fR"
.nf
Visual Cobol (COBOL compiler)
1-800-231-6342 (voice, USA)
49-231-9441605 (voice, Germany)
1-510-769-4746 (voice, international)
1-510-769-5333 (FAX, USA)
1-510-769-5735 (FAX, USA)
49-231-9442413 (FAX, Germany)
.fi
.IP "\fBMMB Development Corporation\fR"
.nf
TEAMate (client-server BBS software)
310-318-1322 (voice)
310-318-2162 (FAX)
.fi
.IP "\fBMicro Focus\fR"
.nf
Micro Focus Cobol (COBOL compiler)
1-415-496-7215 (voice)
1-415-856-6134 (FAX)
.fi
.IP "\fBMicroEdge Inc.\fR"
.nf
SlickEdit (Configurable editor)
1-800-934-3348 (voice)
1-919-790-1691 (FAX)
1-919-872-5586 (FAX)
.fi
.IP "\fBMicroway\fR"
.nf
Microway Pascal Compiler for \*(CO
1-508-746-7341
.fi
.IP "\fBMultisoft Datentechnik GMBH\fR"
.nf
Flagship (Clipper-like data-base management system)
+49-89-641-7904 (voice)
+49-89-641-2974 (FAX)
303-699-5736 (U.S. agent)
.fi
.IP "\fBOn Top Systems\fR"
.nf
di-ogix  (DBMS and spreadsheet)
1-708-271-0200 (voice)
1-708-271-0206 (FAX)
.fi
.IP "\fBOpen Systems, Inc.\fR"
.nf
Open Systems Accounting Software
1-612-829-0011 (voice)
1-612-829-1493 (FAX)
.fi
.IP "\fBPacific Micro\fR"
.nf
Common-Link (COHERENT/UNIX-DOS-MAC file-transfer utility)
1-415-948-6200 (voice)
1-415-948-6296 (FAX)
.fi
.IP "\fBPacific Software Group\fR"
.nf
Task Manager for UNIX (desktop organizer, productivity software)
909-681-2623 (voice)
.fi
.IP "\fBPRO-C Limited\fR"
.nf
PRO-C Lite (RDBMS C development library)
1-519-725-5143 (voice)
1-519-725-5143 (FAX)
.fi
.IP "\fBPromula\fR"
.nf
Promula Fortran Compiler and FORTRAN to C Translator
1-614-263-5454 (voice)
1-614-263-5573 (FAX)
.fi
.IP "\fBRaima Corp.\fR"
.nf
Raima Data Manager (RDM) (RDBMS and development tool)
206-747-5570 (voice)
206-747-1991 (FAX)
.fi
.IP "\fBRasmussen Software, Inc.\fR"
.nf
ICE (Intelligent COBOL editor)
503-624-0360 (voice)
503-624-0760 (FAX)
.fi
.IP "\fBRevolutionary Software\fR"
.nf
/rdb (RDBMS package)
408-429-6229 (voice)
408-427-0342 (FAX)
.fi
.IP "\fBRoundhill Computer Systems\fR"
.nf
PANEL Plus II (User-interface library)
44-672-84535 (voice)
1-708-690-3737 (voice, USA)
44-672-84525 (FAX)
1-708-665-9841 (FAX, USA)
.fi
.IP "\fBRSYS\fR"
.nf
R Word, RO Plus, RW Plus (Word processors)
1-214-343-9210 (voice)
1-214-343-9218 (FAX)
.fi
.IP "\fBSan Souci Consulting\fR"
.nf
COM/MENT (Fully configurable BBS package)
1-805-327-1172 (voice)
1-805-327-9299 (FAX)
.fi
.IP "\fBSCS Compute Inc.\fR"
.nf
Tax Machine (Tax preparation and accounting package)
1-206-643-2050 (voice)
1-206-562-1783 (FAX)
.fi
.IP "\fBSequiter Software\fR"
.nf
CodeBase 5.0 (C-Language DBMS package)
1-403-437-2410 (voice)
1-403-436-2999 (FAX)
.fi
.IP "\fBSINC Inc.\fR"
.nf
Flex Gen Cobol 4GL (4GL, data base, and code generator)
1-513-438-5553 (voice)
1-513-438-5377 (FAX)
.fi
.IP "\fBSoftfocus\fR"
.nf
BTree/ISAM (File-Access and DBMS package)
1-416-825-0903 (voice)
1-416-825-1025 (FAX)
.fi
.IP "\fBSovereign Technologies\fR"
.nf
Cu/Extended V2.1 (Communications package)
1-800-428-1272 (voice)
.fi
.IP "\fBSynergetic Data Systems\fR"
.nf
Filix (Flat-file DBMS)
Filix General (Report Writer)
1-800-446-7374 (voice)
1-916-933-0120 (voice)
1-916-933-5793 (FZX)
.fi
.IP "\fBSyntactics\fR"
.nf
Crystal Writer Plus (Word processor)
1-408-727-6400 (voice)
1-408-727-0309 (FAX)
.fi
.IP "\fBThe Case Group\fR"
.nf
PC Curses Formation Desktop (User-interface tool)
1-615-352-2146 (voice)
.fi
.IP "\fBThe Small Computer Company\fR"
.nf
filePro (RDBMS)
1-914-769-3160 (voice)
1-914-769-3653 (FAX)
.fi
.IP "\fBThinking Software\fR"
.nf
ROTA (Office automation and scheduling package)
44-993-824-144 (voice)
44-993-823-629 (FAX)
.fi
.IP "\fBThoroughbred\fR"
.nf
Basic Word Query-IV Idol-IV Report-IV Solution-IV
1-908-560-1377 (voice)
1-908-560-1377 (FAX)
.fi
.IP "\fBTrueBASIC Inc.\fR"
.nf
TrueBASIC for \*(CO (BASIC compiler)
1-603-298-8517 (voice)
1-603-298-8517 (FAX)
.fi
.IP "\fBUniCache Systems\fR"
.nf
RealWorld Accounting & Public Safety Software
1-815-968-8026 (voice)
.fi
.IP "\fBUniTrends Software Corp.\fR"
.nf
CTAR (Backup and archiving utility)
1-803-626-2878 (voice)
1-803-626-5202 (FAX)
.fi
.IP "\fBUS Robotics\fR"
.nf
BLAST 10.7.2 (Communications package and terminal emulation)
1-708-933-5561 (voice)
1-708-982-5235 (FAX)
.fi
.IP "\fBVermont Creative Software\fR"
.nf
Vermont Views 3.05 (User-interface library)
1-802-848-7731 (voice)
1-802-848-3502 (FAX)
.fi
.IP "\fBVersasoft Corp.\fR"
.nf
dBMAN V (DBMS, clone of dBASE III Plus)
1-408-723-9044 (voice)
1-408-723-9046 (FAX)
.fi
.IP "\fBWild Hare Computer Systems Inc.\fR"
.nf
Axis Choice HareStylist VS COBOL/INFOS (COBOL compiler)
1-303-530-2221 (voice)
1-303-530-9637 (FAX)
.IP "\fBWordPerfect Corporation\fR"
.nf
WordPerfect for UNIX 5.1 (Word processor)
.fi
.IP "\fBZ/MAX Computer Solutions\fR"
.nf
Z/MAX XChange (BBS package)
1-315-635-1882 (voice)
1-315-635-1908 (FAX)
sales@zmax.xom
.fi
.SH "Freeware and Shareware via Phone"
.PP
Freeware and share is available from the Internet and from the Mark Williams
bulletin board (MWC BBS).
The following introduce these sources, and how you can get access to them.
.Sh "Software from the Internet"
.PP
System
.B silver.cstpl.com.au
maintains an archive of public-domain and shareware software that has been
ported to \*(CO.
You can access this site via the Internet and download
software for the price of the connection.
.PP
To access
.BR silver ,
you must have access to a system that connects to the Internet via TCP/IP.
When you log into this system, type:
.DM
	ftp silver.cstpl.com.au
.DE
.PP
All files are under the directory
.BR /coherent .
.Sh "The Mark Williams Bulletin Board"
.PP
Mark Williams Company has set up a \*(CO \*(UU node for dial-up
use by our customers.
.PP
Before you try to access the MWC BBS, note that you
.I must
use \*(UU.
You cannot use
.BR ckermit ,
.BR Procomm ,
or any other communications utility.
.PP
Before you proceed, please review the tutorial on \*(UU in the \*(CO manual.
It includes a tutorial on this powerful utility and uses
.B mwcbbs
throughout it.
In most cases, the tutorial gives you all the information you need.
.PP
You can access
.B mwcbbs
through the following three telephone numbers:
.DS
.ta 0.5i 3.5i
	1200/2400-baud generic modem:	559-0412
	9600-baud Trailblazer modem:	559-0445
	9600-baud V.32 or HST modem:	559-0452
.DE
.PP
Once you have succeeded in contacting
.BR mwcbbs ,
you can begin to exchange files.
.PP
For your initial contact with \fBmwcbbs\fR, we recommend that you download
the introductory message \fBhowto.start\fR from directory
.BR /usr/spool/uucppublic/mwcnews .
For example, the command:
.DM
	uucp  -r mwcbbs!/usr/spool/uucppublic/mwcnews/howto.start  /tmp
.DE
queues up a request to copy file \fBhowto.start\fR into directory
.B /tmp
on your system.
This file contains information on available downloads, new \*(CO
developments, and how to obtain an individual account on the system.
If the time at which you type the \fBuucp\fR command is within the range
of times allowed in the entry for
.B mwcbbs
in
.BR /usr/lib/uucp/sys ,
your modem will call
.B mwcbbs
immediately \(em you can check this with the commands
.B ps
or
.BR uulog .
If you wish to force polling of mwcbbs at a time not specified in
.BR /usr/lib/uucp/sys ,
you can do so with the command:
.DM
	su uucp /usr/lib/uucp/uucico -Smwcbbs  &
.DE
You can then monitor the progress of the transfer via the command:
.DM
	uulog -f mwcbbs
.DE
To stop monitoring the call, type
.BR <ctrl-C> .
.\".Sh "Electronic Mail Access"
.\".PP
.\"The following electronic mail addresses are available to customers.
.\".PP
.\"For issues relating to administration of the BBS node, send mail to
.\".BR mwcbbs!admin .
.\".PP
.\"For matters relating to support of \*(CO and related
.\"products, send mail to
.\".BR mwcbbs!support .
.\".PP
.\"Additional mail aliases may appear from time to time.
.\"Please remember that mail sent to either of the aforementioned addresses
.\"will be sent to \fBmwcbbs\fR only when you invoke
.\".BR uucico .
.\"You can do this interactively from the \*(CO shell,
.\"as shown in the example above, or at regular intervals as a \fBcron\fR task.
.\"The following gives a sample line for your
.\".B cron
.\"file:
.\".DM
.\"	15 20 * * * su uucp /usr/lib/uucp/uucico -smwcbbs
.\".DE
.\"This line will check every day at 8:15 PM for
.\".B uucp
.\"and
.\".B mail
.\"requests which have been queued for
.\".BR mwcbbs ,
.\"and, if any are found, will call \fBmwcbbs\fR.
.\"See the Lexicon article
.\".B cron
.\"for further information.
.\".PP
.\"Please note that while the BBS supports inbound electronic mail from
.\"your system to
.\".B mwcbbs
.\"via anonymous \*(UU,
.\"we cannot reply to your electronic mail messages unless
.\"you have an account on
.\".BR mwcbbs .
.\"To request an account on
.\".BR mwcbbs ,
.\"download the file
.\".B howto.start
.\"from directory
.\".B /usr/spool/uucppublic/mwcnews
.\"on
.\".BR mwcbbs ,
.\"and follow its directions.
.\".SH "On-Line Services"
.\".PP
.\"You can talk with fellow \*(CO users and Mark Williams developers
.\"both through the Internet and CompuServe.
.\".Sh "Internet News Group"
.\".PP
.\"The Internet news group
.\".B comp.os.coherent
.\"presents an on-going discussion of issues that relate
.\"to the \*(CO operating system.
.\"These include technical issues, requests for information, discussions
.\"of new \*(CO-related products, and other useful \(em and occasionally
.\"entertaining \(em exchanges from \*(CO users around the world.
.\".PP
.\"To participate, you must have a news feed from the Internet.
.\"As the administrator of the site from which you receive your feed to
.\"sign you up for
.\".BR comp.os.coherent .
.\"To post a message, either use your news software or
.\"send mail to \fBcoherent@vma.cc.nd.edu\fR.

