/*
 * Configuration file for the PD ksh
 *
 * RCSid: $Id: config.h,v 1.5 1992/08/12 14:15:22 sjg Exp $
 */

#ifndef	_CONFIG_H
#define	_CONFIG_H

/*
 * Builtin edit modes
 */

#define	EMACS				/* EMACS-like mode */
#define	VI				/* vi-like mode */
#define	JOBS				/* job control */

#ifndef SIGINT
#include <signal.h>
#endif

/*
 * leave USE_SIGACT defined.
 * if you don't have sigaction(2) and the
 * implementation in sigact.c doesn't work for your system,
 * fix it.
 * 
 * Of course if your system has a real sigaction() 
 * implementation that is faulty! undef JOBS and add USE_SIGNAL
 * or whatever does work.  You may find it necessary to undef
 * USE_SIGACT, if so please report it.
 */
#define USE_SIGACT			/* POSIX signal handling */
/* 
 * These control how sigact.c implements sigaction()
 * If you don't define any of them it will try and work it out 
 * for itself.  The are listed in order of preference (usefulness).
 */
#if 0
#define USE_SIGMASK			/* BSD4.2 ? signal handling */
#define USE_SIGSET			/* BSD4.1 ? signal handling */
#define USE_SIGNAL			/* plain old signal(2) */
#endif

#if defined(JOBS) && (!defined(SIGCONT) || (defined(_SYSV) && defined(USE_SIGNAL)))
#undef JOBS
#endif

#if 0
#define	FASCIST			/* Fascist getopts */
#endif
#define	SHARPBANG			/* Hack to handle #! */
#if 0
#define	SILLY			/* Game of life in EMACS mode */
#define	SWTCH			/* Handle SWTCH for shl(1) */
#endif

/*
 * better to leave this one out, and let users that
 * like it add
 *   bind '^[^['=complete-list
 * to their .kshrc
 */
#if 0
#define COMPLETE_LIST			/* default to Emacs style completion */
#endif
/*
 * ALTERNATIONS is csh not ksh, but it is such a nice feature...
 */
#define ALTERNATIONS			/* csh {a,b,c} arg expansion */

#if 0
#define COMPLEX_HISTORY			/* Peter Collinson's history */
#endif
/*
 * if you don't have mmap() you can't use Peter Collinson's history
 * mechanism.  If that is the case, then define EASY_HISTORY
 */
#if !defined(COMPLEX_HISTORY) || defined(NO_MMAP)
# undef COMPLEX_HISTORY
# ifndef EASY_HISTORY
#  define EASY_HISTORY			/* sjg's trivial history file */
# endif
#endif
  
#endif	/* _CONFIG_H */
