/* (-lgl
 * 	COHERENT Version 4.0.2
 * 	Copyright (c) 1982, 1992 by Mark Williams Company.
 * 	All rights reserved. May not be copied without permission.
 -lgl) */
/*
 * stdio.h
 * COHERENT Standard Input/Output library header.
 * ANSI C Standard, Section 4.9.
 */

#ifndef	_STDIO_H
#define	_STDIO_H

#ifndef	NULL
#define	NULL	((char *)0)
#endif

/* Macros. */
#define	BUFSIZ		512		/* default buffer size	*/
#define	EOF		(-1)		/* end of file		*/
#define	_EOFCHAR	26		/* ASCII EOF character	*/
#define	FILENAME_MAX	64		/* max filename length	*/
#define	FOPEN_MAX	_NFILE		/* max # of open files	*/
#define	_NFILE		60		/* number of FILEs	*/
#define	_NSTDFILE	3		/* number of predefined FILEs	*/
#define	L_tmpnam	64		/* tmpnam length	*/
#define	SEEK_CUR	1		/* from current position */
#define	SEEK_END	2		/* from end		*/
#define	SEEK_SET	0		/* from beginning	*/
#define	TMP_MAX		91		/* number of tmpnams	*/

/* Types. */
typedef long		fpos_t;		/* file position type	*/
#ifndef	_SIZE_T
#define	_SIZE_T
typedef	unsigned int	size_t;		/* sizeof result type	*/
#endif
/*
 * The order the first 5 FILE members corresponds to the order in iBCS2,
 * to allow a degree of binary compatability.
 */
typedef struct	FILE {
	int		_cc;		/* character count	*/
	unsigned char	*_cp;		/* current character	*/
	struct _FILE2	*_f2p;		/* more info		*/
	char		_ff1;		/* flags		*/
	char		_fd;		/* file descriptor	*/
	char		_ff2;		/* more flags; see below */
	char		_mode;		/* mode			*/
}	FILE;
/* These additional members are not in struct FILE for compatability reasons. */
typedef	struct	_FILE2 {
	int		(*_gt)();	/* getc function	*/
	int		(*_pt)();	/* putc function	*/
	unsigned char	*_bp;		/* start of buffer	*/
	unsigned char	*_dp;		/* start of data	*/
	unsigned char	*_ep;		/* end of buffer	*/
	char		*_nm;		/* temp file name	*/
	int		_uc;		/* ungot char		*/
}	_FILE2;

/* iBCS2 compatability. */
#define	_cnt	_cc
#define	_ptr	_cp
#define	_base	_f2p
#define	_flag	_ff1
#define	_file	_fd

/* Standard FILEs. */
extern	FILE	_iob[_NSTDFILE];
extern	FILE	*_fp[_NFILE];
#define	stdin	(&_iob[0])
#define	stdout	(&_iob[1])
#define	stderr	(&_iob[2])

/* _IO[FLN]BF are used for setvbuf() type args. */
#define	_IOFBF		0x00		/* fully buffered	*/
#define	_IONBF		0x04		/* unbuffered		*/
#define	_IOLBF		0x40		/* line buffered	*/
/* Flags in _ff1, cf. iBCS2. */
#define	_FEOF		0x10		/* end of file		*/
#define	_FERR		0x20		/* error		*/
/* Non-iBCS2 flags in _ff1. */
#define	_FRONLY		0x01		/* read only		*/
#define	_FWONLY		0x02		/* write only		*/
#define	_FRW		0x80		/* read and write	*/

/* Flags in _ff2, not in iBCS2. */
#define	_FINUSE		0x01		/* in use		*/
#define	_FAPPND		0x02		/* append		*/
#define _FASCII		0x04		/* ASCII		*/
#define	_FDONTC		0x08		/* do not close		*/
#define	_FFREEB		0x10		/* free buffer when closed	*/
#define	_FUNGOT		0x80		/* ungotten char present	*/

/* Mode field values. */
#define	_MODE_FBUF	0x01		/* fully buffered	*/
#define	_MODE_LBUF	0x02		/* line buffered	*/
#define	_MODE_NBUF	0x04		/* unbuffered		*/
#define	_MODE_STR	0x08		/* string		*/
#define	_MODE_UNINIT	0x10		/* uninitialized	*/

/* External declarations for non-conforming implementations. */
/* Standard functions. */
extern	void	clearerr();		/* 4.9.10.1 */
extern	int	fclose	();		/* 4.9.5.1  */
extern	int	feof	();		/* 4.9.10.2 */
extern	int	ferror	();		/* 4.9.10.3 */
extern	int	fflush	();		/* 4.9.5.2  */
extern	int	fgetc	();		/* 4.9.7.1  */
extern	int	fgetpos	();		/* 4.9.9.1  */
extern	char *	fgets	();		/* 4.9.7.2  */
extern	FILE *	fopen	();		/* 4.9.5.3  */
extern	int	fprintf	();		/* 4.9.6.1  */
extern	int	fputc	();		/* 4.9.7.3  */
extern	int	fputs	();		/* 4.9.7.4  */
extern	size_t	fread	();		/* 4.9.8.1  */
extern	FILE *	freopen	();		/* 4.9.5.4  */
extern	int	fscanf	();		/* 4.9.6.2  */
extern	int	fseek	();		/* 4.9.9.2  */
extern	int	fsetpos	();		/* 4.9.9.3  */
extern long int	ftell	();		/* 4.9.9.4  */
extern	size_t	fwrite	();		/* 4.9.8.2  */
extern	int	getc	();		/* 4.9.7.5  */
extern	int	getchar	();		/* 4.9.7.6  */
extern	char *	gets	();		/* 4.9.7.7  */
extern	void	perror	();		/* 4.9.10.4 */
extern	int	printf	();		/* 4.9.6.3  */
extern	int	putc	();		/* 4.9.7.8  */
extern	int	putchar	();		/* 4.9.7.9  */
extern	int	puts	();		/* 4.9.7.10 */
extern	int	remove	();		/* 4.9.4.1  */
extern	int	rename	();		/* 4.9.4.2  */
extern	void	rewind	();		/* 4.9.9.5  */
extern	int	scanf	();		/* 4.9.6.4  */
extern	void	setbuf	();		/* 4.9.5.5  */
extern	int	setvbuf	();		/* 4.9.5.6  */
extern	int	sprintf	();		/* 4.9.6.5  */
extern	int	sscanf	();		/* 4.9.6.6  */
extern	FILE *	tmpfile	();		/* 4.9.4.3  */
extern	char *	tmpnam	();		/* 4.9.4.4  */
extern	int	ungetc	();		/* 4.9.7.11 */
extern	int	vfprintf();		/* 4.9.6.7  */
extern	int	vprintf	();		/* 4.9.6.8  */
extern	int	vsprintf();		/* 4.9.6.9  */

/* Internal functions. */
extern	void	_dassign();
extern	int	_dscan	();
extern	char *	_dtefg	();
extern	void	_dtoa	();
extern	int	_fgetb	();
extern	int	_fgetc	();
extern	int	_fgete	();
extern	int	_fgetstr();
extern	int	_fginit	();
extern	int	_filbuf	();
extern	void	_finish	();
extern	int	_flsbuf	();
extern	FILE *	_fopen	();
extern	int	_fpinit	();
extern	int	_fpseek	();
extern	int	_fputa	();
extern	int	_fputb	();
extern	int	_fputc	();
extern	int	_fpute	();
extern	int	_fputt	();
extern	int	_scanf	();
extern	FILE *	_stropen();

/* Macros covering standard functions. */
#define	clearerr(fp)	((fp)->_ff1 &= ~(_FERR|_FEOF))
#define	feof(fp)	((fp)->_ff1 & _FEOF)
#define	ferror(fp)	((fp)->_ff1 & _FERR)
#define	getc(fp)	(--(fp)->_cc<0 ? ++(fp)->_cc,(*(fp)->_f2p->_gt)((fp)) \
				       : *(fp)->_cp++)
#define	getchar()	getc(stdin)
#define	putc(c,fp)	(--(fp)->_cc<0 ? ++(fp)->_cc,(*(fp)->_f2p->_pt)((c),(fp)) \
				       : (*(fp)->_cp++=(c)))
#define	putchar(c)	putc((c), stdout)

/* Other macros, non-ANSI. */
#define	fileno(fp)	((fp)->_fd)
#endif

/* end of stdio.h */
