/*
 * A debugger.
 * Tables for the Intel 8086.
 */
#include <stdio.h>
#include <sys/const.h>
#include <l.out.h>
#include "trace.h"
#include "i8086.h"

/*
 * Instruction table.
 */
INS insrtab[] ={
	0x88,	0xFC,	"mov%0t\t%1d",
	0xC6,	0xFE,	"mov%0t\t%nf0m,$%ik",
	0xB0,	0xF0,	"mov%3t\t%0r,$%ik",
	0xA0,	0xFE,	"mov%0t\t%x,%:wp",
	0xA2,	0xFE,	"mov%0t\t%:wp,%x",
	0x8E,	0xFF,	"mov\t%n5z3s,%m",
	0x8C,	0xFF,	"mov\t%n5zm,%3s",
	0xFF,	0xFF,	"push\t%nf6m",
	0x50,	0xF8,	"push\t%0r",
	0x06,	0xE7,	"push\t%3s",
	0x8F,	0xFF,	"pop\t%nf0m",
	0x58,	0xF8,	"pop\t%0r",
	0x07,	0xE7,	"pop\t%3s",
	0x86,	0xFE,	"xchg%0t\t%n3r,%m",
	0x90,	0xF8,	"xchg\t%x,%0r",
	0xE4,	0xFE,	"in%0t\t%x,%bl",
	0xEC,	0xFE,	"in%0t\t%x,dx",
	0xE6,	0xFE,	"out%0t\t%bl,%x",
	0xEE,	0xFE,	"out%0t\tdx,%x",
	0xD7,	0xFF,	"xlat",
	0x8D,	0xFF,	"lea\t%n3r,%m",
	0xC5,	0xFF,	"lds\t%n3r,%m",
	0xC4,	0xFF,	"les\t%n3r,%m",
	0x9F,	0xFF,	"lahf",
	0x9E,	0xFF,	"sahf",
	0x9C,	0xFF,	"pushf",
	0x9D,	0xFF,	"popf",
	0x00,	0xFC,	"add%0t\t%1d",
	0x80,	0xFC,	"add%0t\t%1enf0m,$%ik",
	0x04,	0xFE,	"add%0t\t%x,$%ik",
	0x10,	0xFC,	"adc%0t\t%1d",
	0x80,	0xFC,	"adc%0t\t%1enf2m,$%ik",
	0x14,	0xFE,	"adc%0t\t%x,$%ik",
	0xFE,	0xFE,	"inc%0t\t%nf0m",
	0x40,	0xF8,	"inc\t%0r",
	0x37,	0xFF,	"aaa",
	0x27,	0xFF,	"daa",
	0x28,	0xFC,	"sub%0t\t%1d",
	0x80,	0xFC,	"sub%0t\t%1enf5m,$%ik",
	0x2C,	0xFE,	"sub%0t\t%x,$%ik",
	0x18,	0xFC,	"sbb%0t\t%1d",
	0x80,	0xFC,	"sbb%0t\t%1enf3m,$%ik",
	0x1C,	0xFE,	"sbb%0t\t%x,$%ik",
	0xFE,	0xFE,	"dec%0t\t%nf1m",
	0x48,	0xF8,	"dec\t%0r",
	0xF6,	0xFE,	"neg%0t\t%nf3m",
	0x38,	0xFC,	"cmp%0t\t%1d",
	0x80,	0xFC,	"cmp%0t\t%1enf7m,$%ik",
	0x3C,	0xFE,	"cmp%0t\t%x,$%ik",
	0x3F,	0xFF,	"aas",
	0x2F,	0xFF,	"das",
	0xF6,	0xFE,	"mul%0t\t%x,%nf4m",
	0xF6,	0xFE,	"imul%0t\t%x,%nf5m",
	0xD4,	0xFF,	"aam%n%g",
	0xF6,	0xFE,	"div%0t\t%x,%nf6m",
	0xF6,	0xFE,	"idiv%0t\t%x,%nf7m",
	0xD5,	0xFF,	"aad%n%g",
	0x98,	0xFF,	"cbw",
	0x99,	0xFF,	"cwd",
	0xF6,	0xFE,	"not%0t\t%nf2m",
	0xD0,	0xFC,	"shl%0t\t%nf4m,%1v",
	0xD0,	0xFC,	"shr%0t\t%nf5m,%1v",
	0xD0,	0xFC,	"sar%0t\t%nf7m,%1v",
	0xD0,	0xFC,	"rol%0t\t%nf0m,%1v",
	0xD0,	0xFC,	"ror%0t\t%nf1m,%1v",
	0xD0,	0xFC,	"rcl%0t\t%nf2m,%1v",
	0xD0,	0xFC,	"rcr%0t\t%nf3m,%1v",
	0x20,	0xFC,	"and%0t\t%1d",
	0x80,	0xFE,	"and%0t\t%nf4m,$%ik",
	0x24,	0xFE,	"and%0t\t%x,$%ik",
	0x10,	0xFC,	"test%0t\t%1d",
	0xF6,	0xFE,	"test%0t\t%nf0m,$%ik",
	0xA8,	0xFE,	"test%0t\t%x,$%ik",
	0x08,	0xFC,	"or%0t\t%1d",
	0x80,	0xFE,	"or%0t\t%nf1m,$%ik",
	0x0C,	0xFE,	"or%0t\t%x,$%ik",
	0x30,	0xFC,	"xor%0t\t%1d",
	0x34,	0xFE,	"xor%0t\t%nf6m,$%ik",
	0x34,	0xFE,	"xor%0t\t%x,$%ik",
	0xF2,	0xFF,	"rep",
	0xF3,	0xFF,	"repnz",
	0xA4,	0xFE,	"movs%0t",
	0xA6,	0xFE,	"cmps%0t",
	0xAE,	0xFE,	"scas%0t",
	0xAC,	0xFE,	"lods%0t",
	0xAA,	0xFE,	"stos%0t",
	0xE8,	0xFF,	"call\t%woq",
	0xFF,	0xFF,	"icall\t%nf2m",
	0x9A,	0xFF,	"xcall\t%wP",
	0xFF,	0xFF,	"xcall\t%nf3m",
	0xE9,	0xFF,	"jmp\t%wol",
	0xEB,	0xFF,	"jmp\t%bol",
	0xFF,	0xFF,	"ijmp\t%nf4m",
	0xEA,	0xFF,	"xjmp\t%wP",
	0xFF,	0xFF,	"xjmp\t%nf5m",
	0xC3,	0xFF,	"ret",
	0xC2,	0xFF,	"ret\t%wk",
	0xCB,	0xFF,	"xret",
	0xCA,	0xFF,	"xret\t%wk",
	0x70,	0xF0,	"%j\t%bol",
	0xE2,	0xFF,	"loop\t%bol",
	0xE1,	0xFF,	"loope\t%bol",
	0xE0,	0xFF,	"loopne\t%bol",
	0xE3,	0xFF,	"jcxz\t%bol",
	0xCD,	0xFF,	"%uy",
	0xCC,	0xFF,	"int\t3",
	0xCE,	0xFF,	"into",
	0xCF,	0xFF,	"iret",
	0xF8,	0xFF,	"clc",
	0xF5,	0xFF,	"cmc",
	0xF9,	0xFF,	"stc",
	0xFC,	0xFF,	"cld",
	0xFD,	0xFF,	"std",
	0xFA,	0xFF,	"cli",
	0xFB,	0xFF,	"sti",
	0xF4,	0xFF,	"hlt",
	0x9B,	0xFF,	"wait",
	0xD8,	0xF8,	"%F",
	0xF0,	0xFF,	"lock",
	0x00,	0x00,	NULL
};

/*
 * 8087 Instruction table.
 * The bits considered are the last 3 bits of the ESC
 * instruction and the next instruction byte.
 */
INS	fpinstab[] = {
	0x000, 0x138,	"fadd?",
	0x0C0, 0x1F8,	"fadd\tST(i)?",
	0x020, 0x130,	"fsubb?",
	0x0E0, 0x1F0,	"fsub\tST(i)?",
	0x008, 0x138,	"fmul?",
	0x0C8, 0x1F8,	"fmul\tST(i)?",
	0x030, 0x130,	"fdiv?",
	0x0F0, 0x1F0,	"fdiv\tST(i)?",
	0x1FA, 0x7FF,	"fsqrt",
	0x1FD, 0x7FF,	"fscale",
	0x1F8, 0x7FF,	"fprem",
	0x1FC, 0x7FF,	"frndint",
	0x1F4, 0x7FF,	"fxtract",
	0x1E1, 0x7FF,	"fabs",
	0x1E0, 0x7FF,	"fchs",
	0x1F2, 0x7FF,	"fptan",
	0x1F3, 0x7FF,	"fpatan",
	0x1F0, 0x7FF,	"f2xm1",
	0x1F1, 0x7FF,	"fyl2x",
	0x1F9, 0x7FF,	"fyl2p1",
	0x1EE, 0x7FF,	"fldz",
	0x1E8, 0x7FF,	"fld1",
	0x1EB, 0x7FF,	"fldpi",
	0x1E9, 0x7FF,	"fldl2t",
	0x1EA, 0x7FF,	"fldl2e",
	0x1EC, 0x7FF,	"fldlg2",
	0x1ED, 0x7FF,	"fldln2",
	0x3E3, 0x7FF,	"finit",
	0x3E0, 0x77FF,	"feni",
	0x3E1, 0x7FF,	"fdisi",
	0x128, 0x738,	"fldcw?",
	0x138, 0x738,	"fstcw?",
	0x538, 0x738,	"fstsw?",
	0x3E2, 0x7FF,	"fclex",
	0x130, 0x738,	"fstenv?",
	0x120, 0x738,	"fldenv?",
	0x530, 0x738,	"fsave?",
	0x520, 0x738,	"frstor?",
	0x1F7, 0x7FF,	"fincstp",
	0x1F6, 0x7FF,	"fdecstp",
	0x5C0, 0x7F8,	"ffree\tST(i)?",
	0x1D0, 0x7FF,	"fnop",
};
