.TH ELVIS v1.4
.SH NAME
elvis, ex, vi, view, input - The editor
.SH SYNOPSIS
\fBelvis\fP [\fIflags\fP] [\fB+\fP\fIcmd\fP] [\fIfiles\fP...]
.SH DESCRIPTION
\fIElvis\fP is a text editor which emulates \fIvi\fP/\fIex\fP.
.PP
On systems which pass the program name as an argument, such as Unix and Minix,
you may also install \fIelvis\fP under the names "ex", "vi", "view", and "input".
These extra names would normally be links to elvis;
see the "ln" shell command.
.PP
When \fIelvis\fP is invoked as "vi",
it behaves exactly as though it was invoked as "elvis".
However, if you invoke \fIelvis\fP as "view",
then the readonly option is set as though you had given it the "-R" flag.
If you invoke \fIelvis\fP as "ex",
then \fIelvis\fP will start up in the colon command mode
instead of the visual command mode,
as though you had given it the "-e" flag.
If you invoke \fIelvis\fP as "input" or "edit",
then \fIelvis\fP will start up in input mode,
as though the "-i" flag was given.
.SH OPTIONS
.IP \fB-r\fP
To the real vi, this flag means that a previous edit should be recovered.
\fIElvis\fP, though, has a separate program, called \fIvirec(1)\fP, for recovering
files.
When you invoke \fIelvis\fP with -r, \fIelvis\fP will tell you to run \fIvirec\fP.
.IP \fB-R\fP
This sets the "readonly" option,
so you won't accidentally overwrite a file.
.IP "\fB-t\fP \fItag\fP"
This causes \fIelvis\fP to start editing at the given tag.
.IP "\fB-m\fP [\fIfile\fP]"
\fIElvis\fP will search through \fIfile\fP for something that looks like
an error message from a compiler.
It will then begin editing the source file that caused the error,
with the cursor sitting on the line where the error was detected.
If you don't explicitly name a \fIfile\fP, then "errlist" is assumed.
.IP \fB-e\fP
\fIElvis\fP will start up in colon command mode.
.IP \fB-v\fP
\fIElvis\fP will start up in visual command mode.
.IP \fB-i\fP
\fIElvis\fP will start up in input mode.
.IP \fB+\fP\fIcommand\fP
If you use the +\fIcommand\fP parameter,
then after the first file is loaded
\fIcommand\fP is executed as an EX command.
A typical example would be "elvis +237 foo",
which would cause \fIelvis\fP to start editing foo and
then move directly to line 237.
.SH FILES
.IP /tmp/elv*
During editing,
\fIelvis\fP stores text in a temporary file.
For UNIX, this file will usually be stored in the /tmp directory,
and the first three characters will be "elv".
For other systems, the temporary files may be stored someplace else;
see the version-specific section of the documentation.
.IP tags
This is the database used by the \fI:tags\fP command and the \fB-t\fP option.
It is usually created by the \fIctags(1)\fP program.
.SH "SEE ALSO"
ctags(1), ref(1), virec(1)
.PP
\fIElvis - A Clone of Vi/Ex\fP, the complete \fIelvis\fP documentation.
.SH BUGS
There is no LISP support.
Certain other features are missing, too.
.PP
Auto-indent mode is not quite compatible with the real vi.
Among other things, 0^D and ^^D don't do what you might expect.
.PP
Long lines are displayed differently.
The real vi wraps long lines onto multiple rows of the screen,
but \fIelvis\fP scrolls sideways.
.SH AUTHOR
.nf
Steve Kirkendall
kirkenda@cs.pdx.edu
\&...uunet!tektronix!psueea!eecs!kirkenda
.fi
.PP
Many other people have worked to port \fIelvis\fP to various operating systems.
To see who deserves credit, run the \fI:version\fP command from within \fIelvis\fP,
or look in the system-specific section of the complete documentation.
