     USTAR         COHERENT (USENIX Association)         USTAR
     NAME
          ustar - process tape archives
     SYNOPSIS
          ustar -c[bfvw] device block filename...
          ustar -r[bvw] device block [filename...]
          ustar -t[fv] device
          ustar -x[flmovw] device [filename...]
     DESCRIPTION
          Ustar reads and writes archive files which conform to the
          Archive/Interchange File Format specified in IEEE Std.
          1003.1-1988.
        Options
          The following options are available:
          -c        Creates a new archive; writing begins at the
                    beginning of the archive, instead of after the
                    last file.
          -r        Writes names files to the end of the archive.
          -t        Lists the names of all of the files in the
                    archive.
          -x        Extracts named files from the archive.  If a named
                    file matches a directory whose contents had been
                    written onto the archive, that directory is
                    recursively extracted.  If a named file in the
                    archive does not exist on the system, the file is
                    create with the same mode as the one in the
                    archive, except that the set-user-id and get-
                    group-id modes are not set unless the user has
                    appropriate privileges.
          If the files exist, their modes are not changed except as
          described above.  The owner, group and modification time are
          restored if possible.  If no filename argument is given, the
          entire contents of the archive is extracted.  Note that if
          several files with the same name are in the archive, the
          last one will overwrite all earlier ones.
          -b        Causes ustar to use the next argument on the command
                    line as the blocking factor for tape records.  The
                    default is 1; the maximum is 20.  This option
     Page 1                                          (printed 5/24/90)
     USTAR         COHERENT (USENIX Association)         USTAR
                    should only be used with raw magnetic tape
                    archives.  Normally, the block size is determined
                    automatically when reading tapes.
          -f        Causes ustar to use the next argument on the command
                    line as the name of the archive instead of the
                    default, which is usually a tape drive.  If - is
                    specified as a filename ustar writes to the standard
                    output or reads from the standard input, whichever
                    is appropriate for the options given.  Thus, ustar
                    can be used as the head or tail of a pipeline.
          -l        Tells ustar to report if it cannot resolve all of
                    the links to the files being archived.  If -l is
                    not specified, no error messages are written to
                    the standard output.  This modifier is only valid
                    with the -c, -r and -u options.
          -m        Tells ustar not to restore the modification times.
                    The modification time of the file will be the time
                    of extraction.  This modifier is invalid with th
                    -t option.
          -o        Causes extracted files to take on the user and
                    group identifier of the user running the program
                    rather than those on the archive.  This modifier
                    is only valid with the -x option.
          -v        Causes ustar to operate verbosely.  Usually, ustar
                    does its work silently, but the v modifier causes
                    it to print the name of each file it processes,
                    preceded by the option letter.  With the -t
                    option, v gives more information about the archive
                    entries than just the name.
          -w        Causes ustar to print the action to be taken,
                    followed by the name of the file, and then wait
                    for the user's confirmation.  If a word beginning
                    with y is given, the action is performed.  Any
                    other input means "no".  This modifier is invalid
                    with the -t option.

	  To create archive on high density floppy, enter (disk has been
	  formated before):
		ustar cvf /dev/fha0 files_names
	  To display a listing of the archive:
		ustar tvf /dev/fha0
	  For extract the files from this archive you can print:
		ustar xvf /dev/fha0
     SEE ALSO
          cpio, dd, find, pax

     NOTES
	  Name ustar was selected because new tar uses ustar format and
	  by distinguish between original COHERENT tar and new one.

	  Because COHERENT has memory restriction ustar cannot create
	  archive on big directories tree (about 2 Mb and more). 

	  ustar cannot append on magnetic tape.
  	
	  ustar doesn't support option -u .
	  
     COPYRIGHT
          Copyright (c) 1989 Mark H. Colburn.
	  COHERENT pax/ustar/cpio are based on original code for pax
	  which is sponsored by The USENIX Association.

     Page 3                                          (printed 5/24/90)
