/*
 * Split output lines with \ along whitespace boundarys.
 * Adds a \n at end of line if none exists.
 */
#include <misc.h>

void
splitter(ofp, line, limit)
FILE *ofp;
char *line;
{
	int	pos,	/* display location on line */
		i,	/* data location on line */
		j,	/* location of last white space on 0 */
		c, w;	/* current char and work */

	for (pos = j = i = 0; c = line[i]; i++) {
		if ((pos >= limit) && j) { /* split condition */
			w = line[j];
			line[j] = '\0';
			fprintf(ofp, "%s \\\n", line);
			line += j;
			line[pos = i = j = 0] = w;
		}
		switch (c) {
		case '\n':
			j = pos = 0;
			break;
		case '\t':
			pos |= 7;
		case ' ':
			j = i;
		default:
			pos++;
		}
	}
	fprintf(ofp, "%s", line);
	if(pos)
		fputc('\n', ofp);
}
#ifdef TEST
main()
{
	char buf[100];

	while (NULL != ask(buf, "string"))
		splitter(stdout, buf, 20);
}
#endif
