#include "defs"
/* DEFAULT RULES FOR UNIX */

/*
 *	These are the internal rules that "make" trucks around with it at
 *	all times. One could completely delete this entire list and just
 *	conventionally define a global "include" makefile which had these
 *	rules in it. That would make the rules dynamically changeable
 *	without recompiling make. This file may be modified to local
 *	needs. There are currently two versions of this file with the
 *	source; namely, rules.c (which is the version running in Columbus)
 *	and pwbrules.c which is my attempt at satisfying the requirements
 *	of PWB systems.
 *	The makefile for make (make.mk) is parameterized for a different
 *	rules file. The macro $(RULES) defined in "make.mk" can be set
 *	to another file and when "make" is "made" the procedure will
 *	use the new file. The recommended way to do this is on the
 *	command line as follows:
 *		"make -f make.mk RULES=pwbrules"
 */

CHARSTAR builtin[] =
	{
	".SUFFIXES: .o .c .c~ .p .p~ .f .f~ .F .F~ .e .e~ .r .r~ .y .y~ .yr .yr~ .ye .ye~ .l .l~ .s .s~ .sh .sh~ .h .h~",

/* PRESET VARIABLES */
	"MAKE=make",
	"YACC=yacc",
	"YACCR=yacc -r",
	"YACCE=yacc -e",
	"YFLAGS=",
	"LEX=lex",
	"LFLAGS=",
	"LD=ld",
	"LDFLAGS=",
	"CC=cc",
	"CFLAGS=-O",
	"PC=pc",
	"PFLAGS=",
	"FC=f77",
	"FFLAGS=-O",
	"EFLAGS=",
	"RFLAGS=",
	"AS=as",
	"ASFLAGS=",
	"CO=co",
	"COFLAGS=",
	"GET=get",
	"GFLAGS=",

/* SINGLE SUFFIX RULES */
	".c:",
		"\t$(CC) $(CFLAGS) $(LDFLAGS) $< -o $@",
	".c~:",
		"\t$(GET) $(GFLAGS) -p $< > $*.c",
		"\t$(CC) $(CFLAGS) $(LDFLAGS) $*.c -o $*",
		"\t-rm -f $*.c",
	".p:",
		"\t$(PC) $(PFLAGS) $(LDFLAGS) $< -o $@",
	".p~:",
		"\t$(GET) $(GFLAGS) -p $< > $*.p",
		"\t$(PC) $(PFLAGS) $(LDFLAGS) $*.p -o $*",
		"\t-rm -f $*.p",
	".f:",
		"\t$(FC) $(FFLAGS) $(LDFLAGS) $< -o $@",
	".f~:",
		"\t$(GET) $(GFLAGS) -p $< > $*.f",
		"\t$(FC) $(FFLAGS) $(LDFLAGS) $*.f -o $*",
		"\t-rm -f $*.f",
	".F:",
		"\t$(FC) $(FFLAGS) $(LDFLAGS) $< -o $@",
	".F~:",
		"\t$(GET) $(GFLAGS) -p $< > $*.F",
		"\t$(FC) $(FFLAGS) $(LDFLAGS) $*.F -o $*",
		"\t-rm -f $*.F",
	".e:",
		"\t$(FC) $(EFLAGS) $(FFLAGS) $(LDFLAGS) $< -o $@",
	".e~:",
		"\t$(GET) $(GFLAGS) -p $< > $*.e",
		"\t$(FC) $(EFLAGS) $(FFLAGS) $(LDFLAGS) $*.e -o $*",
		"\t-rm -f $*.e",
	".r:",
		"\t$(FC) $(RFLAGS) $(FFLAGS) $(LDFLAGS) $< -o $@",
	".r~:",
		"\t$(GET) $(GFLAGS) -p $< > $*.r",
		"\t$(FC) $(RFLAGS) $(FFLAGS) $(LDFLAGS) $*.r -o $*",
		"\t-rm -f $*.r",
	".sh:",
		"\tcp $< $@; chmod +x $@",
	".sh~:",
		"\t$(GET) $(GFLAGS) -p $< > $*.sh",
		"\tcp $*.sh $*; chmod +x $@",
		"\t-rm -f $*.sh",

/* DOUBLE SUFFIX RULES */
	".c.o:",
		"\t$(CC) $(CFLAGS) -c $<",
	".c~.o:",
		"\t$(GET) $(GFLAGS) -p $< > $*.c",
		"\t$(CC) $(CFLAGS) -c $*.c",
		"\t-rm -f $*.c",
	".c~.c:",
		"\t$(GET) $(GFLAGS) -p $< > $*.c",
	".p.o:",
		"\t$(PC) $(PFLAGS) -c $<",
	".p~.o:",
		"\t$(GET) $(GFLAGS) -p $< > $*.p",
		"\t$(PC) $(PFLAGS) -c $*.p",
		"\t-rm -f $*.p",
	".p~.p:",
		"\t$(GET) $(GFLAGS) -p $< > $*.p",
	".f.o:",
		"\t$(FC) $(FFLAGS) -c $<",
	".f~.o:",
		"\t$(GET) $(GFLAGS) -p $< > $*.f",
		"\t$(FC) $(FFLAGS) -c $*.f",
		"\t-rm -f $*.f",
	".f~.f:",
		"\t$(GET) $(GFLAGS) -p $< > $*.f",
	".F.o:",
		"\t$(FC) $(FFLAGS) -c $<",
	".F~.o:",
		"\t$(GET) $(GFLAGS) -p $< > $*.F",
		"\t$(FC) $(FFLAGS) -c $*.F",
		"\t-rm -f $*.F",
	".F~.F:",
		"\t$(GET) $(GFLAGS) -p $< > $*.F",
	".e.o:",
		"\t$(FC) $(EFLAGS) $(FFLAGS) -c $<",
	".e~.o:",
		"\t$(GET) $(GFLAGS) -p $< > $*.e",
		"\t$(FC) $(EFLAGS) $(FFLAGS) -c $*.e",
		"\t-rm -f $*.e",
	".e~.e:",
		"\t$(GET) $(GFLAGS) -p $< > $*.e",
	".r.o:",
		"\t$(FC) $(RFLAGS) $(FFLAGS) -c $<",
	".r~.o:",
		"\t$(GET) $(GFLAGS) -p $< > $*.r",
		"\t$(FC) $(RFLAGS) $(FFLAGS) -c $*.r",
		"\t-rm -f $*.r",
	".r~.r:",
		"\t$(GET) $(GFLAGS) -p $< > $*.r",
	".s.o:",
		"\t$(AS) $(ASFLAGS) -o $@ $<",
	".s~.o:",
		"\t$(GET) $(GFLAGS) -p $< > $*.s",
		"\t$(AS) $(ASFLAGS) -o $*.o $*.s",
		"\t-rm -f $*.s",
	".y.o:",
		"\t$(YACC) $(YFLAGS) $<",
		"\t$(CC) $(CFLAGS) -c y.tab.c",
		"\trm y.tab.c",
		"\tmv y.tab.o $@",
	".y~.o:",
		"\t$(GET) $(GFLAGS) -p $< > $*.y",
		"\t$(YACC) $(YFLAGS) $*.y",
		"\t$(CC) $(CFLAGS) -c y.tab.c",
		"\trm -f y.tab.c $*.y",
		"\tmv y.tab.o $*.o",
	".yr.o:",
		"\t$(YACCR) $(YFLAGS) $<",
		"\t$(FC) $(RFLAGS) -c y.tab.r",
		"\trm y.tab.r",
		"\tmv y.tab.o $@",
	".yr~.o:",
		"\t$(GET) $(GFLAGS) -p $< > $*.yr",
		"\t$(YACCR) $(YFLAGS) $*.yr",
		"\t$(FC) $(RFLAGS) -c y.tab.r",
		"\trm -f y.tab.r $*.yr",
		"\tmv y.tab.o $@",
	".ye.o:",
		"\t$(YACCE) $(YFLAGS) $<",
		"\t$(FC) $(EFLAGS) -c y.tab.e",
		"\trm y.tab.e",
		"\tmv y.tab.o $@",
	".ye~.o:",
		"\t$(GET) $(GFLAGS) -p $< > $*.ye",
		"\t$(YACCR) $(YFLAGS) $*.ye",
		"\t$(FC) $(RFLAGS) -c y.tab.e",
		"\trm -f y.tab.e $*.ye",
		"\tmv y.tab.o $@",
	".l.o:",
		"\t$(LEX) $(LFLAGS) $<",
		"\t$(CC) $(CFLAGS) -c lex.yy.c",
		"\trm lex.yy.c",
		"\tmv lex.yy.o $@",
	".l~.o:",
		"\t$(GET) $(GFLAGS) -p $< > $*.l",
		"\t$(LEX) $(LFLAGS) $*.l",
		"\t$(CC) $(CFLAGS) -c lex.yy.c",
		"\trm -f lex.yy.c $*.l",
		"\tmv lex.yy.o $*.o",
	".y.c :",
		"\t$(YACC) $(YFLAGS) $<",
		"\tmv y.tab.c $@",
	".y~.c :",
		"\t$(GET) $(GFLAGS) -p $< > $*.y",
		"\t$(YACC) $(YFLAGS) $*.y",
		"\tmv y.tab.c $*.c",
		"\t-rm -f $*.y",
	".l.c :",
		"\t$(LEX) $(LFLAGS) $<",
		"\tmv lex.yy.c $@",
	".l~.c :",
		"\t$(GET) $(GFLAGS) -p $< > $*.l",
		"\t$(LEX) $(LFLAGS) $*.l",
		"\tmv lex.yy.c $*.c",
		"\t-rm -f $*.l",
	".c.a:",
		"\t$(CC) -c $(CFLAGS) $<",
		"\tar rv $@ $*.o",
		"\trm -f $*.o",
	".c~.a:",
		"\t$(GET) $(GFLAGS) -p $< > $*.c",
		"\t$(CC) -c $(CFLAGS) $*.c",
		"\tar rv $@ $*.o",
		"\trm -f $*.[co]",
	".s~.a:",
		"\t$(GET) $(GFLAGS) -p $< > $*.s",
		"\t$(AS) $(ASFLAGS) -o $*.o $*.s",
		"\tar rv $@ $*.o",
		"\t-rm -f $*.[so]",
	".h~.h:",
		"\t$(GET) $(GFLAGS) -p $< > $*.h",
	"markfile.o:	markfile",
		"\tA=@;echo \"static char _sccsid[] = \\042`grep $$A'(#)' markfile`\\042;\" > markfile.c",
		"\tcc -c markfile.c",
		"\trm -f markfile.c",
	0 };

