#include	"defs.h"
#include	"global.h"
#include	"emit.h"

/*-->getbytes*/
/**********************************************************************/
/*****************************  getbytes  *****************************/
/**********************************************************************/

void
getbytes(fp, cp, n)	/* get n bytes from file fp */
FILE *fp;	/* file pointer	 */
byte *cp;	/* character pointer */
int n;		/* number of bytes  */
{
    (void)fread((char *)cp, 1, n, fp);
}

void
skipbytes(fp, n)
FILE *fp;
int n;
{
    (void)fseek(fp, (long)n, SEEK_CUR);
}


/*-->getuint*/
/**********************************************************************/
/***************************  getuint  ********************************/
/**********************************************************************/

int
getuint(fp, n)	/* return n byte quantity from file fd */
FILE *fp;	/* file pointer    */
int n;		/* number of bytes */
{
    byte s[sizeof(int)];

    (void)fread((char *)s, 1, n, fp);
    return makeuint(s, n);
}


/*-->getint*/
/**********************************************************************/
/****************************  getint  ********************************/
/**********************************************************************/

int
getint(fp, n)	/* return n byte quantity from file fd */
FILE *fp;	/* file pointer    */
int n;		/* number of bytes */
{
    byte s[sizeof(int)];

    (void)fread((char *)s, 1, n, fp);
    return makeint(s, n);
}


/* formatted i/o was killing us, so build some tables */
char *digit = "0123456789ABCDEF";

/*-->putint*/
/**********************************************************************/
/*****************************  putint  *******************************/
/**********************************************************************/

void
putint(n)               /* output an integer followed by a space */
int n;
{
    char buf[10];
    char *b;

    if (n == 0)
	EMITC('0');
    else {
	if (n < 0) {
	    EMITC('-');
	    n = -n;
	}
	for (b=buf; n>0; ) {
	    *b++ = digit[n%10];
	    n /= 10;
	}
	for ( ; b>buf; )
	    EMITC(*--b);
    }
    EMITC(' ');
}


/*-->putoct*/
/**********************************************************************/
/*****************************  putoct  *******************************/
/**********************************************************************/

void
putoct(n)               /* output an 3 digit octal number preceded by a "\" */
int n;
{
    EMITC('\\');
    EMITC(digit[(n&0300)>>6]);
    EMITC(digit[(n&0070)>>3]);
    EMITC(digit[n&0007]);
}
