/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.event.filters;

import gnu.classpath.jdwp.event.Event;
import gnu.classpath.jdwp.event.filters.IEventFilter;
import gnu.classpath.jdwp.exception.InvalidObjectException;
import gnu.classpath.jdwp.id.ObjectId;

public class InstanceOnlyFilter
implements IEventFilter {
    private ObjectId _instance;

    public InstanceOnlyFilter(ObjectId oid) throws InvalidObjectException {
        if (oid != null && oid.getReference().get() == null) {
            throw new InvalidObjectException(oid.getId());
        }
        this._instance = oid;
    }

    public ObjectId getInstance() {
        return this._instance;
    }

    public boolean matches(Event event) {
        Object eventInstance = event.getParameter(4);
        if (eventInstance != null) {
            Object myInstance = this._instance.getReference().get();
            return myInstance != null && myInstance == eventInstance;
        }
        return false;
    }
}

