/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import gnu.java.security.OID;
import gnu.java.security.key.dss.DSSPublicKey;
import gnu.java.security.x509.GnuPKIExtension;
import gnu.java.security.x509.PolicyNodeImpl;
import gnu.java.security.x509.X509CRLSelectorImpl;
import gnu.java.security.x509.X509CertSelectorImpl;
import gnu.java.security.x509.ext.BasicConstraints;
import gnu.java.security.x509.ext.CertificatePolicies;
import gnu.java.security.x509.ext.Extension;
import gnu.java.security.x509.ext.PolicyConstraint;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyQualifierInfo;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class PKIXCertPathValidatorImpl
extends CertPathValidatorSpi {
    private static final Logger log = null;
    public static final String ANY_POLICY = "2.5.29.32.0";

    public CertPathValidatorResult engineValidate(CertPath path, CertPathParameters params) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        Collection<? extends CRL> c;
        LinkedList crls;
        List<CertStore> certStores;
        X509CRLSelectorImpl selector;
        if (!(params instanceof PKIXParameters)) {
            throw new InvalidAlgorithmParameterException("not a PKIXParameters object");
        }
        PolicyNodeImpl rootNode = new PolicyNodeImpl();
        Set<String> initPolicies = ((PKIXParameters)params).getInitialPolicies();
        rootNode.setValidPolicy(ANY_POLICY);
        rootNode.setCritical(false);
        rootNode.setDepth(0);
        if (initPolicies != null) {
            rootNode.addAllExpectedPolicies(initPolicies);
        } else {
            rootNode.addExpectedPolicy(ANY_POLICY);
        }
        List<PKIXCertPathChecker> checks = ((PKIXParameters)params).getCertPathCheckers();
        List<? extends Certificate> l = path.getCertificates();
        if (l == null || l.size() == 0) {
            throw new CertPathValidatorException();
        }
        X509Certificate[] p = null;
        try {
            p = l.toArray(new X509Certificate[l.size()]);
        }
        catch (ClassCastException classCastException) {
            throw new CertPathValidatorException("invalid certificate path");
        }
        String sigProvider = ((PKIXParameters)params).getSigProvider();
        PublicKey prevKey = null;
        Date now = ((PKIXParameters)params).getDate();
        if (now == null) {
            now = new Date();
        }
        LinkedList<int[]> policyConstraints = new LinkedList<int[]>();
        int i = p.length - 1;
        while (i >= 0) {
            Object pcx;
            try {
                p[i].checkValidity(now);
            }
            catch (CertificateException ce) {
                throw new CertPathValidatorException(ce.toString());
            }
            Set uce = PKIXCertPathValidatorImpl.getCritExts(p[i]);
            Iterator<PKIXCertPathChecker> check = checks.iterator();
            while (check.hasNext()) {
                try {
                    check.next().check(p[i], uce);
                }
                catch (Exception exception) {}
            }
            PolicyConstraint constr = null;
            if (p[i] instanceof GnuPKIExtension) {
                pcx = ((GnuPKIExtension)((Object)p[i])).getExtension(PolicyConstraint.ID);
                if (pcx != null) {
                    constr = (PolicyConstraint)((Extension)pcx).getValue();
                }
            } else {
                pcx = p[i].getExtensionValue(PolicyConstraint.ID.toString());
                if (pcx != null) {
                    try {
                        constr = new PolicyConstraint((byte[])pcx);
                    }
                    catch (Exception exception) {}
                }
            }
            if (constr != null && constr.getRequireExplicitPolicy() >= 0) {
                policyConstraints.add(new int[]{p.length - i, constr.getRequireExplicitPolicy()});
            }
            PKIXCertPathValidatorImpl.updatePolicyTree(p[i], rootNode, p.length - i, (PKIXParameters)params, this.checkExplicitPolicy(p.length - i, policyConstraints));
            if (i == 0) break;
            PKIXCertPathValidatorImpl.basicSanity(p, i);
            PublicKey pubKey = null;
            try {
                DSAParams dsa;
                pubKey = p[i].getPublicKey();
                if (pubKey instanceof DSAPublicKey && ((dsa = ((DSAPublicKey)pubKey).getParams()) == null || dsa.getP() == null || dsa.getG() == null || dsa.getQ() == null)) {
                    if (prevKey == null) {
                        throw new InvalidKeyException("DSA keys not chainable");
                    }
                    if (!(prevKey instanceof DSAPublicKey)) {
                        throw new InvalidKeyException("DSA keys not chainable");
                    }
                    dsa = ((DSAPublicKey)prevKey).getParams();
                    pubKey = new DSSPublicKey(2, dsa.getP(), dsa.getQ(), dsa.getG(), ((DSAPublicKey)pubKey).getY());
                }
                if (sigProvider == null) {
                    p[i - 1].verify(pubKey);
                } else {
                    p[i - 1].verify(pubKey, sigProvider);
                }
                prevKey = pubKey;
            }
            catch (Exception e) {
                throw new CertPathValidatorException(e.toString());
            }
            if (!p[i].getSubjectDN().equals(p[i - 1].getIssuerDN())) {
                throw new CertPathValidatorException("issuer DN mismatch");
            }
            boolean[] issuerUid = p[i - 1].getIssuerUniqueID();
            boolean[] subjectUid = p[i].getSubjectUniqueID();
            if (issuerUid != null && subjectUid != null && !Arrays.equals(issuerUid, subjectUid)) {
                throw new CertPathValidatorException("UID mismatch");
            }
            if (((PKIXParameters)params).isRevocationEnabled()) {
                selector = new X509CRLSelectorImpl();
                try {
                    selector.addIssuerName(p[i].getSubjectDN());
                }
                catch (IOException iOException) {
                    throw new CertPathValidatorException("error selecting CRLs");
                }
                certStores = ((PKIXParameters)params).getCertStores();
                crls = new LinkedList();
                for (CertStore cs : certStores) {
                    try {
                        c = cs.getCRLs(selector);
                        crls.addAll(c);
                    }
                    catch (CertStoreException certStoreException) {}
                }
                if (crls.isEmpty()) {
                    throw new CertPathValidatorException("no CRLs for issuer");
                }
                boolean certOk = false;
                for (CRL crl : crls) {
                    X509CRL xcrl;
                    if (!(crl instanceof X509CRL) || !PKIXCertPathValidatorImpl.checkCRL(xcrl = (X509CRL)crl, p, now, p[i], pubKey, certStores)) continue;
                    if (xcrl.isRevoked(p[i - 1])) {
                        throw new CertPathValidatorException("certificate is revoked");
                    }
                    certOk = true;
                }
                if (!certOk) {
                    throw new CertPathValidatorException("certificate's validity could not be determined");
                }
            }
            --i;
        }
        rootNode.setReadOnly();
        Exception cause = null;
        Set<TrustAnchor> anchors = ((PKIXParameters)params).getTrustAnchors();
        for (TrustAnchor anchor : anchors) {
            X509Certificate anchorCert = null;
            PublicKey anchorKey = null;
            if (anchor.getTrustedCert() != null) {
                anchorCert = anchor.getTrustedCert();
                anchorKey = anchorCert.getPublicKey();
            } else {
                anchorKey = anchor.getCAPublicKey();
            }
            if (anchorKey == null) continue;
            try {
                if (anchorCert != null) {
                    anchorCert.checkValidity(now);
                }
                p[p.length - 1].verify(anchorKey);
                if (anchorCert != null && anchorCert.getBasicConstraints() >= 0 && anchorCert.getBasicConstraints() < p.length) continue;
                if (((PKIXParameters)params).isRevocationEnabled()) {
                    selector = new X509CRLSelectorImpl();
                    if (anchorCert != null) {
                        try {
                            selector.addIssuerName(anchorCert.getSubjectDN());
                        }
                        catch (IOException iOException) {}
                    } else {
                        selector.addIssuerName(anchor.getCAName());
                    }
                    certStores = ((PKIXParameters)params).getCertStores();
                    crls = new LinkedList();
                    for (CertStore cs : certStores) {
                        try {
                            c = cs.getCRLs(selector);
                            crls.addAll(c);
                        }
                        catch (CertStoreException certStoreException) {}
                    }
                    if (crls.isEmpty()) continue;
                    for (CRL crl : crls) {
                        if (!(crl instanceof X509CRL)) continue;
                        X509CRL xcrl = (X509CRL)crl;
                        try {
                            xcrl.verify(anchorKey);
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        Date nextUpdate = xcrl.getNextUpdate();
                        if (nextUpdate != null && nextUpdate.compareTo(now) < 0 || !xcrl.isRevoked(p[p.length - 1])) continue;
                        throw new CertPathValidatorException("certificate is revoked");
                    }
                }
                return new PKIXCertPathValidatorResult(anchor, rootNode, p[0].getPublicKey());
            }
            catch (Exception ignored) {
                cause = ignored;
            }
        }
        CertPathValidatorException cpve = new CertPathValidatorException("path validation failed");
        if (cause != null) {
            cpve.initCause(cause);
        }
        throw cpve;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkCRL(X509CRL crl, X509Certificate[] path, Date now, X509Certificate pubKeyCert, PublicKey pubKey, List certStores) {
        Date nextUpdate = crl.getNextUpdate();
        if (nextUpdate != null && nextUpdate.compareTo(now) < 0) {
            return false;
        }
        if (crl.hasUnsupportedCriticalExtension()) {
            return false;
        }
        int i = 0;
        while (i < path.length) {
            boolean[] keyUsage;
            if (path[i].getSubjectDN().equals(crl.getIssuerDN()) && ((keyUsage = path[i].getKeyUsage()) == null || keyUsage[6])) {
                try {
                    crl.verify(path[i].getPublicKey());
                    return true;
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        if (crl.getIssuerDN().equals(pubKeyCert.getSubjectDN())) {
            try {
                boolean[] keyUsage = pubKeyCert.getKeyUsage();
                if (keyUsage != null && !keyUsage[6]) {
                    throw new Exception();
                }
                crl.verify(pubKey);
                return true;
            }
            catch (Exception exception) {}
        }
        try {
            X509CertSelectorImpl select = new X509CertSelectorImpl();
            select.addSubjectName(crl.getIssuerDN());
            LinkedList certs = new LinkedList();
            for (CertStore cs : certStores) {
                try {
                    certs.addAll(cs.getCertificates(select));
                }
                catch (CertStoreException certStoreException) {}
            }
            for (X509Certificate c : certs) {
                int i2 = 0;
                while (i2 < path.length) {
                    boolean[] keyUsage;
                    if (c.getIssuerDN().equals(path[i2].getSubjectDN()) && ((keyUsage = c.getKeyUsage()) == null || keyUsage[6])) {
                        try {
                            c.verify(path[i2].getPublicKey());
                            crl.verify(c.getPublicKey());
                            return true;
                        }
                        catch (Exception exception) {}
                    }
                    ++i2;
                }
                if (!c.getIssuerDN().equals(pubKeyCert.getSubjectDN())) continue;
                c.verify(pubKey);
                crl.verify(c.getPublicKey());
            }
            return false;
        }
        catch (Exception exception) {}
        return false;
    }

    private static Set getCritExts(X509Certificate cert) {
        HashSet<String> s = new HashSet<String>();
        if (cert instanceof GnuPKIExtension) {
            Collection exts = ((GnuPKIExtension)((Object)cert)).getExtensions();
            for (Extension ext : exts) {
                if (!ext.isCritical() || ext.isSupported()) continue;
                s.add(ext.getOid().toString());
            }
        } else {
            s.addAll(cert.getCriticalExtensionOIDs());
        }
        return s;
    }

    private static void basicSanity(X509Certificate[] path, int index) throws CertPathValidatorException {
        X509Certificate cert = path[index];
        int pathLen = 0;
        int i = index - 1;
        while (i > 0) {
            if (!path[i].getIssuerDN().equals(path[i].getSubjectDN())) {
                ++pathLen;
            }
            --i;
        }
        Extension e = null;
        if (cert instanceof GnuPKIExtension) {
            e = ((GnuPKIExtension)((Object)cert)).getExtension(BasicConstraints.ID);
        } else {
            try {
                e = new Extension(cert.getExtensionValue(BasicConstraints.ID.toString()));
            }
            catch (Exception exception) {}
        }
        if (e == null) {
            throw new CertPathValidatorException("no basicConstraints");
        }
        BasicConstraints bc = (BasicConstraints)e.getValue();
        if (!bc.isCA()) {
            throw new CertPathValidatorException("certificate cannot be used to verify signatures");
        }
        if (bc.getPathLengthConstraint() >= 0 && bc.getPathLengthConstraint() < pathLen) {
            throw new CertPathValidatorException("path is too long");
        }
        boolean[] keyUsage = cert.getKeyUsage();
        if (keyUsage != null && !keyUsage[5]) {
            throw new CertPathValidatorException("certificate cannot be used to sign certificates");
        }
    }

    private static void updatePolicyTree(X509Certificate cert, PolicyNodeImpl root, int depth, PKIXParameters params, boolean explicitPolicy) throws CertPathValidatorException {
        HashSet nodes = new HashSet();
        LinkedList<Iterator> stack = new LinkedList<Iterator>();
        Iterator current = null;
        stack.addLast(Collections.singleton(root).iterator());
        do {
            current = (Iterator)stack.removeLast();
            while (current.hasNext()) {
                PolicyNodeImpl p = (PolicyNodeImpl)current.next();
                if (p.getDepth() == depth - 1) {
                    nodes.add(p);
                    continue;
                }
                stack.addLast(current);
                current = p.getChildren();
            }
        } while (!stack.isEmpty());
        Extension e = null;
        CertificatePolicies policies = null;
        if (cert instanceof GnuPKIExtension && (e = ((GnuPKIExtension)((Object)cert)).getExtension(CertificatePolicies.ID)) != null) {
            policies = (CertificatePolicies)e.getValue();
        }
        List<OID> cp = null;
        cp = policies != null ? policies.getPolicies() : Collections.EMPTY_LIST;
        boolean match = false;
        for (PolicyNodeImpl parent : nodes) {
            for (OID policy : cp) {
                List<PolicyQualifierInfo> qualifiers;
                if (policy.toString().equals(ANY_POLICY) && params.isAnyPolicyInhibited()) continue;
                PolicyNodeImpl child = new PolicyNodeImpl();
                child.setValidPolicy(policy.toString());
                child.addExpectedPolicy(policy.toString());
                if (parent.getExpectedPolicies().contains(policy.toString())) {
                    parent.addChild(child);
                    match = true;
                } else if (parent.getExpectedPolicies().contains(ANY_POLICY)) {
                    parent.addChild(child);
                    match = true;
                } else if (ANY_POLICY.equals(policy.toString())) {
                    parent.addChild(child);
                    match = true;
                }
                if (!match || policies == null || (qualifiers = policies.getPolicyQualifierInfos(policy)) == null) continue;
                child.addAllPolicyQualifiers(qualifiers);
            }
        }
        if (!match && (params.isExplicitPolicyRequired() || explicitPolicy)) {
            throw new CertPathValidatorException("policy tree building failed");
        }
    }

    private boolean checkExplicitPolicy(int depth, List explicitPolicies) {
        for (int[] i : explicitPolicies) {
            int limit;
            int caDepth = i[0];
            if (depth - caDepth < (limit = i[1])) continue;
            return true;
        }
        return false;
    }
}

