/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.prng;

import gnu.java.security.Registry;
import gnu.java.security.prng.BasePRNG;
import gnu.java.security.prng.IRandom;
import gnu.javax.crypto.mac.HMacFactory;
import gnu.javax.crypto.mac.IMac;
import gnu.javax.crypto.mac.MacFactory;
import gnu.javax.crypto.prng.ARCFour;
import gnu.javax.crypto.prng.ICMGenerator;
import gnu.javax.crypto.prng.PBKDF2;
import gnu.javax.crypto.prng.UMacGenerator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PRNGFactory
implements Registry {
    private PRNGFactory() {
    }

    public static IRandom getInstance(String prng) {
        if (prng == null) {
            return null;
        }
        prng = prng.trim();
        BasePRNG result = null;
        if (prng.equalsIgnoreCase("arcfour") || prng.equalsIgnoreCase("rc4")) {
            result = new ARCFour();
        } else if (prng.equalsIgnoreCase("icm")) {
            result = new ICMGenerator();
        } else if (prng.equalsIgnoreCase("umac-kdf")) {
            result = new UMacGenerator();
        } else if (prng.toLowerCase().startsWith("pbkdf2-")) {
            String macName = prng.substring("pbkdf2-".length());
            IMac mac = MacFactory.getInstance(macName);
            if (mac == null) {
                return null;
            }
            result = new PBKDF2(mac);
        }
        if (result != null) {
            return result;
        }
        return gnu.java.security.prng.PRNGFactory.getInstance(prng);
    }

    public static Set getNames() {
        HashSet<String> hs = new HashSet<String>(gnu.java.security.prng.PRNGFactory.getNames());
        hs.add("icm");
        hs.add("umac-kdf");
        Iterator it = HMacFactory.getNames().iterator();
        while (it.hasNext()) {
            hs.add("pbkdf2-" + (String)it.next());
        }
        return Collections.unmodifiableSet(hs);
    }
}

