/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Permissions
extends PermissionCollection
implements Serializable {
    private static final long serialVersionUID = 4858622370623524688L;
    private PermissionCollection allPermission;
    final Hashtable perms = new Hashtable();

    @Override
    public void add(Permission perm) {
        if (this.isReadOnly()) {
            throw new SecurityException("PermissionCollection is read only");
        }
        if (perm instanceof AllPermission) {
            if (this.allPermission == null) {
                this.allPermission = perm.newPermissionCollection();
                this.allPermission.add(perm);
                this.perms.put(perm.getClass(), this.allPermission);
            }
        } else {
            PermissionCollection pc = (PermissionCollection)this.perms.get(perm.getClass());
            if (pc == null) {
                pc = perm.newPermissionCollection();
                if (pc == null) {
                    pc = new PermissionsHash();
                }
                this.perms.put(perm.getClass(), pc);
            }
            pc.add(perm);
        }
    }

    @Override
    public boolean implies(Permission perm) {
        if (this.allPermission != null) {
            return true;
        }
        PermissionCollection pc = (PermissionCollection)this.perms.get(perm.getClass());
        return pc == null ? false : pc.implies(perm);
    }

    @Override
    public Enumeration<Permission> elements() {
        return new Enumeration(){
            Enumeration main_enum;
            Enumeration sub_enum;
            {
                this.main_enum = Permissions.this.perms.elements();
            }

            public boolean hasMoreElements() {
                if (this.sub_enum == null) {
                    if (this.main_enum == null) {
                        return false;
                    }
                    if (!this.main_enum.hasMoreElements()) {
                        this.main_enum = null;
                        return false;
                    }
                    PermissionCollection pc = (PermissionCollection)this.main_enum.nextElement();
                    this.sub_enum = pc.elements();
                }
                if (!this.sub_enum.hasMoreElements()) {
                    this.sub_enum = null;
                    return this.hasMoreElements();
                }
                return true;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                return this.sub_enum.nextElement();
            }
        };
    }

    private static final class PermissionsHash
    extends PermissionCollection {
        private static final long serialVersionUID = -8491988220802933440L;
        private final Hashtable perms = new Hashtable();

        private PermissionsHash() {
        }

        public void add(Permission perm) {
            this.perms.put(perm, perm);
        }

        public boolean implies(Permission perm) {
            Enumeration elements = this.elements();
            while (elements.hasMoreElements()) {
                Permission p = (Permission)elements.nextElement();
                if (!p.implies(perm)) continue;
                return true;
            }
            return false;
        }

        public Enumeration elements() {
            return this.perms.elements();
        }
    }
}

