/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationFilterSupport
implements NotificationFilter {
    private static final long serialVersionUID = 6579080007561786969L;
    private final Vector<String> enabledTypes = new Vector();

    public void disableAllTypes() {
        this.enabledTypes.clear();
    }

    public void disableType(String prefix) {
        this.enabledTypes.remove(prefix);
    }

    public void enableType(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("A null prefix was supplied.");
        }
        if (!this.enabledTypes.contains(prefix)) {
            this.enabledTypes.add(prefix);
        }
    }

    public Vector<String> getEnabledTypes() {
        return this.enabledTypes;
    }

    @Override
    public boolean isNotificationEnabled(Notification notif) {
        String nType = notif.getType();
        for (String type : this.enabledTypes) {
            if (!nType.startsWith(type)) continue;
            return true;
        }
        return false;
    }
}

