/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key.dh;

import gnu.java.security.Registry;
import gnu.java.security.action.GetPropertyAction;
import gnu.javax.crypto.key.dh.DHKeyPairPKCS8Codec;
import gnu.javax.crypto.key.dh.DHKeyPairRawCodec;
import gnu.javax.crypto.key.dh.GnuDHKey;
import java.math.BigInteger;
import java.security.AccessController;
import javax.crypto.interfaces.DHPrivateKey;

public class GnuDHPrivateKey
extends GnuDHKey
implements DHPrivateKey {
    private final BigInteger x;
    private transient String str;

    public GnuDHPrivateKey(BigInteger q, BigInteger p, BigInteger g, BigInteger x) {
        this(1, q, p, g, x);
    }

    public GnuDHPrivateKey(int preferredFormat, BigInteger q, BigInteger p, BigInteger g, BigInteger x) {
        super(preferredFormat == 4 ? 3 : preferredFormat, q, p, g);
        this.x = x;
    }

    public static GnuDHPrivateKey valueOf(byte[] k) {
        if (k[0] == Registry.MAGIC_RAW_DH_PRIVATE_KEY[0]) {
            try {
                return (GnuDHPrivateKey)new DHKeyPairRawCodec().decodePrivateKey(k);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return (GnuDHPrivateKey)new DHKeyPairPKCS8Codec().decodePrivateKey(k);
    }

    public BigInteger getX() {
        return this.x;
    }

    public byte[] getEncoded(int format) {
        byte[] result;
        switch (format) {
            case 1: {
                result = new DHKeyPairRawCodec().encodePrivateKey(this);
                break;
            }
            case 3: {
                result = new DHKeyPairPKCS8Codec().encodePrivateKey(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported encoding format: " + format);
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DHPrivateKey)) {
            return false;
        }
        DHPrivateKey that = (DHPrivateKey)obj;
        return super.equals(that) && this.x.equals(that.getX());
    }

    public String toString() {
        if (this.str == null) {
            String ls = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
            this.str = this.getClass().getName() + "(" + super.toString() + "," + ls + "x=0x" + "**...*" + ls + ")";
        }
        return this.str;
    }
}

