/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.aelfred2;

import gnu.xml.aelfred2.SAXDriver;
import gnu.xml.pipeline.EventFilter;
import gnu.xml.pipeline.ValidationConsumer;
import java.io.IOException;
import java.util.Locale;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;

public final class XmlReader
implements XMLReader {
    private SAXDriver aelfred2 = new SAXDriver();
    private EventFilter filter = new EventFilter();
    private boolean isValidating;
    private boolean active;

    public XmlReader() {
    }

    public XmlReader(boolean invalidIsFatal) {
        if (invalidIsFatal) {
            this.setErrorHandler(new FatalErrorHandler());
        }
    }

    public ContentHandler getContentHandler() {
        return this.filter.getContentHandler();
    }

    public void setContentHandler(ContentHandler handler) {
        if (this.active) {
            throw new IllegalStateException("already parsing");
        }
        this.filter.setContentHandler(handler);
    }

    public DTDHandler getDTDHandler() {
        return this.filter.getDTDHandler();
    }

    public void setDTDHandler(DTDHandler handler) {
        if (this.active) {
            throw new IllegalStateException("already parsing");
        }
        this.filter.setDTDHandler(handler);
    }

    public EntityResolver getEntityResolver() {
        return this.aelfred2.getEntityResolver();
    }

    public void setEntityResolver(EntityResolver handler) {
        this.aelfred2.setEntityResolver(handler);
    }

    public ErrorHandler getErrorHandler() {
        return this.aelfred2.getErrorHandler();
    }

    public void setErrorHandler(ErrorHandler handler) {
        if (this.active) {
            throw new IllegalStateException("already parsing");
        }
        this.aelfred2.setErrorHandler(handler);
    }

    public void setProperty(String propertyId, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.active) {
            throw new IllegalStateException("already parsing");
        }
        if (this.getProperty(propertyId) != value) {
            this.filter.setProperty(propertyId, value);
        }
    }

    public Object getProperty(String propertyId) throws SAXNotRecognizedException {
        if ("http://xml.org/sax/properties/declaration-handler".equals(propertyId) || "http://xml.org/sax/properties/lexical-handler".equals(propertyId)) {
            return this.filter.getProperty(propertyId);
        }
        throw new SAXNotRecognizedException(propertyId);
    }

    private void forceValidating() throws SAXNotRecognizedException, SAXNotSupportedException {
        this.aelfred2.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        this.aelfred2.setFeature("http://xml.org/sax/features/external-general-entities", true);
        this.aelfred2.setFeature("http://xml.org/sax/features/external-parameter-entities", true);
    }

    public void setFeature(String featureId, boolean state) throws SAXNotRecognizedException, SAXNotSupportedException {
        boolean value = this.getFeature(featureId);
        if (state == value) {
            return;
        }
        if ("http://xml.org/sax/features/validation".equals(featureId)) {
            if (this.active) {
                throw new SAXNotSupportedException("already parsing");
            }
            if (state) {
                this.forceValidating();
            }
            this.isValidating = state;
        } else {
            this.aelfred2.setFeature(featureId, state);
        }
    }

    public boolean getFeature(String featureId) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/validation".equals(featureId)) {
            return this.isValidating;
        }
        return this.aelfred2.getFeature(featureId);
    }

    public void setLocale(Locale locale) throws SAXException {
        this.aelfred2.setLocale(locale);
    }

    public void parse(String systemId) throws SAXException, IOException {
        this.parse(new InputSource(systemId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource source) throws SAXException, IOException {
        EventFilter next;
        SAXDriver sAXDriver = this.aelfred2;
        synchronized (sAXDriver) {
            if (this.active) {
                throw new IllegalStateException("already parsing");
            }
            this.active = true;
        }
        if (this.isValidating) {
            this.forceValidating();
            next = new ValidationConsumer(this.filter);
        } else {
            next = this.filter;
        }
        boolean nsdecls = this.aelfred2.getFeature("http://xml.org/sax/features/namespace-prefixes");
        EventFilter.bind(this.aelfred2, next);
        if (!nsdecls) {
            this.aelfred2.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        try {
            this.aelfred2.parse(source);
        }
        finally {
            this.active = false;
        }
    }

    static class FatalErrorHandler
    extends DefaultHandler2 {
        FatalErrorHandler() {
        }

        public void error(SAXParseException e) throws SAXException {
            throw e;
        }
    }
}

