/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.pipeline;

import gnu.xml.pipeline.EventConsumer;
import gnu.xml.pipeline.EventFilter;
import java.util.EmptyStackException;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class WellFormednessFilter
extends EventFilter {
    private boolean startedDoc;
    private Stack elementStack = new Stack();
    private boolean startedCDATA;
    private String dtdState = "before";

    public WellFormednessFilter() {
        this(null);
    }

    public WellFormednessFilter(EventConsumer consumer) {
        super(consumer);
        this.setContentHandler(this);
        this.setDTDHandler(this);
        try {
            this.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        }
        catch (SAXException sAXException) {}
    }

    public void reset() {
        this.startedDoc = false;
        this.startedCDATA = false;
        this.elementStack.removeAllElements();
    }

    private SAXParseException getException(String message) {
        Locator locator = this.getDocumentLocator();
        if (locator == null) {
            return new SAXParseException(message, null, null, -1, -1);
        }
        return new SAXParseException(message, locator);
    }

    private void fatalError(String message) throws SAXException {
        SAXParseException e = this.getException(message);
        ErrorHandler handler = this.getErrorHandler();
        if (handler != null) {
            handler.fatalError(e);
        }
        throw e;
    }

    public void setDocumentLocator(Locator locator) {
        if (this.startedDoc) {
            throw new IllegalStateException("setDocumentLocator called after startDocument");
        }
        super.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        if (this.startedDoc) {
            this.fatalError("startDocument called more than once");
        }
        this.startedDoc = true;
        this.startedCDATA = false;
        this.elementStack.removeAllElements();
        super.startDocument();
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (!this.startedDoc) {
            this.fatalError("callback outside of document?");
        }
        if ("inside".equals(this.dtdState)) {
            this.fatalError("element inside DTD?");
        } else {
            this.dtdState = "after";
        }
        if (this.startedCDATA) {
            this.fatalError("element inside CDATA section");
        }
        if (qName == null || "".equals(qName)) {
            this.fatalError("startElement name missing");
        }
        this.elementStack.push(qName);
        super.startElement(uri, localName, qName, atts);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.startedDoc) {
            this.fatalError("callback outside of document?");
        }
        if (this.startedCDATA) {
            this.fatalError("element inside CDATA section");
        }
        if (qName == null || "".equals(qName)) {
            this.fatalError("endElement name missing");
        }
        try {
            String top = (String)this.elementStack.pop();
            if (!qName.equals(top)) {
                this.fatalError("<" + top + " ...>...</" + qName + ">");
            }
        }
        catch (EmptyStackException emptyStackException) {
            this.fatalError("endElement without startElement:  </" + qName + ">");
        }
        super.endElement(uri, localName, qName);
    }

    public void endDocument() throws SAXException {
        if (!this.startedDoc) {
            this.fatalError("callback outside of document?");
        }
        this.dtdState = "before";
        this.startedDoc = false;
        super.endDocument();
    }

    public void startDTD(String root, String publicId, String systemId) throws SAXException {
        if (!this.startedDoc) {
            this.fatalError("callback outside of document?");
        }
        if ("before" != this.dtdState) {
            this.fatalError("two DTDs?");
        }
        if (!this.elementStack.empty()) {
            this.fatalError("DTD must precede root element");
        }
        this.dtdState = "inside";
        super.startDTD(root, publicId, systemId);
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        if ("after" == this.dtdState) {
            this.fatalError("not inside DTD");
        }
        super.notationDecl(name, publicId, systemId);
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        if ("after" == this.dtdState) {
            this.fatalError("not inside DTD");
        }
        super.unparsedEntityDecl(name, publicId, systemId, notationName);
    }

    public void endDTD() throws SAXException {
        if (!this.startedDoc) {
            this.fatalError("callback outside of document?");
        }
        if ("inside" != this.dtdState) {
            this.fatalError("DTD ends without start?");
        }
        this.dtdState = "after";
        super.endDTD();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        int here = start;
        int end = start + length;
        if (this.elementStack.empty()) {
            this.fatalError("characters must be in an element");
        }
        while (here < end) {
            if (ch[here++] != ']' || here == end || ch[here++] != ']' || here == end || ch[here++] != '>') continue;
            this.fatalError("character data can't contain \"]]>\"");
        }
        super.characters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        int here = start;
        int end = start + length;
        if (this.elementStack.empty()) {
            this.fatalError("characters must be in an element");
        }
        while (here < end) {
            if (ch[here++] != '\r') continue;
            this.fatalError("whitespace can't contain CR");
        }
        super.ignorableWhitespace(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (data.indexOf(13) > 0) {
            this.fatalError("PIs can't contain CR");
        }
        if (data.indexOf("?>") > 0) {
            this.fatalError("PIs can't contain \"?>\"");
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (!this.startedDoc) {
            this.fatalError("callback outside of document?");
        }
        if (this.startedCDATA) {
            this.fatalError("comments can't nest in CDATA");
        }
        int here = start;
        int end = start + length;
        while (here < end) {
            if (ch[here] == '\r') {
                this.fatalError("comments can't contain CR");
            }
            if (ch[here++] != '-') continue;
            if (here == end) {
                this.fatalError("comments can't end with \"--->\"");
            }
            if (ch[here++] != '-') continue;
            this.fatalError("comments can't contain \"--\"");
        }
        super.comment(ch, start, length);
    }

    public void startCDATA() throws SAXException {
        if (!this.startedDoc) {
            this.fatalError("callback outside of document?");
        }
        if (this.startedCDATA) {
            this.fatalError("CDATA starts can't nest");
        }
        this.startedCDATA = true;
        super.startCDATA();
    }

    public void endCDATA() throws SAXException {
        if (!this.startedDoc) {
            this.fatalError("callback outside of document?");
        }
        if (!this.startedCDATA) {
            this.fatalError("CDATA end without start?");
        }
        this.startedCDATA = false;
        super.endCDATA();
    }
}

