/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.CharBuffer;

public abstract class Reader
implements Closeable,
Readable {
    protected Object lock;

    protected Reader() {
        this.lock = this;
    }

    protected Reader(Object lock) {
        this.lock = lock;
    }

    public abstract int read(char[] var1, int var2, int var3) throws IOException;

    public int read(char[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read() throws IOException {
        char[] buf = new char[1];
        int count = this.read(buf, 0, 1);
        return count > 0 ? buf[0] : -1;
    }

    public int read(CharBuffer buffer) throws IOException {
        int rem = buffer.remaining();
        char[] buf = new char[rem];
        int result = this.read(buf, 0, rem);
        if (result != -1) {
            buffer.put(buf, 0, result);
        }
        return result;
    }

    public abstract void close() throws IOException;

    public boolean markSupported() {
        return false;
    }

    public void mark(int readLimit) throws IOException {
        throw new IOException("mark not supported");
    }

    public void reset() throws IOException {
        throw new IOException("reset not supported");
    }

    public boolean ready() throws IOException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long count) throws IOException {
        if (count <= 0L) {
            return 0L;
        }
        int bsize = count > 1024L ? 1024 : (int)count;
        char[] buffer = new char[bsize];
        long todo = count;
        Object object = this.lock;
        synchronized (object) {
            while (todo > 0L) {
                int skipped = this.read(buffer, 0, (long)bsize > todo ? (int)todo : bsize);
                if (skipped <= 0) break;
                todo -= (long)skipped;
            }
        }
        return count - todo;
    }
}

