/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;

public class ImageTypeSpecifier {
    protected ColorModel colorModel;
    protected SampleModel sampleModel;

    public ImageTypeSpecifier(ColorModel colorModel, SampleModel sampleModel) {
        if (colorModel == null) {
            throw new IllegalArgumentException("colorModel may not be null");
        }
        if (sampleModel == null) {
            throw new IllegalArgumentException("sampleModel may not be null");
        }
        if (!colorModel.isCompatibleSampleModel(sampleModel)) {
            throw new IllegalArgumentException("sample Model not compatible with colorModel");
        }
        this.colorModel = colorModel;
        this.sampleModel = sampleModel;
    }

    public ImageTypeSpecifier(RenderedImage image) {
        if (image == null) {
            throw new IllegalArgumentException("image may not be null");
        }
        this.colorModel = image.getColorModel();
        this.sampleModel = image.getSampleModel();
    }

    public static ImageTypeSpecifier createBanded(ColorSpace colorSpace, int[] bankIndices, int[] bankOffsets, int dataType, boolean hasAlpha, boolean isAlphaPremultiplied) {
        if (colorSpace == null || bankIndices == null || bankOffsets == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (bankIndices.length != bankOffsets.length) {
            throw new IllegalArgumentException("array lengths differ");
        }
        if (bankOffsets.length != colorSpace.getNumComponents() + (hasAlpha ? 1 : 0)) {
            throw new IllegalArgumentException("invalid bankOffsets length");
        }
        return new ImageTypeSpecifier(new ComponentColorModel(colorSpace, hasAlpha, isAlphaPremultiplied, hasAlpha ? 3 : 1, dataType), new BandedSampleModel(dataType, 1, 1, 1, bankIndices, bankOffsets));
    }

    public BufferedImage createBufferedImage(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("dimension <= 0");
        }
        if (width * height < Math.min(width, height)) {
            throw new IllegalArgumentException("width * height > Integer.MAX_VALUE");
        }
        if (width * height * this.sampleModel.getNumBands() < Math.min(width, height)) {
            throw new IllegalArgumentException("storage required > Integer.MAX_VALUE");
        }
        return new BufferedImage(width, height, 1);
    }

    public static ImageTypeSpecifier createFromBufferedImageType(int bufferedImageType) {
        if (bufferedImageType <= 0 || bufferedImageType > 13) {
            throw new IllegalArgumentException("invalid buffered image type");
        }
        return new ImageTypeSpecifier(new BufferedImage(1, 1, bufferedImageType));
    }

    public static ImageTypeSpecifier createFromRenderedImage(RenderedImage image) {
        if (image == null) {
            throw new IllegalArgumentException("image null");
        }
        return new ImageTypeSpecifier(image);
    }

    public static ImageTypeSpecifier createGrayscale(int bits, int dataType, boolean isSigned) {
        return ImageTypeSpecifier.createGrayscale(bits, dataType, isSigned, false);
    }

    public static ImageTypeSpecifier createGrayscale(int bits, int dataType, boolean isSigned, boolean isAlphaPremultiplied) {
        if (bits != 1 && bits != 2 && bits != 4 && bits != 8 && bits != 16) {
            throw new IllegalArgumentException("invalid bit size");
        }
        if (dataType != 0 && dataType != 2 && dataType != 1) {
            throw new IllegalArgumentException("invalid data type");
        }
        if (dataType == 0 && bits > 8) {
            throw new IllegalArgumentException("number of bits too large for data type");
        }
        return new ImageTypeSpecifier(new DirectColorModel(bits, 255, 0, 0, 255), new MultiPixelPackedSampleModel(dataType, 1, 1, bits));
    }

    public static ImageTypeSpecifier createIndexed(byte[] redLUT, byte[] greenLUT, byte[] blueLUT, byte[] alphaLUT, int bits, int dataType) {
        if (redLUT == null || greenLUT == null || blueLUT == null) {
            throw new IllegalArgumentException("null colour table");
        }
        if (bits != 1 && bits != 2 && bits != 4 && bits != 8 && bits != 16) {
            throw new IllegalArgumentException("invalid bit size");
        }
        if (dataType != 0 && dataType != 2 && dataType != 1) {
            throw new IllegalArgumentException("invalid data type");
        }
        if (dataType == 0 && bits > 8) {
            throw new IllegalArgumentException("number of bits too large for data type");
        }
        return new ImageTypeSpecifier(new IndexColorModel(bits, redLUT.length, redLUT, greenLUT, blueLUT, alphaLUT), new MultiPixelPackedSampleModel(dataType, 1, 1, bits));
    }

    public static ImageTypeSpecifier createInterleaved(ColorSpace colorSpace, int[] bandOffsets, int dataType, boolean hasAlpha, boolean isAlphaPremultiplied) {
        if (colorSpace == null || bandOffsets == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (bandOffsets.length != colorSpace.getNumComponents() + (hasAlpha ? 1 : 0)) {
            throw new IllegalArgumentException("invalid bankOffsets length");
        }
        return new ImageTypeSpecifier(new ComponentColorModel(colorSpace, hasAlpha, isAlphaPremultiplied, hasAlpha ? 3 : 1, dataType), new PixelInterleavedSampleModel(dataType, 1, 1, 1, 1, bandOffsets));
    }

    public static ImageTypeSpecifier createPacked(ColorSpace colorSpace, int redMask, int greenMask, int blueMask, int alphaMask, int transferType, boolean isAlphaPremultiplied) {
        if (colorSpace == null) {
            throw new IllegalArgumentException("null color space");
        }
        if (colorSpace.getType() != 5) {
            throw new IllegalArgumentException("invalid color space type");
        }
        if (redMask == 0 && greenMask == 0 && blueMask == 0 && alphaMask == 0) {
            throw new IllegalArgumentException("no non-zero mask");
        }
        if (transferType != 0 && transferType != 1 && transferType != 3) {
            throw new IllegalArgumentException("invalid data type");
        }
        int numBits = 8;
        if (transferType == 2) {
            numBits = 16;
        } else if (transferType == 3) {
            numBits = 32;
        }
        return new ImageTypeSpecifier(new DirectColorModel(colorSpace, numBits, redMask, greenMask, blueMask, alphaMask, isAlphaPremultiplied, transferType), new MultiPixelPackedSampleModel(transferType, 1, 1, numBits));
    }

    public int getBitsPerBand(int band) {
        if (band < 0 || band > this.sampleModel.getNumBands()) {
            throw new IllegalArgumentException("band out-of-bounds");
        }
        return this.sampleModel.getSampleSize(band);
    }

    public int getBufferedImageType() {
        return 1;
    }

    public SampleModel getSampleModel(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("invalid dimension");
        }
        if (width * height < Math.min(width, height)) {
            throw new IllegalArgumentException("width * height > Integer.MAX_VALUE");
        }
        return this.sampleModel.createCompatibleSampleModel(width, height);
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public int getNumBands() {
        return this.sampleModel.getNumBands();
    }

    public int getNumComponents() {
        return this.colorModel.getNumComponents();
    }

    public SampleModel getSampleModel() {
        return this.sampleModel;
    }
}

