/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;

public class MetalSliderUI
extends BasicSliderUI {
    protected static Color thumbColor;
    protected static Color highlightColor;
    protected static Color darkShadowColor;
    protected static int trackWidth;
    protected static int tickLength;
    protected static Icon horizThumbIcon;
    protected static Icon vertThumbIcon;
    protected final int TICK_BUFFER = 4;
    protected final String SLIDER_FILL = "JSlider.isFilled";
    protected boolean filledSlider = UIManager.getBoolean("JSlider.isFilled");

    static {
        trackWidth = UIManager.getInt("Slider.trackWidth");
        tickLength = UIManager.getInt("Slider.majorTickLength");
        horizThumbIcon = UIManager.getIcon("Slider.horizontalThumbIcon");
        vertThumbIcon = UIManager.getIcon("Slider.verticalThumbIcon");
    }

    public MetalSliderUI() {
        super(null);
        darkShadowColor = MetalLookAndFeel.getControlDarkShadow();
        highlightColor = MetalLookAndFeel.getControlHighlight();
    }

    public static ComponentUI createUI(JComponent component) {
        return new MetalSliderUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        Boolean b = (Boolean)c.getClientProperty("JSlider.isFilled");
        if (b != null) {
            this.filledSlider = b;
        }
    }

    protected PropertyChangeListener createPropertyChangeListener(JSlider slider) {
        return new MetalPropertyListener();
    }

    public void paintThumb(Graphics g) {
        Color save = g.getColor();
        g.setColor(thumbColor);
        if (this.slider.getOrientation() == 0) {
            horizThumbIcon.paintIcon(this.slider, g, this.thumbRect.x, this.thumbRect.y);
        } else {
            vertThumbIcon.paintIcon(this.slider, g, this.thumbRect.x, this.thumbRect.y);
        }
        g.setColor(save);
    }

    public void paintTrack(Graphics g) {
        ColorUIResource shadowColor = MetalLookAndFeel.getControlShadow();
        if (this.slider.getOrientation() == 0) {
            int trackX = this.trackRect.x;
            int trackY = this.trackRect.y + (this.trackRect.height - this.getTrackWidth()) / 2;
            int trackW = this.trackRect.width;
            int trackH = this.getTrackWidth();
            if (this.slider.isEnabled()) {
                BasicGraphicsUtils.drawEtchedRect(g, trackX, trackY, trackW, trackH, darkShadowColor, shadowColor, darkShadowColor, highlightColor);
            } else {
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.drawRect(trackX, trackY, trackW - 2, trackH - 2);
            }
            if (MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme) {
                if (this.slider.isEnabled()) {
                    int xPos = this.xPositionForValue(this.slider.getValue());
                    int x = this.slider.getInverted() ? xPos : this.trackRect.x;
                    int w = this.slider.getInverted() ? trackX + trackW - xPos : xPos - this.trackRect.x;
                    g.setColor(MetalLookAndFeel.getWhite());
                    g.drawLine(x + 1, trackY + 1, x + w - 3, trackY + 1);
                    g.setColor(UIManager.getColor("Slider.altTrackColor"));
                    g.drawLine(x + 1, trackY + 2, x + w - 3, trackY + 2);
                    g.setColor(MetalLookAndFeel.getControlShadow());
                    g.drawLine(x + 1, trackY + 3, x + w - 3, trackY + 3);
                    g.setColor(MetalLookAndFeel.getPrimaryControlShadow());
                    g.drawLine(x + 1, trackY + 4, x + w - 3, trackY + 4);
                }
            } else if (this.filledSlider) {
                int xPos = this.xPositionForValue(this.slider.getValue());
                int x = this.slider.getInverted() ? xPos : this.trackRect.x;
                int w = this.slider.getInverted() ? trackX + trackW - xPos : xPos - this.trackRect.x;
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.fillRect(x + 1, trackY + 1, w - 3, this.getTrackWidth() - 3);
                if (this.slider.isEnabled()) {
                    g.setColor(MetalLookAndFeel.getControl());
                    g.drawLine(x + 1, trackY + 1, x + w - 3, trackY + 1);
                    g.drawLine(x + 1, trackY + 1, x + 1, trackY + this.getTrackWidth() - 3);
                }
            }
        } else {
            int trackX = this.trackRect.x + (this.trackRect.width - this.getTrackWidth()) / 2;
            int trackY = this.trackRect.y;
            int trackW = this.getTrackWidth();
            int trackH = this.trackRect.height;
            if (this.slider.isEnabled()) {
                BasicGraphicsUtils.drawEtchedRect(g, trackX, trackY, trackW, trackH, darkShadowColor, shadowColor, darkShadowColor, highlightColor);
            } else {
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.drawRect(trackX, trackY, trackW - 2, trackH - 2);
            }
            if (MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme) {
                if (this.slider.isEnabled()) {
                    int yPos = this.yPositionForValue(this.slider.getValue());
                    int y = this.slider.getInverted() ? trackY : yPos;
                    int h = this.slider.getInverted() ? yPos - trackY : trackY + trackH - yPos;
                    g.setColor(MetalLookAndFeel.getWhite());
                    g.drawLine(trackX + 1, y + 1, trackX + 1, y + h - 3);
                    g.setColor(UIManager.getColor("Slider.altTrackColor"));
                    g.drawLine(trackX + 2, y + 1, trackX + 2, y + h - 3);
                    g.setColor(MetalLookAndFeel.getControlShadow());
                    g.drawLine(trackX + 3, y + 1, trackX + 3, y + h - 3);
                    g.setColor(MetalLookAndFeel.getPrimaryControlShadow());
                    g.drawLine(trackX + 4, y + 1, trackX + 4, y + h - 3);
                }
            } else if (this.filledSlider) {
                int yPos = this.yPositionForValue(this.slider.getValue());
                int y = this.slider.getInverted() ? trackY : yPos;
                int h = this.slider.getInverted() ? yPos - trackY : trackY + trackH - yPos;
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.fillRect(trackX + 1, y + 1, this.getTrackWidth() - 3, h - 3);
                if (this.slider.isEnabled()) {
                    g.setColor(MetalLookAndFeel.getControl());
                    g.drawLine(trackX + 1, y + 1, trackX + trackW - 3, y + 1);
                    g.drawLine(trackX + 1, y + 1, trackX + 1, y + h - 3);
                }
            }
        }
    }

    public void paintFocus(Graphics g) {
        thumbColor = this.getFocusColor();
        this.paintThumb(g);
    }

    protected Dimension getThumbSize() {
        if (this.slider.getOrientation() == 0) {
            return new Dimension(horizThumbIcon.getIconWidth(), horizThumbIcon.getIconHeight());
        }
        return new Dimension(vertThumbIcon.getIconWidth(), vertThumbIcon.getIconHeight());
    }

    public int getTickLength() {
        int len = tickLength + 4 + 1;
        if (this.slider.getOrientation() == 1) {
            len += 2;
        }
        return len;
    }

    protected int getTrackWidth() {
        return trackWidth;
    }

    protected int getTrackLength() {
        return this.slider.getOrientation() == 0 ? this.tickRect.width : this.tickRect.height;
    }

    protected int getThumbOverhang() {
        return 0;
    }

    protected void scrollDueToClickInTrack(int dir) {
        super.scrollDueToClickInTrack(dir);
    }

    protected void paintMinorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        if (this.slider.isEnabled()) {
            g.setColor(this.slider.getForeground());
        } else {
            g.setColor(MetalLookAndFeel.getControlShadow());
        }
        g.drawLine(x, 4, x, 4 + tickLength / 2);
    }

    protected void paintMajorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        if (this.slider.isEnabled()) {
            g.setColor(this.slider.getForeground());
        } else {
            g.setColor(MetalLookAndFeel.getControlShadow());
        }
        g.drawLine(x, 4, x, 4 + tickLength - 1);
    }

    protected void paintMinorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        if (this.slider.isEnabled()) {
            g.setColor(this.slider.getForeground());
        } else {
            g.setColor(MetalLookAndFeel.getControlShadow());
        }
        g.drawLine(4, y, 4 + tickLength / 2, y);
    }

    protected void paintMajorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        if (this.slider.isEnabled()) {
            g.setColor(this.slider.getForeground());
        } else {
            g.setColor(MetalLookAndFeel.getControlShadow());
        }
        g.drawLine(4, y, 4 + tickLength, y);
    }

    protected class MetalPropertyListener
    extends BasicSliderUI.PropertyChangeHandler {
        protected MetalPropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("JSlider.isFilled")) {
                Boolean b = (Boolean)e.getNewValue();
                MetalSliderUI.this.filledSlider = b == null ? false : b;
            } else {
                super.propertyChange(e);
            }
        }
    }
}

