/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.server.UnicastConnection;
import gnu.java.rmi.server.UnicastServer;
import gnu.java.rmi.server.UnicastServerRef;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationID;
import java.rmi.server.ObjID;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteStub;
import java.rmi.server.Skeleton;

public class ActivatableServerRef
extends UnicastServerRef {
    private static final long serialVersionUID = 1L;
    public ActivationID actId;

    public ActivatableServerRef() {
    }

    public ActivatableServerRef(ObjID id, ActivationID anId, int aPort, RMIServerSocketFactory ssFactory) throws RemoteException {
        super(id, aPort, ssFactory);
        this.actId = anId;
        UnicastServer.exportActivatableObject(this);
    }

    public void inactivate() {
        this.manager.stopServer();
    }

    protected void activate() throws RemoteException {
        try {
            Remote self = this.actId.activate(false);
            this.exportObject(self);
        }
        catch (RemoteException rex) {
            throw rex;
        }
        catch (Exception exc) {
            RemoteException rx = new RemoteException("Activation failed.");
            rx.detail = exc;
            throw rx;
        }
    }

    public Object incomingMessageCall(UnicastConnection conn, int method, long hash) throws Exception {
        if (this.myself == null) {
            this.activate();
        }
        return super.incomingMessageCall(conn, method, hash);
    }

    public Remote exportObject(Remote obj) throws RemoteException {
        Remote r = super.exportObject(obj);
        UnicastServer.registerActivatable(this);
        return r;
    }

    public Remote exportClass(Class aClass) throws RemoteException {
        Class cls;
        Class expCls;
        if (!Remote.class.isAssignableFrom(aClass)) {
            throw new InternalError(String.valueOf(aClass.getName()) + " must implement Remote");
        }
        ClassLoader loader = aClass.getClassLoader();
        String ignoreStubs = loader == null ? "false" : System.getProperty("java.rmi.server.ignoreStubClasses", "false");
        if (!ignoreStubs.equals("true") && (expCls = this.findStubSkelClass(cls = aClass)) != null) {
            this.stub = (RemoteStub)this.getHelperClass(expCls, "_Stub");
            this.skel = (Skeleton)this.getHelperClass(expCls, "_Skel");
        }
        if (this.stub == null) {
            this.stub = this.createProxyStub(aClass, this);
        }
        this.buildMethodHash(aClass, true);
        UnicastServer.registerActivatable(this);
        return this.stub;
    }

    public String getRefClass(ObjectOutput out) {
        return "ActivatableRef";
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.actId = (ActivationID)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.actId);
    }
}

