/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class DiffieHellmanImpl
extends KeyAgreementSpi {
    private DHPrivateKey key = null;
    private byte[] result = null;
    private boolean last_phase_done = false;

    protected Key engineDoPhase(Key incoming, boolean lastPhase) throws InvalidKeyException {
        if (this.key == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.last_phase_done) {
            throw new IllegalStateException("Last phase already done");
        }
        if (!(incoming instanceof DHPublicKey)) {
            throw new InvalidKeyException("Key MUST be a DHPublicKey");
        }
        DHPublicKey pub = (DHPublicKey)incoming;
        DHParameterSpec s1 = this.key.getParams();
        DHParameterSpec s2 = pub.getParams();
        if (!s1.getG().equals(s2.getG()) || !s1.getP().equals(s2.getP())) {
            throw new InvalidKeyException("Incompatible key");
        }
        if (!lastPhase) {
            throw new IllegalArgumentException("This key-agreement MUST be concluded in one step only");
        }
        BigInteger resultBI = pub.getY().modPow(this.key.getX(), s1.getP());
        this.result = resultBI.toByteArray();
        if (this.result[0] == 0) {
            byte[] buf = new byte[this.result.length - 1];
            System.arraycopy(this.result, 1, buf, 0, buf.length);
            this.result = buf;
        }
        this.last_phase_done = true;
        return null;
    }

    protected byte[] engineGenerateSecret() {
        this.checkState();
        byte[] res = (byte[])this.result.clone();
        this.reset();
        return res;
    }

    protected int engineGenerateSecret(byte[] secret, int offset) throws ShortBufferException {
        this.checkState();
        if (this.result.length > secret.length - offset) {
            throw new ShortBufferException();
        }
        System.arraycopy(this.result, 0, secret, offset, this.result.length);
        int res = this.result.length;
        this.reset();
        return res;
    }

    protected SecretKey engineGenerateSecret(String algorithm) throws InvalidKeyException {
        this.checkState();
        byte[] s = (byte[])this.result.clone();
        SecretKeySpec res = new SecretKeySpec(s, algorithm);
        this.reset();
        return res;
    }

    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        if (!(key instanceof DHPrivateKey)) {
            throw new InvalidKeyException("Key MUST be a DHPrivateKey");
        }
        this.key = (DHPrivateKey)key;
        this.reset();
    }

    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException {
        this.engineInit(key, random);
    }

    private void reset() {
        this.result = null;
        this.last_phase_done = false;
    }

    private void checkState() {
        if (this.result == null || !this.last_phase_done) {
            throw new IllegalStateException("Not finished");
        }
    }
}

