/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.pad;

import gnu.java.security.Registry;
import gnu.javax.crypto.pad.BasePad;
import gnu.javax.crypto.pad.IPad;
import gnu.javax.crypto.pad.ISO10126;
import gnu.javax.crypto.pad.PKCS1_V1_5;
import gnu.javax.crypto.pad.PKCS7;
import gnu.javax.crypto.pad.SSL3;
import gnu.javax.crypto.pad.TBC;
import gnu.javax.crypto.pad.TLS1;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class PadFactory
implements Registry {
    private static Set names;

    private PadFactory() {
    }

    public static final IPad getInstance(String pad) {
        if (pad == null) {
            return null;
        }
        if ((pad = pad.trim().toLowerCase()).endsWith("padding")) {
            pad = pad.substring(0, pad.length() - "padding".length());
        }
        BasePad result = null;
        if (pad.equals("pkcs7") || pad.equals("pkcs5")) {
            result = new PKCS7();
        } else if (pad.equals("tbc")) {
            result = new TBC();
        } else if (pad.equals("eme-pkcs1-v1.5")) {
            result = new PKCS1_V1_5();
        } else if (pad.equals("ssl3")) {
            result = new SSL3();
        } else if (pad.equals("tls1")) {
            result = new TLS1();
        } else if (pad.equals("iso10126")) {
            result = new ISO10126();
        }
        if (result != null && !result.selfTest()) {
            throw new InternalError(result.name());
        }
        return result;
    }

    public static final Set getNames() {
        if (names == null) {
            HashSet<String> hs = new HashSet<String>();
            hs.add("pkcs5");
            hs.add("pkcs7");
            hs.add("tbc");
            hs.add("eme-pkcs1-v1.5");
            hs.add("ssl3");
            hs.add("tls1");
            hs.add("iso10126");
            names = Collections.unmodifiableSet(hs);
        }
        return names;
    }
}

