/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.dom.DomDocument;
import gnu.xml.dom.ls.ReaderInputStream;
import gnu.xml.dom.ls.SAXEventSink;
import gnu.xml.transform.ErrorListenerErrorHandler;
import gnu.xml.transform.URIResolverEntityResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class XSLURIResolver
implements URIResolver {
    final Map<String, Long> lastModifiedCache = new HashMap<String, Long>();
    final Map<String, Node> nodeCache = new HashMap<String, Node>();
    DocumentBuilder builder;
    URIResolver userResolver;
    ErrorListener userListener;

    XSLURIResolver() {
    }

    void setUserResolver(URIResolver userResolver) {
        this.userResolver = userResolver;
    }

    void setUserListener(ErrorListener userListener) {
        this.userListener = userListener;
    }

    void flush() {
        this.lastModifiedCache.clear();
        this.nodeCache.clear();
    }

    public Source resolve(String href, String base) throws TransformerException {
        Source source = null;
        if (this.userResolver != null) {
            source = this.userResolver.resolve(base, href);
        }
        return this.resolveDOM(source, href, base);
    }

    DOMSource resolveDOM(Source source, String base, String href) throws TransformerException {
        if (source != null && source instanceof DOMSource) {
            return (DOMSource)source;
        }
        String systemId = source == null ? null : source.getSystemId();
        long lastModified = 0L;
        long lastLastModified = 0L;
        try {
            InputSource input;
            Source ss;
            Node node2 = null;
            InputStream in = null;
            if (source != null && source instanceof StreamSource) {
                Reader reader;
                ss = (StreamSource)source;
                in = ((StreamSource)ss).getInputStream();
                if (in == null && (reader = ((StreamSource)ss).getReader()) != null) {
                    in = new ReaderInputStream(reader);
                }
            } else if (source != null && source instanceof SAXSource && (input = ((SAXSource)(ss = (SAXSource)source)).getInputSource()) != null) {
                XMLReader reader;
                if (systemId == null) {
                    systemId = input.getSystemId();
                }
                if ((reader = ((SAXSource)ss).getXMLReader()) != null) {
                    return this.parse(input, reader);
                }
            }
            if (in == null) {
                URL url = this.resolveURL(systemId, base, href);
                if (url != null) {
                    systemId = url.toString();
                    node2 = this.nodeCache.get(systemId);
                    URLConnection conn = url.openConnection();
                    Long llm = this.lastModifiedCache.get(systemId);
                    if (llm != null) {
                        lastLastModified = llm;
                        conn.setIfModifiedSince(lastLastModified);
                    }
                    conn.connect();
                    lastModified = conn.getLastModified();
                    if (node2 != null && lastModified > 0L && lastModified <= lastLastModified) {
                        return new DOMSource(node2, systemId);
                    }
                    in = conn.getInputStream();
                    this.nodeCache.put(systemId, node2);
                    this.lastModifiedCache.put(systemId, new Long(lastModified));
                } else {
                    throw new TransformerException("can't resolve URL: " + systemId);
                }
            }
            InputSource input2 = new InputSource(in);
            input2.setSystemId(systemId);
            DocumentBuilder builder = this.getDocumentBuilder();
            node2 = builder.parse(input2);
            return new DOMSource(node2, systemId);
        }
        catch (IOException e) {
            throw new TransformerException(e);
        }
        catch (SAXException e) {
            throw new TransformerException(e);
        }
    }

    URL resolveURL(String systemId, String base, String href) throws IOException {
        URL url = null;
        try {
            if (systemId != null) {
                try {
                    url = new URL(systemId);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if (url == null) {
                if (base != null) {
                    URL baseURL = new URL(base);
                    url = new URL(baseURL, href);
                } else if (href != null) {
                    url = new URL(href);
                } else {
                    throw new MalformedURLException(systemId);
                }
            }
            return url;
        }
        catch (MalformedURLException malformedURLException) {
            File file = null;
            if (href == null) {
                href = systemId;
            }
            if (base != null) {
                int lsi = base.lastIndexOf(File.separatorChar);
                if (lsi != -1 && lsi < base.length() - 1) {
                    base = base.substring(0, lsi);
                }
                File baseFile = new File(base);
                file = new File(baseFile, href);
            } else if (href != null) {
                file = new File(href);
            }
            return file == null ? null : file.toURL();
        }
    }

    DocumentBuilder getDocumentBuilder() throws TransformerException {
        try {
            if (this.builder == null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setExpandEntityReferences(true);
                this.builder = factory.newDocumentBuilder();
            }
            if (this.userResolver != null) {
                this.builder.setEntityResolver(new URIResolverEntityResolver(this.userResolver));
            }
            if (this.userListener != null) {
                this.builder.setErrorHandler(new ErrorListenerErrorHandler(this.userListener));
            }
            return this.builder;
        }
        catch (Exception e) {
            throw new TransformerException(e);
        }
    }

    DOMSource parse(InputSource source, XMLReader reader) throws SAXException, IOException {
        SAXEventSink eventSink = new SAXEventSink();
        eventSink.setReader(reader);
        eventSink.setNamespaceAware(true);
        reader.setContentHandler(eventSink);
        reader.setDTDHandler(eventSink);
        reader.setProperty("http://xml.org/sax/properties/lexical-handler", eventSink);
        reader.setProperty("http://xml.org/sax/properties/declaration-handler", eventSink);
        reader.parse(source);
        Document doc = eventSink.getDocument();
        String systemId = source.getSystemId();
        if (systemId != null && doc instanceof DomDocument) {
            ((DomDocument)doc).setDocumentURI(systemId);
        }
        return new DOMSource(doc, systemId);
    }
}

