/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class BasicTableHeaderUI
extends TableHeaderUI {
    static int COLUMN_BOUNDARY_TOLERANCE = 3;
    protected JTableHeader header;
    protected MouseInputListener mouseInputListener = this.createMouseInputListener();
    protected CellRendererPane rendererPane;
    private Border cellBorder;
    private Cursor originalCursor;
    Rectangle draggingHeaderRect;

    public static ComponentUI createUI(JComponent h) {
        return new BasicTableHeaderUI();
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.header, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
        this.cellBorder = UIManager.getBorder("TableHeader.cellBorder");
    }

    protected void installKeyboardActions() {
    }

    protected void installListeners() {
        this.header.addMouseListener(this.mouseInputListener);
        this.header.addMouseMotionListener(this.mouseInputListener);
    }

    public void installUI(JComponent c) {
        this.header = (JTableHeader)c;
        this.rendererPane = new CellRendererPane();
        this.installDefaults();
        this.installKeyboardActions();
        this.installListeners();
    }

    protected void uninstallDefaults() {
        this.header.setBackground(null);
        this.header.setForeground(null);
        this.header.setFont(null);
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallListeners() {
        this.header.removeMouseListener(this.mouseInputListener);
        this.header.removeMouseMotionListener(this.mouseInputListener);
    }

    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallDefaults();
    }

    public void paint(Graphics gfx, JComponent c) {
        TableColumnModel cmod = this.header.getColumnModel();
        int ncols = cmod.getColumnCount();
        if (ncols == 0) {
            return;
        }
        Rectangle clip = gfx.getClipBounds();
        TableCellRenderer defaultRend = this.header.getDefaultRenderer();
        int i = 0;
        while (i < ncols) {
            Rectangle bounds = this.header.getHeaderRect(i);
            if (bounds.intersects(clip)) {
                gfx.getClipBounds();
                TableColumn col = cmod.getColumn(i);
                TableCellRenderer rend = col.getHeaderRenderer();
                if (rend == null) {
                    rend = defaultRend;
                }
                Object val = col.getHeaderValue();
                Component comp = rend.getTableCellRendererComponent(this.header.getTable(), val, false, false, -1, i);
                comp.setFont(this.header.getFont());
                comp.setBackground(this.header.getBackground());
                comp.setForeground(this.header.getForeground());
                if (comp instanceof JComponent) {
                    ((JComponent)comp).setBorder(this.cellBorder);
                }
                this.rendererPane.paintComponent(gfx, comp, this.header, bounds.x, bounds.y, bounds.width, bounds.height);
            }
            ++i;
        }
        if (this.draggingHeaderRect != null) {
            gfx.setColor(this.header.getForeground());
            gfx.drawRect(this.draggingHeaderRect.x, this.draggingHeaderRect.y + 2, this.draggingHeaderRect.width - 1, this.draggingHeaderRect.height - 6);
        }
    }

    public Dimension getPreferredSize(JComponent ignored) {
        TableColumnModel cmod = this.header.getColumnModel();
        TableCellRenderer defaultRend = this.header.getDefaultRenderer();
        int ncols = cmod.getColumnCount();
        Dimension ret = new Dimension(0, 0);
        int spacing = 0;
        if (this.header.getTable() != null && this.header.getTable().getIntercellSpacing() != null) {
            spacing = this.header.getTable().getIntercellSpacing().width;
        }
        int i = 0;
        while (i < ncols) {
            TableColumn col = cmod.getColumn(i);
            TableCellRenderer rend = col.getHeaderRenderer();
            if (rend == null) {
                rend = defaultRend;
            }
            Object val = col.getHeaderValue();
            Component comp = rend.getTableCellRendererComponent(this.header.getTable(), val, false, false, -1, i);
            comp.setFont(this.header.getFont());
            comp.setBackground(this.header.getBackground());
            comp.setForeground(this.header.getForeground());
            if (comp instanceof JComponent) {
                ((JComponent)comp).setBorder(this.cellBorder);
            }
            Dimension d = comp.getPreferredSize();
            ret.width += spacing;
            ret.height = Math.max(d.height, ret.height);
            ++i;
        }
        ret.width = cmod.getTotalColumnWidth();
        return ret;
    }

    public class MouseInputHandler
    implements MouseInputListener {
        boolean showingResizeCursor;
        int draggingFrom = -1;
        int draggingColumnNumber;
        int prevPrefWidth = -1;
        Timer timer;

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            TableColumn resizeIt = BasicTableHeaderUI.this.header.getResizingColumn();
            if (resizeIt != null && BasicTableHeaderUI.this.header.getResizingAllowed()) {
                if (this.timer == null) {
                    this.timer = new Timer(1, new ActionListener(this){
                        final /* synthetic */ MouseInputHandler this$1;
                        {
                            this.this$1 = mouseInputHandler;
                        }

                        public void actionPerformed(ActionEvent e) {
                            MouseInputHandler.access$0((MouseInputHandler)this.this$1).header.getTable().doLayout();
                        }
                    });
                    this.timer.setRepeats(false);
                    this.timer.setCoalesce(true);
                }
                resizeIt.setPreferredWidth(this.prevPrefWidth + e.getX() - this.draggingFrom);
                this.timer.restart();
            } else if (BasicTableHeaderUI.this.draggingHeaderRect != null && BasicTableHeaderUI.this.header.getReorderingAllowed()) {
                BasicTableHeaderUI.this.draggingHeaderRect.x = e.getX() + this.draggingFrom;
                BasicTableHeaderUI.this.header.repaint();
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            if (e.getButton() == 0 && BasicTableHeaderUI.this.header.getResizingAllowed()) {
                TableColumnModel model = BasicTableHeaderUI.this.header.getColumnModel();
                int n = model.getColumnCount();
                if (n < 2) {
                    return;
                }
                boolean onBoundary = false;
                int x = e.getX();
                int a = x - COLUMN_BOUNDARY_TOLERANCE;
                int b = x + COLUMN_BOUNDARY_TOLERANCE;
                int p = 0;
                int i = 0;
                while (i < n - 1) {
                    if ((p += model.getColumn(i).getWidth()) >= a && p <= b) {
                        TableColumn column = model.getColumn(i);
                        onBoundary = true;
                        this.draggingFrom = x;
                        this.prevPrefWidth = column.getWidth();
                        BasicTableHeaderUI.this.header.setResizingColumn(column);
                        break;
                    }
                    ++i;
                }
                if (onBoundary != this.showingResizeCursor) {
                    if (onBoundary) {
                        BasicTableHeaderUI.this.originalCursor = BasicTableHeaderUI.this.header.getCursor();
                        if (p < x) {
                            BasicTableHeaderUI.this.header.setCursor(Cursor.getPredefinedCursor(10));
                        } else {
                            BasicTableHeaderUI.this.header.setCursor(Cursor.getPredefinedCursor(11));
                        }
                    } else {
                        BasicTableHeaderUI.this.header.setCursor(BasicTableHeaderUI.this.originalCursor);
                        BasicTableHeaderUI.this.header.setResizingColumn(null);
                    }
                    this.showingResizeCursor = onBoundary;
                }
            }
        }

        public void mousePressed(MouseEvent e) {
            TableColumn resizingColumn;
            if (BasicTableHeaderUI.this.header.getResizingAllowed() && (resizingColumn = BasicTableHeaderUI.this.header.getResizingColumn()) != null) {
                resizingColumn.setPreferredWidth(resizingColumn.getWidth());
                return;
            }
            if (BasicTableHeaderUI.this.header.getReorderingAllowed()) {
                TableColumnModel model = BasicTableHeaderUI.this.header.getColumnModel();
                int n = model.getColumnCount();
                if (n < 2) {
                    return;
                }
                int x = e.getX();
                int p = 0;
                int col = -1;
                int i = 0;
                while (i < n) {
                    if ((p += model.getColumn(i).getWidth()) > x) {
                        col = i;
                        break;
                    }
                    ++i;
                }
                if (col < 0) {
                    return;
                }
                TableColumn dragIt = model.getColumn(col);
                BasicTableHeaderUI.this.header.setDraggedColumn(dragIt);
                this.draggingFrom = p - dragIt.getWidth() - x;
                BasicTableHeaderUI.this.draggingHeaderRect = new Rectangle(BasicTableHeaderUI.this.header.getHeaderRect(col));
                this.draggingColumnNumber = col;
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (BasicTableHeaderUI.this.header.getResizingColumn() != null && BasicTableHeaderUI.this.header.getResizingAllowed()) {
                this.endResizing();
            }
            if (BasicTableHeaderUI.this.header.getDraggedColumn() != null && BasicTableHeaderUI.this.header.getReorderingAllowed()) {
                this.endDragging(e);
            }
        }

        void endResizing() {
            TableColumnModel model = BasicTableHeaderUI.this.header.getColumnModel();
            int n = model.getColumnCount();
            if (n > 2) {
                int i = 0;
                while (i < n) {
                    TableColumn c = model.getColumn(i);
                    c.setPreferredWidth(c.getWidth());
                    ++i;
                }
            }
            BasicTableHeaderUI.this.header.setResizingColumn(null);
            this.showingResizeCursor = false;
            if (this.timer != null) {
                this.timer.stop();
            }
            BasicTableHeaderUI.this.header.setCursor(BasicTableHeaderUI.this.originalCursor);
        }

        void endDragging(MouseEvent e) {
            BasicTableHeaderUI.this.header.setDraggedColumn(null);
            BasicTableHeaderUI.this.draggingHeaderRect = null;
            TableColumnModel model = BasicTableHeaderUI.this.header.getColumnModel();
            int x = e.getX();
            int p = 0;
            int col = model.getColumnCount() - 1;
            int n = model.getColumnCount();
            int i = 0;
            while (i < n) {
                if ((p += model.getColumn(i).getWidth()) > x) {
                    col = i;
                    break;
                }
                ++i;
            }
            BasicTableHeaderUI.this.header.getTable().moveColumn(this.draggingColumnNumber, col);
        }

        static /* synthetic */ BasicTableHeaderUI access$0(MouseInputHandler mouseInputHandler) {
            return mouseInputHandler.BasicTableHeaderUI.this;
        }
    }
}

