/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.gjdoc;

import gnu.classpath.tools.gjdoc.Debug;
import gnu.classpath.tools.gjdoc.ParseException;
import gnu.classpath.tools.gjdoc.Parser;
import gnu.classpath.tools.gjdoc.SourceComponent;
import java.io.IOException;

class ClassComponent
extends SourceComponent {
    ClassComponent() {
    }

    int match(char[] source, int index) {
        boolean isClass = false;
        while (index < source.length && !isClass) {
            block0 : switch (source[index]) {
                case '/': {
                    if (index >= source.length - 1) break;
                    char c = source[index + 1];
                    if ('/' == c) {
                        index += 2;
                        while (index < source.length && source[index] != '\n') {
                            ++index;
                        }
                    } else {
                        if ('*' != c) break;
                        index += 3;
                        while (index < source.length && (source[index - 1] != '*' || source[index] != '/')) {
                            ++index;
                        }
                    }
                    break;
                }
                case '@': {
                    ++index;
                    while (index < source.length && Character.isJavaIdentifierPart(source[index])) {
                        ++index;
                    }
                    if (index >= source.length || source[index] != '(') break;
                    int parLevel = 1;
                    ++index;
                    while (index < source.length && parLevel > 0) {
                        if (source[index] == '(') {
                            ++parLevel;
                        }
                        if (source[index] == ')') {
                            --parLevel;
                        }
                        ++index;
                        if (parLevel == 0) break block0;
                    }
                    break;
                }
                case '(': 
                case ';': 
                case '=': {
                    return -1;
                }
                case '{': {
                    isClass = true;
                }
            }
            if (isClass) break;
            ++index;
        }
        if (!isClass || index >= source.length) {
            return -1;
        }
        return index + 1;
    }

    int process(Parser parser, char[] source, int startIndex, int endIndex) throws ParseException, IOException {
        parser.classOpened(source, startIndex, endIndex);
        if (parser.getAddComments()) {
            parser.ctx.classDoc.setRawCommentText(parser.getLastComment());
        }
        parser.setLastComment(null);
        if (parser.ctx.classDoc.isEnum()) {
            int depth = 0;
            int a = endIndex;
            while (a < source.length) {
                Debug.log(9, "Enum skipping " + a);
                if (source[a] == '{') {
                    Debug.log(1, "Found inner { in enum");
                    ++depth;
                }
                if (source[a] == '}') {
                    if (depth > 0) {
                        Debug.log(1, "Found inner } in enum");
                        --depth;
                    } else {
                        Debug.log(1, "Found enum }");
                        parser.classClosed();
                        return a + 1;
                    }
                }
                ++a;
            }
        }
        int rc = parser.parse(source, endIndex, parser.getClassLevelComponents());
        return rc;
    }
}

