/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.gjdoc.expr;

import gnu.classpath.tools.gjdoc.expr.ConstantBoolean;
import gnu.classpath.tools.gjdoc.expr.ConstantExpression;
import gnu.classpath.tools.gjdoc.expr.Context;
import gnu.classpath.tools.gjdoc.expr.Expression;
import gnu.classpath.tools.gjdoc.expr.IllegalExpressionException;
import gnu.classpath.tools.gjdoc.expr.Type;

class ConditionalExpression
implements Expression {
    private Expression condition;
    private Expression ifTrue;
    private Expression ifFalse;

    ConditionalExpression(Expression condition, Expression ifTrue, Expression ifFalse) {
        this.condition = condition;
        this.ifTrue = ifTrue;
        this.ifFalse = ifFalse;
    }

    public ConstantExpression evaluate(Context context) throws IllegalExpressionException {
        ConstantExpression conditionValue = this.condition.evaluate(context);
        ConstantExpression ifTrueValue = this.ifTrue.evaluate(context);
        ConstantExpression ifFalseValue = this.ifFalse.evaluate(context);
        if (Type.BOOLEAN != conditionValue.getType()) {
            throw new IllegalExpressionException("condition must be boolean");
        }
        boolean cond = ((ConstantBoolean)conditionValue).booleanValue();
        if (cond) {
            return ifTrueValue;
        }
        return ifFalseValue;
    }
}

