/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.rmic;

import java.util.HashMap;
import java.util.HashSet;

class Variables {
    private final HashSet<Integer> free = new HashSet();
    private final HashMap<Object, Integer> names = new HashMap();
    private final HashSet<Object> wides = new HashSet();
    private final HashSet<Object> declared = new HashSet();
    private boolean allocated = false;

    Variables() {
    }

    public void declare(Object name) {
        this.declare(name, 1);
    }

    public void declareWide(Object name) {
        this.declare(name, 2);
    }

    public void declare(Object name, int size) {
        if (this.allocated) {
            throw new IllegalStateException("cannot declare after allocating");
        }
        if (size != 1 && size != 2) {
            throw new IllegalArgumentException("size must be 1 or 2");
        }
        if (this.names.containsKey(name)) {
            throw new IllegalStateException("already allocated " + name);
        }
        this.allocateNew(name, size);
        this.declared.add(name);
    }

    private int allocateNew(Object name, int size) {
        int i = this.free.size() + this.names.size() + this.wides.size();
        this.names.put(name, i);
        if (size == 2) {
            this.wides.add(name);
        }
        return i;
    }

    public int allocate(Object name) {
        return this.allocate(name, 1);
    }

    public int allocateWide(Object name) {
        return this.allocate(name, 2);
    }

    public int allocate(Object name, int size) {
        this.allocated = true;
        if (size != 1 && size != 2) {
            throw new IllegalArgumentException("size must be 1 or 2");
        }
        if (this.names.containsKey(name)) {
            throw new IllegalStateException("already allocated " + name);
        }
        if (size == 2) {
            for (Integer i : this.free) {
                Integer next = i + 1;
                if (!this.free.contains(next)) continue;
                this.free.remove(i);
                this.free.remove(next);
                this.wides.add(name);
                this.names.put(name, i);
                return i;
            }
        } else if (this.free.size() > 0) {
            Integer i = this.free.iterator().next();
            this.free.remove(i);
            this.names.put(name, i);
            return i;
        }
        return this.allocateNew(name, size);
    }

    public int deallocate(Object name) {
        if (!this.names.containsKey(name)) {
            throw new IllegalArgumentException("no variable " + name);
        }
        if (this.declared.contains(name)) {
            throw new IllegalStateException(name + " can't be deallocated");
        }
        Integer i = this.names.get(name);
        this.names.remove(name);
        this.free.add(i);
        if (this.wides.remove(name)) {
            this.free.add(i + 1);
        }
        return i;
    }

    public int get(Object name) {
        if (!this.names.containsKey(name)) {
            throw new IllegalArgumentException("no variable " + name);
        }
        return this.names.get(name);
    }
}

