package com.dickimawbooks.jmakepdfx;

public class PdfInfoProcessListener extends DefaultProcessListener
{
   public PdfInfoProcessListener(Jmakepdfx application)
   {
      super(application);
   }

   public void processLine(int lineNum, String line)
   {
      Jmakepdfx.debug(line);

      if (line.startsWith("Error:"))
      {
         errMessage = line;
         return;
      }

      if (errMessage != null)
      {
         return;
      }

      switch (lineNum)
      {
         case 1:
           title = line;
         break;
         case 2:
           author = line;
         break;
         case 3:
           try
           {
              pageCount = Integer.parseInt(line);
           }
           catch (NumberFormatException e)
           {
           }
         break;
      }
   }

   public String getAuthor()
   {
      return author;
   }

   public String getTitle()
   {
      return title;
   }

   public int getPageCount()
   {
      return pageCount;
   }

   public String getErrorMessage()
   {
      return errMessage;
   }

   private String author, title;
   private int pageCount=-1;

   private String errMessage = null;
}
