#! /bin/sh
# Make a binary distribution of an sgmls installation.  The .tar.gz
# file is created in the current directory.
#
# Usage:
#	MAKE-SGMLS-BINARY-DISTRIBUTION.sh
#
# [02-Nov-1999]

# Where the installed files are:
PREFIX=/usr/local

# Use rcp instead of scp, because not all local systems have the latter yet (e.g. jwb104a)
RCP=rcp

DISTMANFILES="
	man/man1/html-check.1	\
	man/man1/sgmls.1	\
	man/man1/sgmlsasp.1	\
	man/man1/rast.1		\
	"

DISTBINFILES="
	bin/html-check		\
	bin/sgmls		\
	bin/sgmlsasp		\
	bin/rast		\
	"

SRCDIR=/usr/local/src/sgmls

DISTDOCFILES="
	LICENSE			\
	README			\
	"

DISTLIBFILES="share/lib/html-check/lib/*"

DISTDIR=$PWD
TMPDIST=sgmls.bin.`uname -s -r -m | sed -e 's@[/ ]@-@g'`

/bin/rm -fr $TMPDIST

mkdir $TMPDIST $TMPDIST/bin $TMPDIST/sgmls-doc $TMPDIST/man \
	$TMPDIST/share \
	$TMPDIST/share/lib \
	$TMPDIST/share/lib/html-check \
	$TMPDIST/share/lib/html-check/lib

(cd $PREFIX; $RCP -p $DISTBINFILES $DISTDIR/$TMPDIST/bin/ )
(cd $PREFIX; $RCP -p $DISTLIBFILES $DISTDIR/$TMPDIST/share/lib/html-check/lib )
(cd $PREFIX; $RCP -p $DISTMANFILES $DISTDIR/$TMPDIST/man/ )
(cd $SRCDIR; $RCP -p $DISTDOCFILES $DISTDIR/$TMPDIST/sgmls-doc/ )

/bin/rm -f $TMPDIST.tar $TMPDIST.tar.Z $TMPDIST.tar.gz

TARFILE=$TMPDIST.tar

tar cf $TARFILE $TMPDIST
/bin/rm -rf $TMPDIST

tar tvf $TARFILE

echo ""
ls -l $TARFILE
gzip $TARFILE
ls -l $TARFILE.gz
