%%
%% This is file `aeskwadraatnotulen.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% aeskwadraat.dtx  (with options: `notulencls')
%% 
%% Copyright (c) 2024- TeXniCie A-Eskwadraat (voorheen HekTeX) <texnicie@a-eskwadraat.nl>
%% 
%% This program is free software: you can redistribute it and/or modify
%% it under the terms of the GNU General Public License as published by
%% the Free Software Foundation, either version 3 of the License, or
%% (at your option) any later version.
%% 
%% This program is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%% GNU General Public License for more details.
%% 
%% You should have received a copy of the GNU General Public License
%% along with this program.  If not, see <https://www.gnu.org/licenses/>.
%% 
%% The current maintainer of this work is Jesse Sraat.
%% 
%% This work consists of the main file aeskwadraat.dtx
%% and the derived files
%%     aeskwadraat.sty, aes.sty, aeskwadraat.pdf, aeskwadraat.ins, aeskwadraatbrief.cls, aeskwadraatfactuur.sty, aeskwadraatnotulen.cls,
%%     aeskwadraatnotulen.sty, aeskwadraattaal.sty, beamerthemeaeskwadraat.sty, beamerthemeaes2.sty
%% 
%% If you are looking for comments or documentation, you won't find
%% any in the source. These packages make use of literate programming, which means
%% that the documentation is given in the form of a pdf file. You can
%% probably find aeskwadraat.pdf in this folder, by running "texdoc --view aeskwadraat"
%% in the command line, or Googling
%% "[your distribution] how to find package documentation".
%% If you're using MiKTeX, open MiKTeX console, go to
%% "Documentation" and look for "aeskwadraat".
%% If you're still unsure, contact the TeXniCie at <texnicie@a-eskwadraat.nl>
%% 

\NeedsTeXFormat{LaTeX2e}[2021/11/15]
\ProvidesClass{aeskwadraatnotulen}[2025/06/13 v1.0.1 A-Eskwadraat notulen package]
\DeclareOption{english}{\PassOptionsToPackage{english}{aeskwadraatnotulen}}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions\relax

\LoadClass[a4paper,11pt]{article}

\RequirePackage{aeskwadraatnotulen}
\RequirePackage{fancyhdr, lineno}
\RequirePackage{newtxtext}
\renewcommand{\familydefault}{\sfdefault}

\if@twoside
  \setlength{\oddsidemargin} {20mm}
  \setlength{\evensidemargin} {10mm}
\else
  \setlength{\oddsidemargin} {15mm}
  \setlength{\evensidemargin} {15mm}
\fi

\setlength{\hoffset} {-1in}
\setlength{\voffset} {-1in}

\setlength{\textwidth} {180mm}
\setlength{\textheight} {240mm}
\setlength{\topmargin} {10mm}
\setlength{\headheight} {1.5em}
\setlength{\headsep} {2em}
\setlength{\footskip} {4em}

\setlength{\parindent} {0em}
\setlength{\parskip} {0em}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\pagestyle{fancy}

\lhead{\@title}
\chead{}
\rhead{\@date}
\lfoot{}
\cfoot{\thepage}
\rfoot{}

\renewcommand{\headrulewidth}{0.4pt}
\renewcommand{\footrulewidth}{0.0pt}

\pagenumbering{Roman}

\modulolinenumbers[5]

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\setcounter{secnumdepth}{1}
\setcounter{tocdepth}{2}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\renewcommand{\section}{
  \@startsection{section}{1}{\z@}
    {-2.5ex \@plus -1ex \@minus -.2ex}
    {1.3ex \@plus.2ex}
    {\normalfont\Large\bfseries}}
\renewcommand{\subsection}{
  \@startsection{subsection}{2}{\z@}
    {-1.25ex\@plus -1ex \@minus -.2ex}
    {0.5ex \@plus .2ex}
    {\normalfont\large\itshape}}
\renewcommand{\subsubsection}{
  \@startsection{subsubsection}{3}{\z@}
    {-1.00ex \@plus -0.50ex \@minus -0.50ex}
    {-1.00ex \@plus -0.50ex \@minus -0.50ex}
    {\normalfont\normalsize\itshape\bfseries}}
\renewcommand{\paragraph}{
  \@startsection{paragraph}{4}{\z@}
    {0.00ex \@plus0.1ex}
    {-1em}
    {\normalfont\normalsize\nameshape}}
\let\titel\title
\let\datum\date
\DeclareDocumentCommand{\@title}{}{\ifeng@art Meeting records
\ClassWarning{aes-notulen}{no \title given}
\else Notulen \ClassWarning{aes-notulen}{geen \title ingevoerd} \fi}
\DeclareDocumentCommand{\@date}{}{\today  \ifeng@art
    \ClassWarning{aes-notulen}{no \date given}
    \else \ClassWarning{aes-notulen}{geen \date ingevoerd}
    \fi}
\def\@maketitle{%
  \newpage
  \null
  \vskip 2em%
  \begin{center}%
  \let \footnote \thanks
    {\LARGE \@title \par}%
    \vskip 1.5em%
    {\large
     \lineskip .75em%
      \begin{tabular}[t]{c}%
        \@author
      \end{tabular}\par ~\newline \naamzet }% We removed the author here
    \vskip 1em%
    {\large \@date}%
  \end{center}%
  \par
  \vskip 1.5em}
\endinput
%%
%% End of file `aeskwadraatnotulen.cls'.
