%%
%% This is file `tudasciposter.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% tudasciposter.dtx  (with options: `class,initialization')
%% tuda-ci.dtx  (with options: `options,sciposter,print,pdfa')
%% tudasciposter.dtx  (with options: `class,packages')
%% tuda-ci.dtx  (with options: `pdfx')
%% tudasciposter.dtx  (with options: `class,body')
%% tuda-ci.dtx  (with options: `xmpdata')
%% 
%% it is part of
%% TUDa-CI -- Corporate Design for TU Darmstadt
%% 
%% ----------------------------------------------------------------------------
%% 
%%   Copyright (C) 2018--2025 by Marei Peischl <marei@peitex.de>
%% 
%% ============================================================================
%% This work may be distributed and/or modified under the
%% conditions of the LaTeX Project Public License, either version 1.3c
%% of this license or (at your option) any later version.
%% The latest version of this license is in
%% http://www.latex-project.org/lppl.txt
%% and version 1.3c or later is part of all distributions of LaTeX
%% version 2008/05/04 or later.
%% 
%% This work has the LPPL maintenance status `maintained'.
%% 
%% The Current Maintainer of this work is
%%   Marei Peischl <tuda-ci@peitex.de>
%% 
%% The development repository can be found at
%% https://github.com/tudace/tuda_latex_templates
%% Please use the issue tracker for feedback!
%% 
%% ============================================================================
%% 
\NeedsTeXFormat{LaTeX2e}[2022/06/01]
\ProvidesExplClass{tudasciposter}{2025-11-13}{4.05}{Scientific Poster Layout for TU Darmstadt}
\prop_new:N \g_ptxcd_clsopts_prop
\tl_new:N \g_ptxcd_boxstyle_tl
\int_new:N \g_ptxcd_paper_int
\str_new:N \g_ptxcd_department_str
\str_const:Nn \c__ptxcd_base_str {sciposter}
\keys_define:nn {ptxcd/poster} {
  titletext .code:n = {\PassOptionsToPackage{text =#1}{tudacolors}},
  footer .bool_gset:N = \g_ptxcd_poster_foot_bool,
  footer .default:n = true,
  footer .initial:n = true,
  thanks .tl_gset:N = \g_ptxcd_footnote_label_tl,
  thanks .initial:n = arabic*,
  boxstyle .choice:,
  boxstyle / official .code:n = \tl_gset:Nn \g_ptxcd_boxstyle_tl {TUDa},
  boxstyle / colored .code:n= \tl_gset:Nn \g_ptxcd_boxstyle_tl {TUDa-colored},
  boxstyle / boxed .code:n= \tl_gset:Nn \g_ptxcd_boxstyle_tl {TUDa-boxed},
  boxstyle /default .meta:n = {boxstyle=official},
  boxstyle .initial:n = default,
  unknown .code:n = {\prop_gput:NVn \g_ptxcd_clsopts_prop \l_keys_key_tl {#1}},
  fontsize .tl_gset:N = \g_ptxcd_fontsize_tl,
  titlesepline .bool_gset:N = \g_ptxcd_titlesepline_bool,
  titlesepline .initial:n = true,
  logofile .tl_gset:N = \g_ptxcd_logofile_tl,
  logofile .initial:n = tuda_logo,
  accept-missing-logos .bool_gset:N = \g_ptxcd_logo_workaround_bool,
  accept-missing-logos .initial:n = false,
  accept-missing-logos .usage:n = load,
  accept-missing-logos .default:n = true,
  department .choice:,
  department / default .code:n = \str_gset:Nn \g_ptxcd_department_str {default},
  department / mecheng .code:n = {
      \str_gset:Nn \g_ptxcd_department_str {mecheng}
      \exp_args:Ne \keys_set:ne {

        ptxcd / poster
      }{
        colorback=false,
        departmentlogofile=tuda_maschinenbau_logo,
        titlesepline=false
      }
    },

  department .initial:n = default,
  department / unknown .code:n = {
      \str_gset:Nx \g_ptxcd_department_str {\l_keys_value_tl}
    },
  departmentconfigprefix .tl_gset:N = \g__ptxcd_config_prefix_tl,
  departmentconfigprefix .initial:n = tuda,
  departmentlogofile .tl_gset:N = \g_ptxcd_departmentlogo_tl,
  departmentlogofile .initial:n =,
  mecheng .meta:n = {department=mecheng},
  pdfa .bool_gset:N = \g_ptxcd_pdfa_bool,
  pdfa .initial:n =
  false,
  pdfx .bool_gset:N = \g_ptxcd_pdfx_bool,
  pdfx .initial:n = true,
%% color options
%% color options
  color .meta:n = {accentcolor=#1},
  accentcolor .code:n = {\PassOptionsToPackage{accentcolor=#1}{tudacolors}},
  textaccentcolor .code:n = {\PassOptionsToPackage{textaccentcolor=#1}{tudacolors}},
  identbarcolor .code:n = {\PassOptionsToPackage{identbarcolor=#1}{tudacolors}},
  colorback .bool_gset:N = \g_ptxcd_colorback_bool,
  colorback .default:n = true,
  colorback .initial:n = true,
  paper .choices:nn = {
      a0,a1,a2,a3
  }{
  \int_gset_eq:NN \g_ptxcd_paper_int  \l_keys_choice_int
  \exp_args:Nx \PassOptionsToPackage{paper=\l_keys_choice_tl}{tudarules}
      \exp_args:Nx \PassOptionsToPackage{\l_keys_choice_tl paper}{geometry}
  },
  paper / landscape .code:n = \PassOptionsToPackage{landscape}{geometry},

  paper / portrait .code:n = \PassOptionsToPackage{portrait}{geometry},
  paper .initial:n =

  a0,
  title .choice:,
  title / default .meta:n = {title=large},
  title / large .code:n = \bool_gset_false:N \g_ptxcd_smalltitle_bool,
  title / small  .code:n = \bool_gset_true:N \g_ptxcd_smalltitle_bool,
  title .initial:n = default,
}
\cs_if_exist:NT \TUDaDefaultBuildOptions {
  \exp_args:Ne \keys_set:ne { ptxcd /
    poster
  } {
    \TUDaDefaultBuildOptions
  }
}
\cs_new:Nn \__ptxcd_insert_logo: {
  \bool_if:NTF \g_ptxcd_logo_workaround_bool {
    \file_if_exist:nTF {\g_ptxcd_logofile_tl.pdf}
    \use_ii:nn
    \use_i:nn
  } {
    \use_ii:nn
  }
  {\rule{0pt}{\c_ptxcd_logoheight_dim}\makebox[2.5\c_ptxcd_logoheight_dim][c]{\rule[.1\c_ptxcd_logoheight_dim]{2.05\c_ptxcd_logoheight_dim}{.8\c_ptxcd_logoheight_dim}}}
  {\includegraphics[height=\c_ptxcd_logoheight_dim]{\g_ptxcd_logofile_tl}}
}

\bool_if:NF \g_ptxcd_pdfa_bool {\bool_gset_false:N \g_ptxcd_pdfx_bool}

\bool_if:NT \g_ptxcd_pdfa_bool {
  \msg_new:nnn {tudapub} {colors-to-rgb} {
    You~did~not~add~a~color~profile.\\
    I~will~use~the~default~one~and~automatically~try~to~convert~internal~colors~to~RGB.\\
    This~is~required~to~be~able~to~create~PDF/A~compliance.
  }

  \cs_if_exist:NT \pdfmeta_standard_get:nN {
    \pdfmeta_standard_get:nN  {outputintent_A} \l_tmpa_tl
    \quark_if_no_value:NF \l_tmpa_tl  {
      \bool_gset_false:N \g_ptxcd_pdfx_bool
      \msg_new:nnn{tudapub} {pdfmanagement-detected} {
        I~detected~usage~of~l3pdfmeta~(\DocumentMetadata)~to~create~PDF/A.\\
        tudapub~will~not~load~pdfx~to~avoid~conflicts.\\
        To~disable~this~message~use~pdfx=false.
      }
      \msg_info:nn {tudapub} {pdfmanagement-detected}
    }
    \prop_if_in:NnF \g__pdfmeta_outputintents_prop {GTS_PDFA1} {
      \use_iii:nnn
    }
  }
  \bool_if:NT \g_ptxcd_pdfx_bool {
    \PassOptionsToPackage{RGB}{xcolor}
    \msg_info:nn {tudapub} {colors-to-rgb}
  }
}

\ProcessKeyOptions[ptxcd/poster]
\dim_new:N \g_ptxcd_margin_dim
\bool_if:NTF \g_ptxcd_smalltitle_bool {
  \file_input:n {tuda-a\int_use:N \g_ptxcd_paper_int paper.clo}
  \ptxcd_setup_title_sizes:
  \file_input:n {tuda-a\int_use:N \g_ptxcd_paper_int paper.clo}
  \ptxcd_setup_base_sizes:
}{
  \int_gdecr:N \g_ptxcd_paper_int
  \file_input:n {tuda-a\int_use:N \g_ptxcd_paper_int paper.clo}
  \ptxcd_setup_title_sizes:
  \ptxcd_setup_base_sizes:
}
\prop_gput:NnV \g_ptxcd_clsopts_prop {fontsize} \g_ptxcd_fontsize_tl
\prop_map_inline:Nn \g_ptxcd_clsopts_prop {
  \tl_if_empty:nTF {#2}
  {\PassOptionsToClass{#1}{scrartcl}}
  {\clist_map_inline:nn {#2} {\PassOptionsToClass{#1=##1}{scrartcl}}}
}
\ExplSyntaxOff
\PassOptionsToPackage{typeareawarninfolimit=-1,DIV=10}{typearea}
\LoadClass[parskip=full-]{scrartcl}
\ExplSyntaxOn
\PassOptionsToPackage{hidelinks, unicode}{hyperref}
\bool_if:NT \g_ptxcd_pdfx_bool {
%% only apply the hack if pdfx is older than the working version
  \PassOptionsToPackage{a-2b}{pdfx}
%% Workaround posted by David Carlisle on tex.stackexchange
%% Thanks to Ulrike Fischer for mentioning it in #472
  \let \__ptxcd_grouplevel_before_pdfx: \currentgrouplevel
  \chardef\currentgrouplevel0
  \ExplSyntaxOff
  \RequirePackage{pdfx}
  \ExplSyntaxOn
  \let \currentgrouplevel \__ptxcd_grouplevel_before_pdfx:
  \cs_undefine:N \__ptxcd_grouplevel_before_pdfx:
%% end of the workaround

  \msg_new:nnn{tuda-ci} {prefer-lualatex} {
    You~use~pdfa-mode~in~#1.\\
    This~can~lead~to~incompatiblities~especially~with~older~compiler~versions.\\
    You~should~prefer~using~lualatex.
  }
  \msg_new:nnnn{tuda-ci} {outdated-package-pdfa} {
    Your~Version~of~the~#1-package~is~too~old~to~support~all~methods~required~by~tudapubs~pdfa-mode.\\
    Either~update~your~TeX-distribution~or~switch~to~pdfa=false.
  }{See~DEMO-tudapub~for~further~information.}

  \sys_if_engine_pdftex:T {
    \msg_warning:nnn{tuda-ci} {prefer-lualatex} {PDFTeX}
  }

  \sys_if_engine_xetex:T {
    \msg_warning:nnn{tuda-ci} {prefer-lualatex} {XeTeX}
  }
  \@ifpackageloaded{pdfx}{}{
      \msg_new:nnnn {tuda-ci} {pdfx-not-loaded} {
  The~pdfx~package~was~not~loaded.\\
  You~probably~used~\DocumentMetadata~but~did~not~select~PDF/A.\\
  I disable~pdfa~due~to~that~incompatiblity.
      } {Select~the~standard~using~the~pdfmanagement~to~enable~PDF/A~or~set~pdfa=false~to~disable~this~message.}
      \msg_error:nn {tuda-ci}{pdfx-not-loaded}
      \bool_gset_false:N \g_ptxcd_pdfx_bool
      \bool_gset_false:N \g_ptxcd_pdfa_bool
  }
  \@ifpackageloaded{xmpincl}{
      \@ifpackagelater{xmpincl}{2021/09/22}{}{
  \msg_error:nnn{tuda-ci}  {outdated-package-pdfa} {xmpincl}
      }
  }{}
}
\bool_if:NF \g_ptxcd_pdfx_bool {
  \RequirePackage{hyperref}
}
\ExplSyntaxOff
\RequirePackage{tudafonts}
\RequirePackage{tudacolors}
\RequirePackage[margin=0pt]{geometry}
\RequirePackage{tcolorbox}
\tcbuselibrary{poster}
\RequirePackage[mode=tikz]{tudarules}
\RequirePackage{qrcode}
\ExplSyntaxOn

\renewcommand*{\familydefault}{\sfdefault}
\setkomafont{title}{
  \color{titlefgcolor}
  \expandafter\fontsize\ptxcd_title_fontsize:\selectfont
  \bfseries
}
\setkomafont{author}{\bfseries}
\setkomafont{captionlabel}{\bfseries}
\setkomafont{disposition}{\sffamily\bfseries}
\dim_const:Nn \c_ptxcd_headrule_ht_dim {\c_ptxcd_rulesep_dim +\c_ptxcd_largerule_dim + \c_ptxcd_smallrule_dim}
\box_new:N \l_ptxcd_tmpa_box
\box_new:N \g_ptxcd_titlegraphic_box
\box_new:N \g_ptxcd_title_box
\box_new:N \g_ptxcd_author_box
\box_new:N \g_ptxcd_credit_box
\tl_new:N \g_ptxcd_thanks_tl
\newcommand*{\ptxcd_title@footnote}[2][1]{
  \begingroup
  \ptxcd_def_footnotelabel:
  \footnotemark[#1]\,#2\quad
  \endgroup
}
\tl_greplace_all:Nnn \g_ptxcd_footnote_label_tl {*} {{footnote}}
\clist_map_inline:nn {alph, arabic, fnsymbol, Alph, roman, Roman} {
  \tl_greplace_all:Nnn \g_ptxcd_footnote_label_tl {#1} {\use:c {#1}}
}
\cs_set:Nn \ptxcd_def_footnotelabel: {
  \renewcommand*{\thefootnote}{\g_ptxcd_footnote_label_tl}
}
\pagestyle{empty}
\renewcommand*{\title}[1]{\gdef \@title {#1}}
\dim_new:N \g_ptxcd_footheight_dim
\dim_gset:Nn \g_ptxcd_footheight_dim {0.06\paperwidth}%
\box_new:N \g_ptxcd_footergraphics_box
\newcommand*{\footergraphics}[1]{
  \begingroup
  \let\height\g_ptxcd_footheight_dim
  \hbox_gset:Nn \g_ptxcd_footergraphics_box {#1}
  \endgroup
}
\tl_new:N \g_ptxcd_poster_foot_tl
\newcommand{\footer}[1]{
  \tl_gset:Nn \g_ptxcd_poster_foot_tl {#1}
}
\tl_new:N \g_ptxcd_poster_qrcode_tl
\msg_new:nnnn {tudapub} {biblatex-required}{
  You~tried~to~use~#1.\\
  This~feature~requires~the~biblatex~package.
} {
  Try~to~remove~the~star~or~load~biblatex.
}
\NewDocumentCommand{\footerqrcode}{sm}{
  \IfBooleanTF {#1} {
    \cs_if_exist:NTF \blx@blxinit {
      \begingroup
      \blx@blxinit
      \entrydata{#2}{
        \tl_gset:Nx \g_ptxcd_poster_qrcode_tl{\thefield{url}}
      }
      \endgroup
    }{
      \msg_error:nnx {tudapub} {biblatex-required} {\use:c{footerqrcode*}}
    }
  }{
    \tl_gset:Nn \g_ptxcd_poster_qrcode_tl {#2}
  }
}
\seq_new:N \g_ptxcd_author_seq
\renewcommand*\author[1]{
  \seq_gset_split:Nnn \g_ptxcd_author_seq {\and} {#1}
}
\msg_new:nnn{tudasciposter} {unknown-language} {
  You~selected~an~unknown~language~#1.\\
  The~Variable~#2~does~not~have~a~predefined~value.\\
  Ensure~to~redefine~#2~to~match~your~language.\\
  Otherwise~the~ngerman~vaue~#3~will~be~used.
}
\providecommand*\authorandname{
  \msg_warning:nnxxx{tudasciposter} {unknown-language}
  {\languagename} {\exp_not:N \authorandname} {und}
  und
}
\defcaptionname{ngerman, german}{\authorandname}{und}
\defcaptionname{english, USenglish, american, UKenglish, british}{\authorandname}{and}
\renewcommand*{\@author}{
  \seq_use:Nnnn \g_ptxcd_author_seq {~\authorandname{}~} {,~} {~\&~}
}
\newcommand\titlegraphic[1]{\def\@titlegraphic{#1}}
\titlegraphic{}
\newcommand{\institute}[1]{\def\@institute{#1}}
\institute{}
\AtBeginDocument{
  \@ifpackageloaded{babel}{
    \addto\extrasngerman{\def\authorandname{und}}
    \addto\extrasgerman{\def\authorandname{und}}
    \addto\extrasenglish{\def\authorandname{and}}
    \addto\extrasbritish{\def\authorandname{and}}
    \addto\captionsngerman{\renewcommand{\figurename}{Abb.}}
    \addto\captionsgerman{\renewcommand{\figurename}{Abb.}}
    \addto\captionsenglish{\renewcommand{\figurename}{Fig.}}
    \addto\captionsbritish{\renewcommand{\figurename}{Fig.}}
  }{}
}
\newlength{\contentwidth}
\setlength{\contentwidth}{\dimexpr\paperwidth-2\g_ptxcd_margin_dim\relax}
\newlength{\contentheight}
\cs_new:Nn \__ptxcd_logo_code:n {
  \node[anchor=north~east,inner~sep=0pt,minimum~width=\dim_eval:n {\__ptxcd_logowidth: + \__ptxcd_logosep:}](#1) at ([xshift=\__ptxcd_logosep:,yshift=-.5\c_ptxcd_logoheight_dim]identbar.south~east){
    \__ptxcd_insert_logo:
  };
}
\tcbposterset{
  coverage =
    {
      spread,
      parbox=false,
      bottom=\dim_eval:n {\g_ptxcd_margin_dim
        \bool_if:NT \g_ptxcd_poster_foot_bool {+\g_ptxcd_footheight_dim + 3\c_ptxcd_rulesep_dim}
      },
      left=\g_ptxcd_margin_dim,
      right=\g_ptxcd_margin_dim,
      before= {\ptxcd_poster_setup_title_box:},
      top= \dim_eval:n {
        \bool_if:NF \g_ptxcd_colorback_bool {1.5}
        \g_ptxcd_margin_dim
        +\box_ht:N \ptxcd_headrule_box
        +\box_dp:N \ptxcd_headrule_box
        +\g_ptxcd_titleblock_dim
        +4\c_ptxcd_rulesep_dim
        +\box_ht:N \g_ptxcd_author_box
        +\box_dp:N \g_ptxcd_author_box
      },
      overlay={%
          \coordinate(topleft) at ([xshift=\g_ptxcd_margin_dim, yshift=-\g_ptxcd_margin_dim]current~page.north~ west);
          \coordinate(topright) at ([xshift=-\g_ptxcd_margin_dim, yshift=-\g_ptxcd_margin_dim]current~page.north~ east);
          \coordinate(bottomleft) at ([xshift=\g_ptxcd_margin_dim, yshift=\g_ptxcd_margin_dim]current~page.south~ west);
          \coordinate(bottomright) at ([xshift=-\g_ptxcd_margin_dim, yshift=\g_ptxcd_margin_dim]current~page.south~ east);
          \dim_gset:Nn \g_ptxcd_titleindent_dim {\bool_if:NTF \g_ptxcd_colorback_bool {3\c_ptxcd_rulesep_dim} {\c_zero_dim}}
          \node[inner~sep=0pt, anchor=north~west](identbar) at (topleft){\ptxcd_headrule};
          \bool_if:NTF \g_ptxcd_colorback_bool
          \fill \path [identbarcolor]
          (identbar.south~east)rectangle([yshift=-\g_ptxcd_titleblock_dim]identbar.south~west) coordinate(bottomlefttitleblock);
          \__ptxcd_logo_code:n {TUDalogo}
          \node[inner~sep=0pt,text~width=\__ptxcd_logowidth:,align=right,anchor=north~west,](titlegraphic) at ([yshift=-\c_ptxcd_rulesep_dim]TUDalogo.south~west){\box_use:N \g_ptxcd_titlegraphic_box};
          \node[anchor=north~west,inner~sep=0pt,]  (title) at ([
            xshift=\g_ptxcd_titleindent_dim,yshift=-.5\c_ptxcd_logoheight_dim]identbar.south~west) {\box_use:N \g_ptxcd_title_box};
          \bool_if:NT \g_ptxcd_titlesepline_bool
          {\draw[line~ width=.5\c_ptxcd_smallrule_dim](bottomlefttitleblock)--++(\contentwidth,0);}
          \node[anchor=north~west, inner~xsep=0pt, inner~ ysep=\c_ptxcd_rulesep_dim] (author) at ([xshift=\g_ptxcd_titleindent_dim]bottomlefttitleblock) {\box_use:N \g_ptxcd_author_box};
          \draw[line~ width=.5\c_ptxcd_smallrule_dim](author.south-|identbar.west)--++(\contentwidth,0);
          \bool_if:NT \g_ptxcd_poster_foot_bool {\__ptxcd_typeset_footer:}
        }}
}
\cs_new:Nn \__ptxcd_typeset_footer: {
  \coordinate(lastpos) at (bottomright);
  \tl_if_empty:NF \g_ptxcd_poster_qrcode_tl
  {
    \node[anchor=south~east, inner~sep=\z@] (qrcode)at (lastpos)
    {
      \exp_args:NnV \use:n {\qrcode[height=\dim_use:N \g_ptxcd_footheight_dim]}\g_ptxcd_poster_qrcode_tl
    };
    \coordinate (lastpos) at (qrcode.south~west);
  }
  \box_if_empty:NF \g_ptxcd_footergraphics_box {
    \node[anchor=south~east, inner~sep=\z@] at (lastpos) {
      \accentfont
      \box_use:N \g_ptxcd_footergraphics_box
    };
  }
  \node[anchor=north~ west, inner~ sep=\z@] (infofooter) at ([yshift=\g_ptxcd_footheight_dim]bottomleft) {
    \parbox{\dim_eval:n {\contentwidth
        -\box_wd:N \g_ptxcd_footergraphics_box
        \tl_if_empty:NF \g_ptxcd_poster_qrcode_tl {-\g_ptxcd_footheight_dim-\c_ptxcd_rulesep_dim}
      }}{
      \rule{\linewidth}{.5\c_ptxcd_smallrule_dim}\\
      \accentfont\small\g_ptxcd_poster_foot_tl
      \par\medskip
      \let\footnotetext\ptxcd_title@footnote
      \g_ptxcd_thanks_tl}
  };
}
\hook_gput_code:nnn {ptxcd/init-colors} {tudasciposter} {
\bool_if:NTF \g_ptxcd_colorback_bool
{\colorlet{titlefgcolor}{textonaccentcolor}}
{\colorlet{titlefgcolor}{black}}
\colorlet{titlebgcolor}{accentcolor}
\colorlet{blocktitlebgcolor}{accentcolor}
\colorlet{blocktitlefgcolor}{textonaccentcolor}
\colorlet{innerblockbodybgcolor}{textonaccentcolor}
}
\colorlet{backgroundcolor}{white}
\colorlet{framecolor}{white}
\colorlet{blockbodybgcolor}{white}
\colorlet{blockbodyfgcolor}{black}
\colorlet{innerblocktitlebgcolor}{black!15}
\colorlet{innerblocktitlefgcolor}{black}
\colorlet{innerblockbodyfgcolor}{black}
\dim_new:N \g_ptxcd_titleblock_dim
\dim_new:N \g_ptxcd_titleindent_dim
\cs_new:Nn \__ptxcd_inst:n {\textsuperscript{#1}}
\cs_new:Nn \ptxcd_poster_setup_title_box: {
  \hbox_gset:Nn \g_ptxcd_title_box {
    \parbox{.65\paperwidth}{
      \raggedright
      \usekomafont{disposition}\usekomafont{title}\leavevmode\@title \par
    }
  }
  \hbox_gset:Nn \g_ptxcd_author_box {
    \parbox{\dimexpr\contentwidth-6\c_ptxcd_rulesep_dim\relax}{
      \ptxcd_def_footnotelabel:
      \cs_set_eq:NN \inst\__ptxcd_inst:n
      {\usekomafont{author}\@author\\}
      \tl_gset:No \g_ptxcd_thanks_tl {\@thanks}
      \@institute
    }
  }
  \tl_if_empty:NF \@titlegraphic {
    \hbox_gset:Nn \g_ptxcd_titlegraphic_box {
      \parbox{\__ptxcd_logowidth:}{
        \raggedleft
        \@titlegraphic
      }
    }
  }
  \dim_gset:Nn \g_ptxcd_titleblock_dim {
    \dim_max:nn
    {
      +\box_ht:N \g_ptxcd_titlegraphic_box +\box_dp:N \g_ptxcd_titlegraphic_box+ 2\c_ptxcd_logoheight_dim
    }
    {\box_ht:N \g_ptxcd_title_box+ \box_dp:N \g_ptxcd_title_box+\c_ptxcd_logoheight_dim}
  }
}
\tcbset {
TUDa/.style =
{
enhanced,
coltitle=black,
colbacktitle=white,
coltext=black,
colback=white,
size=minimal,
boxrule=.5\c_ptxcd_smallrule_dim,
leftrule=\z@,
rightrule=\z@,
fonttitle=\usekomafont{disposition}\usekomafont{section},
before~title={\strut},
toptitle=.5\c_ptxcd_rulesep_dim,
bottomtitle=.5\c_ptxcd_rulesep_dim,
top=\c_ptxcd_rulesep_dim,
bottom=\c_ptxcd_rulesep_dim,
frame~code={
\iftcb@hasTitle
  \fill[tcbcolframe](frame.north~west)rectangle(title.north~east);
  \fill[tcbcolframe](title.south~west)rectangle(interior.north~east);
\else
  \fill[tcbcolframe](frame.north~west)rectangle(interior.north~east);
\fi
\fill[tcbcolframe](interior.south~west)rectangle(frame.south~east);
},
parbox=false,
},
TUDa-inner/.style =
  {
    TUDa,
    fonttitle=\usekomafont{disposition}\usekomafont{subsubsection}
  },
TUDa-colored/.style =
  {
    TUDa,
    left=.5\c_ptxcd_rulesep_dim,
    right=.5\c_ptxcd_rulesep_dim,
    colbacktitle=blocktitlebgcolor,
    coltitle=blocktitlefgcolor,
    colback=blockbodybgcolor,
    coltext=blockbodyfgcolor,
    fonttitle=\usekomafont{disposition}\usekomafont{section},
    titlerule=\z@,
  },
TUDa-colored-inner/.style =
  {
    TUDa-colored,
    colbacktitle=innerblocktitlebgcolor,
    coltitle=innerblocktitlefgcolor,
    colback=innerblockbodybgcolor,
    coltext=innerblockbodyfgcolor,
    fonttitle=\usekomafont{disposition}\usekomafont{subsubsection}
  },
TUDa-boxed/.style =
{
enhanced,
size=minimal,
colbacktitle=blocktitlebgcolor,
coltitle=blocktitlefgcolor,
colback=blockbodybgcolor,
coltext=blockbodyfgcolor,
boxsep=\c_ptxcd_rulesep_dim,
boxrule=.5\c_ptxcd_smallrule_dim,
titlerule=\z@,
arc=1ex,
auto~outer~arc,
fonttitle=\usekomafont{disposition}\usekomafont{section},
before~title={\strut},
parbox=false,
},
TUDa-boxed-inner/.style =
  {
    TUDa-boxed,
    colbacktitle=innerblocktitlebgcolor,
    coltitle=innerblocktitlefgcolor,
    colback=innerblockbodybgcolor,
    coltext=innerblockbodyfgcolor,
    sharp~corners,
    fonttitle=\usekomafont{disposition}\usekomafont{subsubsection}
  },
}
\tcbposterset{boxes ={\g_ptxcd_boxstyle_tl}, poster={spacing=5cm}}
\tcbset{
every~ box~ on~ layer~ 3/.style={reset,\g_ptxcd_boxstyle_tl -inner},
every~ box~ on~ layer~ 4/.style={reset,\g_ptxcd_boxstyle_tl -inner},
}
\setcapindent{1em}
\file_if_exist_input:n {\g__ptxcd_config_prefix_tl\g_ptxcd_department_str.cfg}
\hook_use:n {ptxcd/init-colors}
\ptxcd_makeheadrule[
  width=\paperwidth-2\g_ptxcd_margin_dim,
  color=identbarcolor
]{ptxcd_headrule}
\if_bool:N \g_ptxcd_pdfx_bool
  \iow_new:N \ptxcd_xmpdata_stream
  \tl_new:N \g_ptxcd_xmp_title_tl
  \tl_new:N \g_ptxcd_xmp_author_tl

  \cs_if_exist:NF \prop_gput_if_new:Nnx {
    \cs_generate_variant:Nn \prop_gput_if_new:Nnn {Nnx}
  }

  \cs_if_exist:NF \tl_to_str:V {\cs_generate_variant:Nn \tl_to_str:N {V}}

  \cs_new:Nn \ptxcd_pass_TitleData: {
    \iow_open:Nn \ptxcd_xmpdata_stream {\jobname.xmpdata}
    \begingroup
      \def\newline{}
      \def\\{}
      \let\thanks\use_none:n
      \cs_set:Npn \and {\exp_not:n {\exp_not:N \sep}}
      \use:c {Hy@pdfstringtrue}
      \tl_gset:Nf \g_ptxcd_xmp_title_tl {\@title}
      \prop_gput_if_new:Nnx \g_ptxcd_MetaData_prop {Title} {\tl_to_str:V \g_ptxcd_xmp_title_tl}
      \prop_if_in:NnF \g_ptxcd_MetaData_prop {Author} {
        \tl_gset:Nx \g_ptxcd_xmp_author_tl {\seq_use:Nn \g_ptxcd_author_seq {\exp_not:N \sep}}
        \tl_gset:Nx \g_ptxcd_xmp_author_tl {\g_ptxcd_xmp_author_tl}
        \prop_gput:Nnx \g_ptxcd_MetaData_prop {Author} {\tl_to_str:V \g_ptxcd_xmp_author_tl}
      }
      \prop_gput_if_new:Nnn \g_ptxcd_MetaData_prop {Publisher}{TU~Darmstadt}
      \prop_gput_if_new:Nnn \g_ptxcd_MetaData_prop {Creator}{LaTeX~using~TUDa-CI}
      \use:c {pdfx@localcommands}%should be held inside group
      \prop_map_function:NN \g_ptxcd_MetaData_prop  \ptxcd_write_xmp_line:nn
    \endgroup
    \iow_close:N \ptxcd_xmpdata_stream
    \let\ptxcd_pass_TitleData:\relax
  }
  \cs_new:Nn \ptxcd_write_xmp_line:nn {
    \begingroup
    \cs_set:Npn \sep {\exp_not:N \sep}
    \cs_if_exist:cTF {#1}{
      \iow_now:Nx \ptxcd_xmpdata_stream {
        \c_backslash_str #1 {\exp_not:n {#2}}
      }
    }{
      \msg_error:nnn{tuda-ci} {unknown-metadata} {#1}
    }
    \endgroup
  }

  \prop_new:N \g_ptxcd_MetaData_prop

  \newcommand*{\Metadata}[1]{
    \keyval_parse:NNn  \use_none:n \ptxcd_set_metadata_prop:nn
    {#1}
  }

  \cs_set:Nn \ptxcd_set_metadata_prop:nn {
  % Fallback test for older kernels doesn't support mixed case eintries
    \cs_if_exist:NTF \text_titlecase_first:n {
      \exp_args:NNf \prop_gput:Nnn \g_ptxcd_MetaData_prop {\text_titlecase_first:n {#1}} {#2}
    } {
      \exp_args:NNx \prop_gput:Nnn \g_ptxcd_MetaData_prop {
        \str_uppercase:f {\tl_head:n {#1}}
        \str_lowercase:f {\tl_tail:n {#1}}
      } {#2}
    }
  }
  \msg_new:nnnn{tuda-ci} {unknown-metadata} {
    You~ used~ the~ #1~ metadata~ entry.\\
    I~ don't~ know~ how~ to~ handle~ that.\\
    It~ will~ be~ ignored.
  } {See~ TUDa-CI~ or~ pdfx~ documentation~ for~ details.}
\else:
  \hypersetup{pdfcreator=LaTeX~using~TUDa-CI}
  \msg_new:nnnn {tuda-ci} {metadata-to-hypersetup} {
    You~don't~use~pdfx.~
    Here~the~\string\Metadata ~command~only~exists~for~compatibility~reasons.\\
    I~will~pass~the~data~to~ḩypersetup.
  }{
    If~possible~please~use~hyperref's~\string\hypersetup~command~for~the~metadata~directly.\\
    See~hyperref~documentation~for~details~on~usage.
  }

    \newcommand*{\Metadata}[1]{
      \tl_set:Nn \l_tmpa_tl {#1}
      \tl_replace_all:Nnn \l_tmpa_tl {\sep} {;~}% pdfx-Syntax compatibility
      \clist_map_inline:Nn \l_tmpa_tl {
        \exp_args:Nx \hypersetup{pdf\tl_trim_spaces:n {##1}}
      }
      \msg_warning:nn {tuda-ci} {metadata-to-hypersetup}
    }
    \cs_new:Nn \ptxcd_pass_TitleData: {
      \prop_if_exist:NTF \g__pdfmanagement_documentproperties_prop {
        \prop_set_eq:NN \l_tmpa_prop \g__pdfmanagement_documentproperties_prop
      } {
        \prop_set_eq:NN \l_tmpa_prop   \g__hyp_documentproperties_prop
      }
      \prop_if_in:NnF \l_tmpa_prop {hyperref/pdftitle} {
      \begingroup
        \def\newline{}
        \def\\{}
        \let\thanks\use_none:n
        \tl_gset:Nf \g_tmpa_tl {\@title}
      \endgroup
      \hypersetup{pdftitle={\tl_to_str:V \g_tmpa_tl}}
      }
      \prop_if_in:NnF \l_tmpa_prop {hyperref/pdfauthor} {
        \begingroup
          \def\newline{}
          \def\\{}
          \let\thanks\use_none:n
          \tl_gset:Nx \g_tmpa_tl {\seq_use:Nn \g_ptxcd_author_seq {\exp_not:N \and}}
          \tl_gset:Nx \g_tmpa_tl  {\g_tmpa_tl }
        \endgroup
        \hypersetup{pdfauthor=\g_tmpa_tl}
      }
    }
    \bool_if:NF \g_ptxcd_pdfa_bool {
      \msg_new:nnn{tuda-ci} {no-pdfa}{The~ tuda\c__ptxcd_base_str\space class~ will~ not~ create~ PDF/A.}
      \msg_info:nn{tuda-ci} {no-pdfa}
    }
\fi:
\endinput
%%
%% End of file `tudasciposter.cls'.
